/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.library.LibrarySelected;
import org.limewire.ui.swing.library.table.RemoveFromAllListAction;
import org.limewire.ui.swing.library.table.RemoveFromLibraryAction;
import org.limewire.ui.swing.util.I18n;

public class RemoveFromListMenu
extends JMenu {
    @Inject
    public RemoveFromListMenu(final @LibrarySelected Provider<List<File>> selectedFiles, final RemoveFromLibraryAction removeFromLibraryAction, final RemoveFromAllListAction removeFromAllAction, final SharedFileListManager manager) {
        super(I18n.tr("Remove from"));
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RemoveFromListMenu menu = RemoveFromListMenu.this;
                menu.removeAll();
                removeFromAllAction.putValue("Name", I18n.tr("All Lists"));
                menu.add(removeFromAllAction).setEnabled(RemoveFromListMenu.this.isAllRemovedEnabled(manager, selectedFiles));
                menu.addSeparator();
                menu.add(removeFromLibraryAction);
            }
        });
        this.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (RemoveFromListMenu.this.getPopupMenu().getPreferredSize().width > 300) {
                    RemoveFromListMenu.this.getPopupMenu().setPreferredSize(new Dimension(300, RemoveFromListMenu.this.getPopupMenu().getPreferredSize().height));
                }
            }
        });
        this.add(new JMenuItem(I18n.tr("empty")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllRemovedEnabled(SharedFileListManager manager, Provider<List<File>> selectedFiles) {
        boolean enabled = false;
        if (selectedFiles.get().size() == 1) {
            manager.getModel().getReadWriteLock().readLock().lock();
            try {
                for (SharedFileList fileList : manager.getModel()) {
                    boolean isEnabled = fileList.contains(selectedFiles.get().get(0));
                    enabled |= isEnabled;
                }
            }
            finally {
                manager.getModel().getReadWriteLock().readLock().unlock();
            }
        } else {
            enabled = true;
        }
        return enabled;
    }
}

