/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.downloads.table.DownloadStateMatcher;
import org.limewire.ui.swing.util.I18n;

class FixStalledDownloadsAction
extends AbstractAction {
    private final DownloadMediator downloadMediator;

    @Inject
    public FixStalledDownloadsAction(DownloadMediator downloadMediator) {
        super(I18n.tr("Fix Stalled Downloads"));
        this.downloadMediator = downloadMediator;
    }

    @Inject
    public void register(DownloadMediator downloadMediator) {
        FilterList<DownloadItem> stalledList = GlazedListsFactory.filterList(downloadMediator.getDownloadList(), new DownloadStateMatcher(DownloadState.STALLED, new DownloadState[0]));
        stalledList.addListEventListener(new ListEventListener<DownloadItem>(){

            @Override
            public void listChanged(ListEvent<DownloadItem> listChanges) {
                FixStalledDownloadsAction.this.setEnabled(listChanges.getSourceList().size() != 0);
            }
        });
        this.setEnabled(stalledList.size() != 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.downloadMediator.fixStalled();
    }
}

