/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import java.text.NumberFormat;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.ui.swing.options.LimeSlider;
import org.limewire.ui.swing.util.I18n;

public class SeedRatioSlider
extends LimeSlider {
    public static final int MIN_SLIDER = ((Float)BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getMinValue()).intValue();
    public static final int MAX_SLIDER = ((Float)BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getMaxValue()).intValue();

    public SeedRatioSlider() {
        super(MIN_SLIDER * 10, MAX_SLIDER * 10);
    }

    @Override
    public String getMessage(int value) {
        if (value >= this.getModel().getMaximum()) {
            return I18n.tr("Unlimited");
        }
        Float f = new Float((float)value / 10.0f);
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(2);
        String labelText = String.valueOf(formatter.format(f));
        return labelText;
    }

    public float getSeedRatio() {
        int value = this.getValue();
        if (value == this.getModel().getMaximum()) {
            return ((Float)BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getMaxValue()).floatValue();
        }
        return (float)value / 10.0f;
    }

    public void setSeedRatio(float value) {
        this.setValue((int)(value * 10.0f));
    }
}

