/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.limewire.bittorrent.TorrentFileEntry;
import org.limewire.listener.SwingSafePropertyChangeSupport;

public class TorrentFileEntryWrapper {
    private final PropertyChangeSupport support = new SwingSafePropertyChangeSupport(this);
    private TorrentFileEntry entry;
    private int priority;
    private final String subPath;

    public TorrentFileEntryWrapper(TorrentFileEntry entry) {
        this.entry = entry;
        this.priority = entry.getPriority();
        this.subPath = TorrentFileEntryWrapper.getSubPath(entry.getPath());
    }

    public String getPath() {
        return this.subPath;
    }

    public long getSize() {
        return this.entry.getSize();
    }

    public float getProgress() {
        return this.entry.getProgress();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public TorrentFileEntry getTorrentFileEntry() {
        return this.entry;
    }

    public void setTorrentFileEntry(TorrentFileEntry newEntry) {
        TorrentFileEntry oldEntry = this.entry;
        this.entry = newEntry;
        this.support.firePropertyChange("entry", oldEntry, newEntry);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public boolean hasChanged() {
        return this.getPriority() != this.getTorrentFileEntry().getPriority();
    }

    private static String getSubPath(String path) {
        int index = path.indexOf("/");
        if (index >= 0 && index + 1 < path.length()) {
            return path.substring(index + 1);
        }
        return path;
    }
}

