/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.URN;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.search.SearchResult;
import org.limewire.friend.api.Friend;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.model.VisualSearchResultStatusListener;
import org.limewire.ui.swing.util.PropertiableFileUtils;
import org.limewire.ui.swing.util.PropertiableHeadings;
import org.limewire.util.Objects;

class SearchResultAdapter
implements VisualSearchResult,
Comparable {
    private static final Log LOG = LogFactory.getLog(SearchResultAdapter.class);
    private static final Matcher FIND_HTML_MARKUP;
    private static final Comparator<RemoteHost> REMOTE_HOST_COMPARATOR;
    private static final Comparator<Friend> FRIEND_COMPARATOR;
    private List<SearchResult> coreResults;
    private Set<Friend> friends;
    private final Set<RemoteHost> remoteHosts;
    private final Provider<PropertiableHeadings> propertiableHeadings;
    private BasicDownloadState downloadState = BasicDownloadState.NOT_STARTED;
    private CopyOnWriteArrayList<VisualSearchResult> similarResults = null;
    private VisualSearchResult similarityParent;
    private boolean anonymous;
    private boolean visible;
    private boolean childrenVisible;
    private Boolean spamCache;
    private boolean preExistingDownload = false;
    private float relevance = 0.0f;
    private String cachedHeading;
    private String cachedSubHeading;
    private final VisualSearchResultStatusListener changeListener;

    public SearchResultAdapter(SearchResult source, Provider<PropertiableHeadings> propertiableHeadings, VisualSearchResultStatusListener changeListener, String query) {
        this.propertiableHeadings = propertiableHeadings;
        this.remoteHosts = new TreeSet<RemoteHost>(REMOTE_HOST_COMPARATOR);
        this.visible = true;
        this.childrenVisible = false;
        this.changeListener = changeListener;
        this.addNewSource(source, query);
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public Category getCategory() {
        return this.coreResults.get(0).getCategory();
    }

    @Override
    public List<SearchResult> getCoreSearchResults() {
        return this.coreResults;
    }

    @Override
    public String getFileExtension() {
        return this.coreResults.get(0).getFileExtension();
    }

    @Override
    public String getFileName() {
        return this.coreResults.get(0).getFileName();
    }

    @Override
    public Collection<Friend> getFriends() {
        return this.friends == null ? Collections.emptySet() : this.friends;
    }

    @Override
    public Object getProperty(FilePropertyKey key) {
        for (SearchResult result : this.coreResults) {
            Object value = result.getProperty(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public String getPropertyString(FilePropertyKey key) {
        Object value = this.getProperty(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public String getNameProperty(boolean useAudioArtist) {
        return PropertiableFileUtils.getNameProperty(this, useAudioArtist);
    }

    @Override
    public void addSimilarSearchResult(VisualSearchResult similarResult) {
        assert (similarResult != this);
        if (this.similarResults == null) {
            this.similarResults = new CopyOnWriteArrayList();
        }
        this.similarResults.addIfAbsent(similarResult);
    }

    @Override
    public void removeSimilarSearchResult(VisualSearchResult result) {
        if (this.similarResults != null) {
            this.similarResults.remove(result);
        }
    }

    @Override
    public List<VisualSearchResult> getSimilarResults() {
        return this.similarResults == null ? Collections.emptyList() : this.similarResults;
    }

    @Override
    public void setSimilarityParent(VisualSearchResult parent) {
        VisualSearchResult oldParent = this.similarityParent;
        this.similarityParent = parent;
        this.firePropertyChange("similarityParent", oldParent, parent);
    }

    @Override
    public VisualSearchResult getSimilarityParent() {
        return this.similarityParent;
    }

    @Override
    public long getSize() {
        return this.coreResults.get(0).getSize();
    }

    @Override
    public Collection<RemoteHost> getSources() {
        return this.remoteHosts;
    }

    @Override
    public BasicDownloadState getDownloadState() {
        return this.downloadState;
    }

    @Override
    public void setDownloadState(BasicDownloadState downloadState) {
        if (downloadState == BasicDownloadState.NOT_STARTED) {
            boolean oldSpam = this.isSpam();
            this.spamCache = null;
            boolean newSpam = this.isSpam();
            this.firePropertyChange("spam-core", oldSpam, newSpam);
        }
        BasicDownloadState oldDownloadState = this.downloadState;
        this.downloadState = downloadState;
        this.firePropertyChange("downloadState", (Object)oldDownloadState, (Object)downloadState);
    }

    public String toString() {
        return this.getCoreSearchResults().toString();
    }

    void addNewSource(SearchResult result, String query) {
        if (this.coreResults == null) {
            this.coreResults = Collections.singletonList(result);
        } else {
            if (this.coreResults.size() == 1) {
                this.coreResults = new ArrayList<SearchResult>(this.coreResults);
            }
            this.coreResults.add(result);
        }
        this.relevance += result.getRelevance(query);
        for (RemoteHost host : result.getSources()) {
            this.remoteHosts.add(host);
            Friend friend = host.getFriendPresence().getFriend();
            if (friend.isAnonymous()) {
                this.anonymous = true;
                continue;
            }
            if (this.friends == null) {
                this.friends = Collections.singleton(friend);
                continue;
            }
            if (!(this.friends instanceof TreeSet)) {
                TreeSet<Friend> newFriends = new TreeSet<Friend>(FRIEND_COMPARATOR);
                newFriends.addAll(this.friends);
                this.friends = newFriends;
            }
            this.friends.add(friend);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldValue, visible);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Updating visible to {0} for urn: {1}", (Object)visible, (Object)this.getUrn());
        }
    }

    @Override
    public boolean isChildrenVisible() {
        return this.childrenVisible;
    }

    @Override
    public boolean isSpam() {
        if (this.spamCache == null) {
            boolean spam = false;
            for (SearchResult result : this.coreResults) {
                spam |= result.isSpam();
            }
            this.spamCache = spam;
        }
        return this.spamCache;
    }

    @Override
    public void setSpam(boolean spam) {
        boolean oldSpam = this.isSpam();
        this.spamCache = spam;
        this.firePropertyChange("spam-ui", oldSpam, spam);
    }

    @Override
    public void setChildrenVisible(boolean childrenVisible) {
        boolean oldChildrenVisible = childrenVisible;
        this.childrenVisible = childrenVisible;
        for (VisualSearchResult similarResult : this.getSimilarResults()) {
            similarResult.setVisible(childrenVisible);
            similarResult.setChildrenVisible(false);
        }
        this.firePropertyChange("childrenVisible", oldChildrenVisible, childrenVisible);
    }

    @Override
    public void toggleChildrenVisibility() {
        this.setChildrenVisible(!this.isShowingSimilarResults());
    }

    private boolean isShowingSimilarResults() {
        return this.getSimilarResults().size() > 0 && this.isChildrenVisible();
    }

    @Override
    public URN getUrn() {
        return this.coreResults.get(0).getUrn();
    }

    public URN getNavSelectionId() {
        return this.getUrn();
    }

    @Override
    public String getMagnetLink() {
        if (this.getCoreSearchResults().size() > 0) {
            return this.getCoreSearchResults().get(0).getMagnetURL();
        }
        return null;
    }

    @Override
    public String getHeading() {
        if (this.cachedHeading == null) {
            this.cachedHeading = this.sanitize(this.propertiableHeadings.get().getHeading(this));
        }
        return this.cachedHeading;
    }

    private String sanitize(String input) {
        Matcher matcher = FIND_HTML_MARKUP.reset(input);
        if (matcher.find()) {
            this.setSpam(true);
            return matcher.replaceAll("");
        }
        return input;
    }

    @Override
    public String getSubHeading() {
        if (this.cachedSubHeading == null) {
            this.cachedSubHeading = this.sanitize(this.propertiableHeadings.get().getSubHeading(this));
        }
        return this.cachedSubHeading;
    }

    @Override
    public float getRelevance() {
        return this.relevance;
    }

    @Override
    public boolean isLicensed() {
        for (SearchResult searchResult : this.coreResults) {
            if (!searchResult.isLicensed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPreExistingDownload() {
        return this.preExistingDownload;
    }

    @Override
    public void setPreExistingDownload(boolean preExistingDownload) {
        this.preExistingDownload = preExistingDownload;
    }

    public int compareTo(Object o) {
        if (!(o instanceof SearchResultAdapter)) {
            return -1;
        }
        SearchResultAdapter sra = (SearchResultAdapter)o;
        return this.getHeading().compareTo(sra.getHeading());
    }

    private void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.changeListener.resultChanged(this, propertyName, oldValue, newValue);
        }
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!Objects.equalOrNull(oldValue, newValue)) {
            this.changeListener.resultChanged(this, propertyName, oldValue, newValue);
        }
    }

    static {
        Pattern p = Pattern.compile("[<][/]?[\\w =\"\\./:#\\-\\!\\&\\?]*[>]");
        FIND_HTML_MARKUP = p.matcher("");
        REMOTE_HOST_COMPARATOR = new RemoteHostComparator();
        FRIEND_COMPARATOR = new FriendComparator();
    }

    private static class FriendComparator
    implements Comparator<Friend> {
        private FriendComparator() {
        }

        @Override
        public int compare(Friend o1, Friend o2) {
            String id1 = o1.getId();
            String id2 = o2.getId();
            return Objects.compareToNullIgnoreCase(id1, id2, false);
        }
    }

    private static class RemoteHostComparator
    implements Comparator<RemoteHost> {
        private RemoteHostComparator() {
        }

        @Override
        public int compare(RemoteHost o1, RemoteHost o2) {
            boolean anonymous2;
            int compare = 0;
            boolean anonymous1 = o1.getFriendPresence().getFriend().isAnonymous();
            if (anonymous1 == (anonymous2 = o2.getFriendPresence().getFriend().isAnonymous())) {
                compare = o1.getFriendPresence().getFriend().getRenderName().compareToIgnoreCase(o2.getFriendPresence().getFriend().getRenderName());
            } else if (anonymous1) {
                compare = 1;
            } else if (anonymous2) {
                compare = -1;
            }
            return compare;
        }
    }
}

