/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoDialogFactory;
import org.limewire.ui.swing.search.BlockUserMenuFactory;
import org.limewire.ui.swing.search.RemoteHostMenuFactory;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.DownloadHandler;
import org.limewire.ui.swing.util.FileChooser;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingHacks;

public class SearchResultMenu
extends JPopupMenu {
    @Inject
    public SearchResultMenu(final @Assisted DownloadHandler downloadHandler, final @Assisted List<VisualSearchResult> selectedItems, final FileInfoDialogFactory fileInfoFactory, RemoteHostMenuFactory browseMenuFactory, BlockUserMenuFactory blockUserMenuFactory, final LibraryMediator libraryMediator, @Assisted ViewType viewType) {
        SwingHacks.fixPopupMenuForWindows(this);
        final VisualSearchResult firstItem = selectedItems.get(0);
        boolean downloadEnabled = false;
        for (VisualSearchResult visualSearchResult : selectedItems) {
            if (visualSearchResult.getDownloadState() != BasicDownloadState.NOT_STARTED || visualSearchResult.isSpam()) continue;
            downloadEnabled = true;
            break;
        }
        boolean locateInLibraryVisible = firstItem.getDownloadState() == BasicDownloadState.LIBRARY || firstItem.getDownloadState() == BasicDownloadState.DOWNLOADED;
        boolean showHideSimilarFileVisible = selectedItems.size() == 1 && firstItem.getSimilarResults().size() > 0 && viewType == ViewType.List;
        boolean showHideSimilarFileEnabled = selectedItems.size() == 1 && firstItem.getDownloadState() == BasicDownloadState.NOT_STARTED;
        boolean viewFileInfoEnabled = selectedItems.size() == 1;
        boolean downloadAsVisible = selectedItems.size() == 1;
        this.add(new AbstractAction(I18n.tr("Download")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (VisualSearchResult visualSearchResult : selectedItems) {
                    if (visualSearchResult.getDownloadState() != BasicDownloadState.NOT_STARTED) continue;
                    downloadHandler.download(visualSearchResult);
                }
            }
        }).setEnabled(downloadEnabled);
        if (downloadAsVisible) {
            this.add(new AbstractAction(I18n.tr("Download As...")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (VisualSearchResult visualSearchResult : selectedItems) {
                        if (visualSearchResult.getDownloadState() != BasicDownloadState.NOT_STARTED) continue;
                        String fileName = visualSearchResult.getFileName();
                        File suggestedFile = new File(fileName);
                        File saveFile = FileChooser.getSaveAsFile(GuiUtils.getMainFrame(), I18n.tr("Download As"), suggestedFile);
                        if (saveFile == null) continue;
                        downloadHandler.download(visualSearchResult, saveFile);
                    }
                }
            }).setEnabled(downloadEnabled);
        }
        this.add(new AbstractAction(firstItem.isSpam() ? I18n.tr("Unmark as Spam") : I18n.tr("Mark as Spam")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean spam = !firstItem.isSpam();
                for (VisualSearchResult visualSearchResult : selectedItems) {
                    visualSearchResult.setSpam(spam);
                }
            }
        });
        this.addSeparator();
        if (locateInLibraryVisible) {
            this.add(new AbstractAction(I18n.tr("Locate in Library")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    libraryMediator.selectInLibrary(firstItem.getUrn());
                }
            });
            this.addSeparator();
        }
        if (showHideSimilarFileVisible) {
            this.add(new AbstractAction(firstItem.isChildrenVisible() ? I18n.tr("Hide Similar Files") : I18n.tr("Show Similar Files")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    firstItem.toggleChildrenVisibility();
                }
            }).setEnabled(showHideSimilarFileEnabled);
            this.addSeparator();
        }
        ArrayList<RemoteHost> allHosts = new ArrayList<RemoteHost>();
        for (VisualSearchResult result : selectedItems) {
            allHosts.addAll(result.getSources());
        }
        if (allHosts.size() > 0) {
            this.add(browseMenuFactory.createBrowseMenu(allHosts));
            JMenu blockUserMenu = blockUserMenuFactory.createSearchBlockMenu(allHosts, selectedItems);
            if (blockUserMenu != null) {
                this.add(blockUserMenu);
                this.addSeparator();
            }
        }
        this.add(new AbstractAction(I18n.tr("View File Info...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileInfoDialog dialog = fileInfoFactory.createFileInfoDialog(firstItem, FileInfoDialog.FileInfoType.REMOTE_FILE);
                dialog.setVisible(true);
            }
        }).setEnabled(viewFileInfoEnabled);
    }

    public static enum ViewType {
        List,
        Table;

    }
}

