/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.search.resultpanel.SearchResultTruncator;

@LazySingleton
public class SearchResultTruncatorImpl
implements SearchResultTruncator {
    private static final String SINGLE_SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String OPEN_TAG = "<b>";
    private static final String CLOSE_TAG = "</b>";
    private static final String ELLIPSIS = "...";
    private static final int ELLIPSIS_SHRINK_INCREMENT = "...".length() + 1;
    private final Matcher findHTMLMinusBoldTags;
    private final Matcher findMultipleWhitespaceChars;
    private final Matcher findWhitespaceMinusSpaceChars;

    public SearchResultTruncatorImpl() {
        Pattern patternHTMLMinusBoldTags = Pattern.compile("[<][/]?[\\w =\":#&&[^b]]*[>]");
        this.findHTMLMinusBoldTags = patternHTMLMinusBoldTags.matcher(EMPTY_STRING);
        Pattern patternMultipleWhitespaceChars = Pattern.compile("[\\s]++");
        this.findMultipleWhitespaceChars = patternMultipleWhitespaceChars.matcher(EMPTY_STRING);
        Pattern patternWhitespaceMinusSpaceChars = Pattern.compile("[\\s&&[^ ]]");
        this.findWhitespaceMinusSpaceChars = patternWhitespaceMinusSpaceChars.matcher(EMPTY_STRING);
    }

    @Override
    public String truncateHeading(String headingText, int visibleWidthPixels, SearchResultTruncator.FontWidthResolver resolver) {
        if (resolver.getPixelWidth(headingText = this.replaceAll(this.findHTMLMinusBoldTags, headingText, EMPTY_STRING)) <= visibleWidthPixels) {
            return headingText;
        }
        String truncated = this.replaceAll(this.findMultipleWhitespaceChars, headingText, SINGLE_SPACE);
        truncated = this.replaceAll(this.findWhitespaceMinusSpaceChars, truncated, EMPTY_STRING);
        while (truncated.length() >= ELLIPSIS_SHRINK_INCREMENT) {
            if (this.getEndEdge(truncated) >= truncated.length() - (truncated.contains(ELLIPSIS) ? ELLIPSIS.length() : 0)) {
                truncated = ELLIPSIS + truncated.substring(ELLIPSIS_SHRINK_INCREMENT);
            } else if (this.getLeadEdge(truncated) >= 0) {
                truncated = truncated.substring(0, truncated.length() - ELLIPSIS_SHRINK_INCREMENT) + ELLIPSIS;
            }
            if (resolver.getPixelWidth(truncated) > visibleWidthPixels) continue;
        }
        return truncated;
    }

    private String replaceAll(Matcher pattern, String source, String replacement) {
        return pattern.reset(source).replaceAll(replacement);
    }

    private int getLeadEdge(String headingText) {
        int indexOf = headingText.indexOf(OPEN_TAG);
        return indexOf == -1 ? 0 : indexOf;
    }

    private int getEndEdge(String headingText) {
        int closeIndex = headingText.indexOf(CLOSE_TAG);
        return closeIndex == -1 ? 0 : closeIndex + CLOSE_TAG.length();
    }
}

