/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel.classic;

import java.awt.Component;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.util.I18n;

public class ImageTableFormat
extends ResultsTableFormat<VisualSearchResult> {
    static final int FROM_INDEX = 0;
    static final int NAME_INDEX = 1;
    static final int EXTENSION_INDEX = 2;
    static final int DATE_INDEX = 3;
    public static final int SIZE_INDEX = 4;
    static final int DESCRIPTION_INDEX = 5;
    static final int TITLE_INDEX = 6;
    static final int IS_SPAM_INDEX = 7;

    public ImageTableFormat() {
        super("CLASSIC_SEARCH_IMAGE_TABLE", 1, 0, 7, new ColumnStateInfo(0, "CLASSIC_SEARCH_IMAGE_FROM", I18n.tr("From"), 88, true, true), new ColumnStateInfo(1, "CLASSIC_SEARCH_IMAGE_NAME", I18n.tr("Name"), 503, true, true), new ColumnStateInfo(2, "CLASSIC_SEARCH_IMAGE_EXTENSION", I18n.tr("Extension"), 77, true, true), new ColumnStateInfo(3, "CLASSIC_SEARCH_IMAGE_DATE", I18n.tr("Date Created"), 112, true, true), new ColumnStateInfo(4, "CLASSIC_SEARCH_IMAGE_SIZE", I18n.tr("Size"), 78, true, true), new ColumnStateInfo(5, "CLASSIC_SEARCH_IMAGE_DESCRIPTION", I18n.tr("Description"), 80, false, true), new ColumnStateInfo(6, "CLASSIC_SEARCH_IMAGE_TITLE", I18n.tr("Title"), 80, false, true), new ColumnStateInfo(7, "CLASSIC_SEARCH_IMAGE_IS_SPAM", "", 10, false, false));
    }

    @Override
    public Class getColumnClass(int index) {
        switch (index) {
            case 1: {
                return Component.class;
            }
            case 3: {
                return Calendar.class;
            }
            case 0: {
                return VisualSearchResult.class;
            }
        }
        return super.getColumnClass(index);
    }

    @Override
    public Object getColumnValue(VisualSearchResult vsr, int index) {
        switch (index) {
            case 1: {
                return vsr;
            }
            case 2: {
                return vsr.getFileExtension();
            }
            case 3: {
                return vsr.getProperty(FilePropertyKey.DATE_CREATED);
            }
            case 0: {
                return vsr;
            }
            case 4: {
                return vsr.getSize();
            }
            case 5: {
                return "";
            }
            case 6: {
                return vsr.getProperty(FilePropertyKey.TITLE);
            }
            case 7: {
                return vsr;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + index);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.DESCENDING, 0), new SortKey(SortOrder.ASCENDING, 3), new SortKey(SortOrder.ASCENDING, 1));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        switch (column) {
            case 1: {
                return Arrays.asList(3);
            }
            case 3: {
                return Arrays.asList(1);
            }
        }
        return Collections.emptyList();
    }
}

