/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel.classic;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.util.I18n;

public class VideoTableFormat
extends ResultsTableFormat<VisualSearchResult> {
    static final int FROM_INDEX = 0;
    static final int NAME_INDEX = 1;
    static final int TITLE_INDEX = 2;
    static final int EXTENSION_INDEX = 3;
    public static final int LENGTH_INDEX = 4;
    public static final int QUALITY_INDEX = 5;
    public static final int SIZE_INDEX = 6;
    static final int MISC_INDEX = 7;
    static final int RATING_INDEX = 8;
    static final int DIMENSION_INDEX = 9;
    static final int YEAR_INDEX = 10;
    static final int DESCRIPTION_INDEX = 11;
    static final int GENRE_INDEX = 12;
    static final int IS_SPAM_INDEX = 13;

    public VideoTableFormat() {
        super("CLASSIC_SEARCH_VIDEO_TABLE", 1, 0, 13, new ColumnStateInfo(0, "CLASSIC_SEARCH_VIDEO_FROM", I18n.tr("From"), 88, true, true), new ColumnStateInfo(1, "CLASSIC_SEARCH_VIDEO_NAME", I18n.tr("Name"), 434, true, true), new ColumnStateInfo(2, "CLASSIC_SEARCH_VIDEO_TITLE", I18n.tr("Title"), 100, true, false), new ColumnStateInfo(3, "CLASSIC_SEARCH_VIDEO_EXTENSION", I18n.tr("Extension"), 85, true, true), new ColumnStateInfo(4, "CLASSIC_SEARCH_VIDEO_LENGTH", I18n.tr("Length"), 85, true, true), new ColumnStateInfo(5, "CLASSIC_SEARCH_VIDEO_QUALITY", I18n.tr("Quality"), 85, true, true), new ColumnStateInfo(6, "CLASSIC_SEARCH_VIDEO_SIZE", I18n.tr("Size"), 81, true, true), new ColumnStateInfo(7, "CLASSIC_SEARCH_VIDEO_MISC", I18n.tr("Misc"), 60, false, true), new ColumnStateInfo(8, "CLASSIC_SEARCH_VIDEO_RATING", I18n.tr("Rating"), 60, false, true), new ColumnStateInfo(9, "CLASSIC_SEARCH_VIDEO_RESOLUTION", I18n.tr("Resolution"), 60, false, true), new ColumnStateInfo(10, "CLASSIC_SEARCH_VIDEO_YEAR", I18n.tr("Year"), 60, false, true), new ColumnStateInfo(11, "CLASSIC_SEARCH_VIDEO_DESCRIPTION", I18n.tr("Description"), 60, false, true), new ColumnStateInfo(12, "CLASSIC_SEARCH_VIDEO_GENRE", I18n.tr("Genre"), 80, false, true), new ColumnStateInfo(13, "CLASSIC_SEARCH_VIDEO_IS_SPAM", "", 10, false, false));
    }

    @Override
    public Class getColumnClass(int index) {
        switch (index) {
            case 1: {
                return Component.class;
            }
            case 8: {
                return Integer.class;
            }
            case 10: {
                return Integer.class;
            }
            case 0: {
                return VisualSearchResult.class;
            }
        }
        return super.getColumnClass(index);
    }

    @Override
    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 5: {
                return this.getQualityComparator();
            }
        }
        return super.getColumnComparator(column);
    }

    @Override
    public Object getColumnValue(VisualSearchResult vsr, int index) {
        switch (index) {
            case 1: {
                return vsr;
            }
            case 2: {
                return vsr.getProperty(FilePropertyKey.TITLE);
            }
            case 3: {
                return vsr.getFileExtension();
            }
            case 4: {
                return vsr.getProperty(FilePropertyKey.LENGTH);
            }
            case 10: {
                return vsr.getProperty(FilePropertyKey.YEAR);
            }
            case 5: {
                return vsr;
            }
            case 7: {
                return vsr.getProperty(FilePropertyKey.DESCRIPTION);
            }
            case 11: {
                return "";
            }
            case 0: {
                return vsr;
            }
            case 8: {
                return vsr.getProperty(FilePropertyKey.RATING);
            }
            case 9: {
                if (vsr.getProperty(FilePropertyKey.WIDTH) == null || vsr.getProperty(FilePropertyKey.HEIGHT) == null) {
                    return null;
                }
                return vsr.getProperty(FilePropertyKey.WIDTH) + " X " + vsr.getProperty(FilePropertyKey.HEIGHT);
            }
            case 6: {
                return vsr.getSize();
            }
            case 12: {
                return vsr.getProperty(FilePropertyKey.GENRE);
            }
            case 13: {
                return vsr;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + index);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.DESCENDING, 0), new SortKey(SortOrder.ASCENDING, 1), new SortKey(SortOrder.ASCENDING, 6));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        switch (column) {
            case 1: {
                return Arrays.asList(6);
            }
            case 6: {
                return Arrays.asList(1);
            }
        }
        return Collections.emptyList();
    }
}

