/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.shell;

import org.limewire.ui.swing.shell.ShellAssociation;
import org.limewire.ui.swing.shell.WindowsMagnetHandlerAssociation;
import org.limewire.ui.swing.shell.WindowsProtocolShellAssociation;

public class MagnetAssociation
implements ShellAssociation {
    private static final String MAGNET_EXTENTION = "magnet";
    private static final String MAGNET_PROTOCOL = "Magnet Protocol";
    private final ShellAssociation protocol;
    private final ShellAssociation handler;

    public MagnetAssociation(String program, String executable) {
        this.protocol = new WindowsProtocolShellAssociation(executable, MAGNET_EXTENTION, MAGNET_PROTOCOL);
        this.handler = new WindowsMagnetHandlerAssociation(program, executable);
    }

    @Override
    public boolean isAvailable() {
        return this.protocol.isAvailable();
    }

    @Override
    public boolean isRegistered() {
        return this.protocol.isRegistered();
    }

    @Override
    public boolean canUnregister() {
        return true;
    }

    @Override
    public void register() {
        this.protocol.register();
        this.handler.register();
    }

    @Override
    public void unregister() {
        this.protocol.unregister();
        if (this.handler.isRegistered()) {
            this.handler.unregister();
        }
    }
}

