/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.shell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import org.limewire.setting.BooleanSetting;
import org.limewire.ui.swing.components.YesNoCheckBoxDialog;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.shell.LimeAssociationOption;
import org.limewire.ui.swing.shell.LimeAssociations;
import org.limewire.ui.swing.util.I18n;

public class ShellAssociationManager {
    public void validateFileAssociations(JFrame frame) {
        final LimeAssociationOption torrentAssociationOption = LimeAssociations.getTorrentAssociation();
        this.applyAvailableAssociation(torrentAssociationOption, SwingUiSettings.HANDLE_TORRENTS);
        final LimeAssociationOption magnetAssociationOption = LimeAssociations.getMagnetAssociation();
        this.applyAvailableAssociation(magnetAssociationOption, SwingUiSettings.HANDLE_MAGNETS);
        boolean torrentsStolen = this.isSettingStolen(torrentAssociationOption, SwingUiSettings.HANDLE_TORRENTS);
        boolean magnetsStolen = this.isSettingStolen(magnetAssociationOption, SwingUiSettings.HANDLE_MAGNETS);
        if (SwingUiSettings.WARN_FILE_ASSOCIATION_CHANGES.getValue() && (torrentsStolen || magnetsStolen)) {
            String message = this.getMessage(torrentsStolen, magnetsStolen);
            final YesNoCheckBoxDialog yesNoCheckBoxDialog = new YesNoCheckBoxDialog(message, I18n.tr("Warn me when other programs take LimeWire associations"), SwingUiSettings.WARN_FILE_ASSOCIATION_CHANGES.getValue());
            yesNoCheckBoxDialog.setLocationRelativeTo(frame);
            yesNoCheckBoxDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUiSettings.WARN_FILE_ASSOCIATION_CHANGES.setValue(yesNoCheckBoxDialog.isCheckBoxSelected());
                    boolean shouldReAssociate = "YES".equals(e.getActionCommand());
                    if (shouldReAssociate) {
                        ShellAssociationManager.this.fixAssociation(torrentAssociationOption, SwingUiSettings.HANDLE_TORRENTS);
                        ShellAssociationManager.this.fixAssociation(magnetAssociationOption, SwingUiSettings.HANDLE_MAGNETS);
                    } else {
                        ShellAssociationManager.this.updateSettings(torrentAssociationOption, magnetAssociationOption);
                    }
                }
            });
            yesNoCheckBoxDialog.setVisible(true);
        } else {
            this.updateSettings(torrentAssociationOption, magnetAssociationOption);
        }
    }

    private String getMessage(boolean torrentsStolen, boolean magnetsStolen) {
        if (torrentsStolen && magnetsStolen) {
            return I18n.tr("Torrent files and magnet links are no longer associated with LimeWire. Would you like LimeWire to re-associate them?");
        }
        if (torrentsStolen) {
            return I18n.tr("Torrent files are no longer associated with LimeWire. Would you like LimeWire to re-associate them?");
        }
        return I18n.tr("Magnet links are no longer associated with LimeWire. Would you like LimeWire to re-associate them?");
    }

    private void updateSettings(LimeAssociationOption torrentAssociationOption, LimeAssociationOption magnetAssociationOption) {
        this.updateSetting(torrentAssociationOption, SwingUiSettings.HANDLE_TORRENTS);
        this.updateSetting(magnetAssociationOption, SwingUiSettings.HANDLE_MAGNETS);
    }

    private void updateSetting(LimeAssociationOption associationOption, BooleanSetting handleType) {
        handleType.setValue(associationOption != null && associationOption.isEnabled());
    }

    private boolean isSettingStolen(LimeAssociationOption associationOption, BooleanSetting handleType) {
        return associationOption != null && handleType.getValue() && !associationOption.isEnabled();
    }

    private void fixAssociation(LimeAssociationOption associationOption, BooleanSetting handleType) {
        if (associationOption != null) {
            associationOption.setEnabled(handleType.getValue());
        }
    }

    private void applyAvailableAssociation(LimeAssociationOption associationOption, BooleanSetting handleType) {
        if (associationOption != null && !associationOption.isEnabled() && handleType.getValue() && associationOption.isAvailable()) {
            associationOption.setEnabled(true);
        }
    }
}

