/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.statusbar;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.connection.ConnectionStrength;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.ui.swing.friends.chat.ChatMediator;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.player.MiniPlayerPanel;
import org.limewire.ui.swing.statusbar.ConnectionStatusPanel;
import org.limewire.ui.swing.statusbar.FileProcessingPanel;
import org.limewire.ui.swing.statusbar.ProStatusPanel;
import org.limewire.ui.swing.statusbar.SharedFileCountPanel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.ResizeUtils;

public class StatusPanel
extends JXPanel {
    @Resource
    private int height;
    private final SharedFileCountPanel sharedFileCountPanel;

    @Inject
    public StatusPanel(GnutellaConnectionManager connectionManager, MiniPlayerPanel miniPlayerPanel, ChatMediator chatMediator, ConnectionStatusPanel connectionStatus, ProStatusPanel proStatusPanel, SharedFileCountPanel sharedFileCountPanel, BarPainterFactory barPainterFactory, FileProcessingPanel fileProcessingPanel) {
        GuiUtils.assignResources(this);
        this.sharedFileCountPanel = sharedFileCountPanel;
        this.setLayout(new BorderLayout());
        ResizeUtils.forceHeight(this, this.height);
        this.setBackgroundPainter(barPainterFactory.createStatusBarPainter());
        miniPlayerPanel.setVisible(false);
        JPanel leftPanel = new JPanel(new MigLayout("insets 0, gap 0, filly, nogrid, hidemode 3"));
        JPanel centerPanel = new JPanel(new MigLayout("insets 0, gap 0, filly, nogrid, alignx 40%, hidemode 3"));
        JPanel rightPanel = new JPanel(new MigLayout("insets 0, gap 0, fill, nogrid, hidemode 3"));
        leftPanel.setOpaque(false);
        centerPanel.setOpaque(false);
        rightPanel.setOpaque(false);
        leftPanel.add((Component)connectionStatus, "growy, gapbefore 2, gaptop 2, gapbottom 2");
        leftPanel.add((Component)sharedFileCountPanel, "growy, gaptop 0, gapbottom 0");
        leftPanel.add((Component)fileProcessingPanel, "growy, gaptop 0, gapbottom 0, pad 0 -7 0 0");
        centerPanel.add((Component)proStatusPanel, "growy, gaptop 2");
        rightPanel.add((Component)miniPlayerPanel, "gapafter 4");
        rightPanel.add((Component)chatMediator.getChatButton(), "growy");
        this.add((Component)leftPanel, "West");
        this.add((Component)centerPanel, "Center");
        this.add((Component)rightPanel, "East");
        connectionManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("strength")) {
                    StatusPanel.this.updateComponents((ConnectionStrength)((Object)evt.getNewValue()));
                }
            }
        });
        this.updateComponents(connectionManager.getConnectionStrength());
    }

    private void updateComponents(ConnectionStrength strength) {
        boolean sharingVisible = false;
        switch (strength) {
            case DISCONNECTED: 
            case CONNECTING: 
            case NO_INTERNET: {
                sharingVisible = false;
                break;
            }
            default: {
                sharingVisible = true;
            }
        }
        this.sharedFileCountPanel.setVisible(sharingVisible);
    }
}

