/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import java.util.Comparator;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.table.VisibleTableFormat;

public abstract class AbstractColumnStateFormat<T>
implements VisibleTableFormat<T>,
AdvancedTableFormat<T>,
WritableTableFormat<T> {
    private ColumnStateInfo[] columnInfo;
    private final LimeComparator comparator;

    public AbstractColumnStateFormat(ColumnStateInfo ... columnInfo) {
        this.columnInfo = columnInfo;
        this.comparator = new LimeComparator();
    }

    @Override
    public int getColumnCount() {
        return this.columnInfo.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnInfo[column].getName();
    }

    @Override
    public boolean isVisibleAtStartup(int column) {
        return this.columnInfo[column].isShown();
    }

    @Override
    public boolean isColumnHideable(int column) {
        return this.columnInfo[column].isHideable();
    }

    @Override
    public int getInitialWidth(int column) {
        return this.columnInfo[column].getDefaultWidth();
    }

    @Override
    public int getMaxsWidth(int column) {
        return this.columnInfo[column].getMaxWidth();
    }

    @Override
    public ColumnStateInfo getColumnInfo(int column) {
        return this.columnInfo[column];
    }

    public Comparator getLimeComparator() {
        return this.comparator;
    }

    private static class LimeComparator
    implements Comparator<Object> {
        private LimeComparator() {
        }

        @Override
        public int compare(Object alpha, Object beta) {
            if (alpha == null) {
                return beta == null ? 0 : -1;
            }
            if (beta == null) {
                return 1;
            }
            if (alpha == beta) {
                return 0;
            }
            if (alpha.getClass().isInstance(beta)) {
                if (alpha instanceof String) {
                    return ((String)alpha).compareToIgnoreCase((String)beta);
                }
                if (alpha instanceof Comparable) {
                    return ((Comparable)alpha).compareTo(beta);
                }
                throw new IllegalStateException(alpha.getClass().getName() + " is not Comparable");
            }
            throw new IllegalStateException("Cannot compare " + alpha.getClass().getName() + " to " + beta.getClass().getName());
        }
    }
}

