/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.Component;
import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.limewire.i18n.I18nMarker;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.MacOSXUtils;
import org.limewire.ui.swing.util.WindowsFolderChooser;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class FileChooser {
    private FileChooser() {
    }

    public static File getLastInputDirectory() {
        File dir = SwingUiSettings.LAST_FILECHOOSER_DIRECTORY.get();
        if (dir == null || dir.getPath().equals("") || !dir.exists() || !dir.isDirectory()) {
            return FileChooser.getDefaultLastFileChooserDir();
        }
        return dir;
    }

    private static File getDefaultLastFileChooserDir() {
        File defaultDirectory = CommonUtils.getUserHomeDir();
        if (defaultDirectory == null || !defaultDirectory.exists()) {
            defaultDirectory = CommonUtils.getCurrentDirectory();
        }
        return defaultDirectory;
    }

    public static File getInputDirectory(Component parent) {
        return FileChooser.getInputDirectory(parent, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), null, null);
    }

    public static File getInputDirectory(Component parent, File directory) {
        return FileChooser.getInputDirectory(parent, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), directory);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooser.getInputDirectory(parent, titleKey, approveKey, directory, null);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        List<File> dirs = FileChooser.getInput(parent, titleKey, approveKey, directory, 1, 0, false, filter);
        assert (dirs == null || dirs.size() <= 1) : "selected more than one folder: " + dirs;
        if (dirs != null && dirs.size() == 1) {
            return dirs.get(0);
        }
        return null;
    }

    public static File getInputFile(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        List<File> files = FileChooser.getInput(parent, titleKey, approveKey, directory, 0, 0, false, filter);
        assert (files == null || files.size() <= 1) : "selected more than one directory: " + files;
        if (files != null && files.size() == 1) {
            return files.get(0);
        }
        return null;
    }

    public static List<File> getInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option, boolean allowMultiSelect, FileFilter filter) {
        if (!OSUtils.isMacOSX()) {
            if (OSUtils.isWindows() && mode == 1 && !allowMultiSelect) {
                try {
                    String oldPath = directory == null ? null : directory.getAbsolutePath();
                    WindowsFolderChooser folder = new WindowsFolderChooser(parent, titleKey, false, true, oldPath);
                    String path = folder.showWidget();
                    if (path != null && path.length() > 0) {
                        File file = new File(path);
                        FileChooser.setLastInputDirectory(file);
                        return Collections.singletonList(file);
                    }
                    return null;
                }
                catch (UnsatisfiedLinkError ule) {
                    return FileChooser.getFileChooser(parent, titleKey, approveKey, directory, mode, option, allowMultiSelect, filter);
                }
            }
            return FileChooser.getFileChooser(parent, titleKey, approveKey, directory, mode, option, allowMultiSelect, filter);
        }
        boolean canChooseFiles = mode == 0 || mode == 2;
        boolean canChooseDirectories = mode == 1 || mode == 2;
        List<File> selectedFiles = MacOSXUtils.openNativeFileDialog(I18n.tr(titleKey), directory, canChooseFiles, canChooseDirectories, allowMultiSelect, filter);
        if (selectedFiles == null) {
            return null;
        }
        if (selectedFiles.size() > 0) {
            if (selectedFiles.get(0).isFile()) {
                FileChooser.setLastInputDirectory(selectedFiles.get(0));
            } else if (selectedFiles.get(0).getParent() != null) {
                FileChooser.setLastInputDirectory(new File(selectedFiles.get(0).getParent()));
            } else {
                FileChooser.setLastInputDirectory(selectedFiles.get(0));
            }
        }
        return selectedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> getFileChooser(Component parent, String titleKey, String approveKey, File directory, int mode, int option, boolean allowMultiSelect, FileFilter filter) {
        JFileChooser fileChooser = FileChooser.getDirectoryChooser(titleKey, approveKey, directory, mode, filter, false);
        fileChooser.setMultiSelectionEnabled(allowMultiSelect);
        boolean dispose = false;
        if (parent == null) {
            dispose = true;
            parent = FocusJOptionPane.createFocusComponent();
        }
        try {
            if (fileChooser.showOpenDialog(parent) != option) {
                List<File> list = null;
                return list;
            }
        }
        catch (NullPointerException npe) {
            List<File> list = null;
            return list;
        }
        finally {
            if (dispose) {
                ((JFrame)parent).dispose();
            }
        }
        if (allowMultiSelect) {
            File[] chosen = fileChooser.getSelectedFiles();
            if (chosen.length > 0) {
                FileChooser.setLastInputDirectory(chosen[0]);
            }
            return Arrays.asList(chosen);
        }
        File chosen = fileChooser.getSelectedFile();
        FileChooser.setLastInputDirectory(chosen);
        return Collections.singletonList(chosen);
    }

    private static void setLastInputDirectory(File file) {
        if (file != null) {
            if (!file.exists() || !file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null && file.exists() && file.isDirectory()) {
                SwingUiSettings.LAST_FILECHOOSER_DIRECTORY.set(file);
            }
        }
    }

    private static JFileChooser getDirectoryChooser(String titleKey, String approveKey, File directory, int mode, FileFilter filter, boolean promptToOverwrite) {
        JFileChooser chooser = null;
        if (directory == null) {
            directory = FileChooser.getLastInputDirectory();
        }
        if (directory == null) {
            chooser = FileChooser.createFileChooser(null, promptToOverwrite);
        } else {
            try {
                chooser = FileChooser.createFileChooser(directory, promptToOverwrite);
            }
            catch (NullPointerException e) {
                try {
                    chooser = FileChooser.createFileChooser(directory, promptToOverwrite);
                }
                catch (NullPointerException npe) {
                    UIManager.getDefaults().put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
                    chooser = FileChooser.createFileChooser(directory, promptToOverwrite);
                }
            }
            catch (ArrayIndexOutOfBoundsException ie) {
                chooser = FileChooser.createFileChooser(directory, promptToOverwrite);
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof IOException && OSUtils.isWindows()) {
                    try {
                        chooser = FileChooser.createFileChooser(directory, promptToOverwrite);
                    }
                    catch (RuntimeException r) {
                        UIManager.getDefaults().put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
                        chooser = FileChooser.createFileChooser(directory, promptToOverwrite);
                    }
                }
                throw re;
            }
        }
        if (filter != null) {
            chooser.setFileFilter(filter);
        } else if (mode == 1) {
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return true;
                }

                @Override
                public String getDescription() {
                    return I18n.tr("All Folders");
                }
            });
        }
        chooser.setFileSelectionMode(mode);
        String title = I18n.tr(titleKey);
        chooser.setDialogTitle(title);
        if (approveKey != null) {
            String approveButtonText = I18n.tr(approveKey);
            chooser.setApproveButtonText(approveButtonText);
        }
        return chooser;
    }

    private static JFileChooser createFileChooser(File currentDirectory, boolean promptToOverwrite) {
        LimeFileChooser fileChooser = new LimeFileChooser(currentDirectory);
        fileChooser.setPromptToOverwrite(promptToOverwrite);
        return fileChooser;
    }

    public static File getSaveAsFile(Component parent, String titleKey, File suggestedFile) {
        return FileChooser.getSaveAsFile(parent, titleKey, suggestedFile, null);
    }

    public static File getSaveAsFile(Component parent, String titleKey, File suggestedFile, final FileFilter filter) {
        if (OSUtils.isMacOSX()) {
            FileDialog dialog = new FileDialog(GuiUtils.getParentFrame(parent), I18n.tr(titleKey), 1);
            dialog.setDirectory(suggestedFile.getParent());
            dialog.setFile(suggestedFile.getName());
            if (filter != null) {
                FilenameFilter f = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return filter.accept(new File(dir, name));
                    }
                };
                dialog.setFilenameFilter(f);
            }
            dialog.setVisible(true);
            String dir = dialog.getDirectory();
            if (dir != null) {
                FileChooser.setLastInputDirectory(new File(dir));
            }
            String file = dialog.getFile();
            if (dir != null && file != null) {
                File f = new File(dir, file);
                if (filter != null && !filter.accept(f)) {
                    return null;
                }
                return f;
            }
            return null;
        }
        JFileChooser chooser = FileChooser.getDirectoryChooser(titleKey, null, null, 0, filter, true);
        chooser.setSelectedFile(suggestedFile);
        int ret = chooser.showSaveDialog(parent);
        File file = chooser.getSelectedFile();
        FileChooser.setLastInputDirectory(file);
        return ret != 0 ? null : file;
    }

    private static class LimeFileChooser
    extends JFileChooser {
        private boolean promptToOverwrite = false;

        public LimeFileChooser(File currentDirectory) {
            super(currentDirectory);
        }

        @Override
        public void approveSelection() {
            switch (this.getDialogType()) {
                case 1: {
                    int answer;
                    File selectedFile;
                    if (!this.promptToOverwrite || (selectedFile = this.getSelectedFile()) == null || !selectedFile.exists() || (answer = FocusJOptionPane.showConfirmDialog(this, selectedFile.getPath() + "\n" + I18n.tr("File already exists.  Do you want to replace it?"), this.getDialogTitle(), 0, 2)) == 0) break;
                    return;
                }
            }
            super.approveSelection();
        }

        public void setPromptToOverwrite(boolean promptToOverwrite) {
            this.promptToOverwrite = promptToOverwrite;
        }
    }
}

