/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.util.FileIconController;
import org.limewire.ui.swing.util.NativeFileIconController;
import org.limewire.ui.swing.util.NonBlockFileIconController;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

@Singleton
public class IconManager {
    private final FileIconController originalFileController;
    private FileIconController fileController;
    private Icon blankIcon;

    @Inject
    IconManager(NonBlockFileIconController nonBlockFileIconController, final Provider<NativeFileIconController> nativeFileIconControllerFactory) {
        this.fileController = this.originalFileController = nonBlockFileIconController;
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            ThreadExecutor.startThread(new Runnable(){

                @Override
                public void run() {
                    final FileIconController newController = (FileIconController)nativeFileIconControllerFactory.get();
                    if (newController.isValid()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                IconManager.this.fileController = newController;
                            }
                        });
                    }
                }
            }, "NativeFileIconLoader");
        }
    }

    public Icon getBlankIcon() {
        if (this.blankIcon != null) {
            return this.blankIcon;
        }
        this.blankIcon = new Icon(){

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        return this.blankIcon;
    }

    public Icon getIconForFile(File f) {
        this.validate();
        return this.fileController.getIconForFile(f);
    }

    public Icon getIconForExtension(String ext) {
        this.validate();
        return this.fileController.getIconForExtension(ext);
    }

    public Icon getIconForPropertiableFile(PropertiableFile file) {
        return this.getIconForExtension(this.getExtension(file));
    }

    public boolean isIconForFileAvailable(File f) {
        this.validate();
        return this.fileController.isIconForFileAvailable(f);
    }

    public String getMIMEDescription(PropertiableFile propertiable) {
        return this.getMIMEDescription(this.getExtension(propertiable));
    }

    public String getMIMEDescription(String extension) {
        if (extension == null) {
            return null;
        }
        Icon icon = this.getIconForExtension(extension);
        if (icon == null) {
            return null;
        }
        String iconString = icon.toString();
        if (iconString.indexOf("@") > -1) {
            return null;
        }
        if (iconString.endsWith(".png")) {
            return null;
        }
        return iconString;
    }

    private String getExtension(PropertiableFile propertiable) {
        return FileUtils.getFileExtension(propertiable.getFileName());
    }

    private void validate() {
        if (!this.fileController.isValid()) {
            this.fileController = this.originalFileController;
        }
    }
}

