/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.google.inject.internal.cglib.proxy.Enhancer;
import com.google.inject.internal.cglib.proxy.MethodInterceptor;
import com.google.inject.internal.cglib.proxy.MethodProxy;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.limewire.util.OSUtils;

public class SwingHacks {
    private static PopupMenuListener menuHackListener = null;

    public static void fixPopupMenuForWindows(JPopupMenu menu) {
        if (!OSUtils.isWindows()) {
            return;
        }
        if (menuHackListener == null) {
            menuHackListener = new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    final JPopupMenu menu = (JPopupMenu)e.getSource();
                    Timer flashTimer = new Timer(20, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (!menu.isVisible()) {
                                return;
                            }
                            menu.removePopupMenuListener(menuHackListener);
                            menu.setVisible(false);
                            menu.setVisible(true);
                            menu.addPopupMenuListener(menuHackListener);
                        }
                    });
                    flashTimer.setRepeats(false);
                    flashTimer.start();
                }
            };
        }
        menu.addPopupMenuListener(menuHackListener);
    }

    public static void fixTextFieldScrollClippingWithNonDefaultInsets(JTextField textComponent) {
        textComponent.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                JTextField component = (JTextField)e.getSource();
                if (component.getScrollOffset() > 0 && component.getCaretPosition() == 0) {
                    component.setScrollOffset(0);
                }
            }
        });
    }

    public static void fixDnDforKDE(JComponent c) {
        if (!OSUtils.isUnix()) {
            return;
        }
        final DropTarget originalTarget = c.getDropTarget();
        if (originalTarget == null || !originalTarget.getClass().getName().equals("javax.swing.TransferHandler$SwingDropTarget")) {
            return;
        }
        Enhancer e = new Enhancer();
        e.setSuperclass(DropTarget.class);
        e.setCallback(new MethodInterceptor(){

            @Override
            public Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                try {
                    Method originalMethod = originalTarget.getClass().getMethod(method.getName(), method.getParameterTypes());
                    originalMethod.setAccessible(true);
                    return originalMethod.invoke((Object)originalTarget, args);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
                catch (InvocationTargetException e) {
                    if (method.getName().equals("dragOver")) {
                        DropTargetDragEvent event = (DropTargetDragEvent)args[0];
                        originalTarget.dragExit(event);
                        originalTarget.dragEnter(event);
                        originalTarget.dragOver(event);
                        return null;
                    }
                    throw e;
                }
            }
        });
        c.setDropTarget((DropTarget)e.create());
    }
}

