/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Frame;
import org.limewire.core.api.Application;
import org.limewire.core.api.library.LibraryData;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.settings.InstallSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.wizard.SetupComponentDecorator;
import org.limewire.ui.swing.wizard.SetupComponentDecoratorFactory;
import org.limewire.ui.swing.wizard.SetupPage1;
import org.limewire.ui.swing.wizard.SetupPage2;
import org.limewire.ui.swing.wizard.Wizard;

public class SetupWizard {
    private Wizard wizard;
    private final Application application;
    private final LibraryData libraryData;

    @Inject
    public SetupWizard(Provider<SetupComponentDecoratorFactory> decoratorFactory, Provider<LibraryManager> libraryManagerProvider, Application application) {
        this.application = application;
        this.libraryData = libraryManagerProvider.get().getLibraryData();
        this.createWizard(decoratorFactory.get(), this.libraryData);
    }

    public static boolean shouldShowWizard() {
        return SetupWizard.shouldShowPage1();
    }

    public void showDialog(Frame owner) {
        this.wizard.showDialog(owner);
    }

    private void createWizard(SetupComponentDecoratorFactory decoratorFactory, LibraryData libraryData) {
        SetupComponentDecorator decorator = decoratorFactory.create();
        this.wizard = new Wizard(decorator);
        if (SetupWizard.shouldShowPage1()) {
            this.wizard.addPage(new SetupPage1(decorator, this.application));
        }
        this.wizard.addPage(new SetupPage2(decorator, this.application, libraryData));
    }

    private static boolean shouldShowPage1() {
        if (!InstallSettings.AUTO_SHARING_OPTION.getValue()) {
            return true;
        }
        if (!InstallSettings.ANONYMOUS_DATA_COLLECTION.getValue()) {
            return true;
        }
        if (!InstallSettings.FILTER_OPTION.getValue()) {
            return true;
        }
        if (!InstallSettings.START_STARTUP.getValue()) {
            return GuiUtils.shouldShowStartOnStartupWindow();
        }
        return false;
    }
}

