/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.awt.Rectangle;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import net.sourceforge.iharder.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.BlockingURLLoader;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.dom.DocumentImpl;
import org.mozilla.dom.ElementImpl;
import org.mozilla.dom.NodeFactory;
import org.mozilla.interfaces.nsIBoxObject;
import org.mozilla.interfaces.nsIDOMAbstractView;
import org.mozilla.interfaces.nsIDOMCanvasRenderingContext2D;
import org.mozilla.interfaces.nsIDOMClientRect;
import org.mozilla.interfaces.nsIDOMClientRectList;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMDocumentEvent;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMHTMLCanvasElement;
import org.mozilla.interfaces.nsIDOMHTMLDocument;
import org.mozilla.interfaces.nsIDOMHTMLFrameElement;
import org.mozilla.interfaces.nsIDOMHTMLIFrameElement;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNSDocument;
import org.mozilla.interfaces.nsIDOMNSElement;
import org.mozilla.interfaces.nsIDOMNSHTMLElement;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDOMXPathEvaluator;
import org.mozilla.interfaces.nsIDOMXPathResult;
import org.mozilla.interfaces.nsIDOMXULElement;
import org.mozilla.interfaces.nsIDocShell;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsISimpleEnumerator;
import org.mozilla.interfaces.nsIStringInputStream;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.interfaces.nsIWindowWatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaAutomation {
    static Log log = LogFactory.getLog(MozillaAutomation.class);

    public static boolean blockingLoad(MozillaPanel moz, String url) {
        return MozillaAutomation.blockingLoad(moz, url, null);
    }

    public static boolean blockingLoad(MozillaPanel moz, final String url, String postData) {
        nsIStringInputStream postDataStream;
        if (MozillaExecutor.isMozillaThread()) {
            throw new RuntimeException();
        }
        if (postData != null) {
            try {
                postDataStream = XPCOMUtils.create("@mozilla.org/io/string-input-stream;1", nsIStringInputStream.class);
                String streamData = String.format("Content-Type: application/x-www-form-urlencoded\r\nContent-Length: %d\r\n\r\n%s", postData.getBytes("UTF-8").length, postData);
                postDataStream.setData(streamData, -1);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            postDataStream = null;
        }
        BlockingURLLoader l = new BlockingURLLoader(moz){

            public boolean triggerURLLoading() {
                ChromeAdapter chromeAdapter = this.moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return true;
                }
                nsIWebNavigation nav = XPCOMUtils.qi(chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.loadURI(url, 0L, null, postDataStream, null);
                return false;
            }

            public void onLoadStarted() {
            }

            public void onLoadEnded() {
            }
        };
        l.load();
        return l.getLoadFailed();
    }

    public static boolean blockingLoadHTML(MozillaPanel moz, final String content, final String asUrl) {
        if (MozillaExecutor.isMozillaThread()) {
            throw new RuntimeException();
        }
        BlockingURLLoader l = new BlockingURLLoader(moz){

            public boolean triggerURLLoading() {
                return MozillaAutomation.triggerLoadHTML(this.moz, content, asUrl);
            }

            public void onLoadStarted() {
            }

            public void onLoadEnded() {
            }
        };
        l.load();
        return l.getLoadFailed();
    }

    public static boolean triggerLoadHTML(MozillaPanel moz, String content, String asUrl) {
        assert (MozillaExecutor.isMozillaThread());
        ChromeAdapter chromeAdapter = moz.getChromeAdapter();
        if (chromeAdapter == null) {
            return true;
        }
        if (asUrl == null) {
            String b64content;
            try {
                b64content = Base64.encodeBytes(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            String dataURI = "data:text/html;base64," + b64content;
            nsIWebBrowser brow = chromeAdapter.getWebBrowser();
            nsIWebNavigation nav = XPCOMUtils.qi(brow, nsIWebNavigation.class);
            nav.loadURI(dataURI, 0L, null, null, null);
            return false;
        }
        nsIURI uri = XPCOMUtils.create("@mozilla.org/network/simple-uri;1", nsIURI.class);
        uri.setSpec(asUrl);
        nsIStringInputStream is = XPCOMUtils.create("@mozilla.org/io/string-input-stream;1", nsIStringInputStream.class);
        is.setData(content, content.length());
        nsIWebBrowser webBrowser = chromeAdapter.getWebBrowser();
        nsIInterfaceRequestor ir = XPCOMUtils.qi(webBrowser, nsIInterfaceRequestor.class);
        nsIDocShell docShell = (nsIDocShell)ir.getInterface("{7d1cf6b9-daa3-476d-8f9f-9eb2a971a95c}");
        docShell.loadStream(is, uri, "text/html", "utf-8", null);
        return false;
    }

    public static boolean blockingBack(MozillaPanel moz) {
        if (MozillaExecutor.isMozillaThread()) {
            throw new RuntimeException();
        }
        BlockingURLLoader l = new BlockingURLLoader(moz){

            public boolean triggerURLLoading() {
                ChromeAdapter chromeAdapter = this.moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return true;
                }
                nsIWebNavigation nav = XPCOMUtils.qi(chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.goBack();
                return false;
            }

            public void onLoadStarted() {
            }

            public void onLoadEnded() {
            }
        };
        l.load();
        return l.getLoadFailed();
    }

    public static boolean blockingForward(MozillaPanel moz) {
        if (MozillaExecutor.isMozillaThread()) {
            throw new RuntimeException();
        }
        BlockingURLLoader l = new BlockingURLLoader(moz){

            public boolean triggerURLLoading() {
                ChromeAdapter chromeAdapter = this.moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return true;
                }
                nsIWebNavigation nav = XPCOMUtils.qi(chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.goForward();
                return false;
            }

            public void onLoadStarted() {
            }

            public void onLoadEnded() {
            }
        };
        l.load();
        return l.getLoadFailed();
    }

    public static boolean blockingReload(MozillaPanel moz) {
        if (MozillaExecutor.isMozillaThread()) {
            throw new RuntimeException();
        }
        BlockingURLLoader l = new BlockingURLLoader(moz){

            public boolean triggerURLLoading() {
                ChromeAdapter chromeAdapter = this.moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return true;
                }
                nsIWebNavigation nav = XPCOMUtils.qi(chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.reload(0L);
                return false;
            }

            public void onLoadStarted() {
            }

            public void onLoadEnded() {
            }
        };
        l.load();
        return l.getLoadFailed();
    }

    public static String getCurrentURI(MozillaPanel moz) {
        assert (MozillaExecutor.isMozillaThread());
        nsIWebBrowser brow = moz.getChromeAdapter().getWebBrowser();
        nsIWebNavigation nav = XPCOMUtils.qi(brow, nsIWebNavigation.class);
        nsIURI uri = nav.getCurrentURI();
        return uri.getSpec();
    }

    public static boolean click(MozillaPanel moz, String id) {
        assert (MozillaExecutor.isMozillaThread());
        ChromeAdapter chromeAdapter = moz.getChromeAdapter();
        if (chromeAdapter == null) {
            return true;
        }
        nsIWebBrowser brow = chromeAdapter.getWebBrowser();
        nsIDOMDocument doc = brow.getContentDOMWindow().getDocument();
        nsIDOMElement elem = doc.getElementById(id);
        if (elem == null) {
            return true;
        }
        return MozillaAutomation.click(elem);
    }

    public static boolean click(nsIDOMElement elem) {
        assert (MozillaExecutor.isMozillaThread());
        nsIDOMDocument doc = elem.getOwnerDocument();
        nsIDOMDocumentEvent evdoc = XPCOMUtils.qi(doc, nsIDOMDocumentEvent.class);
        nsIDOMEvent ev = evdoc.createEvent("MouseEvents");
        nsIDOMMouseEvent mev = XPCOMUtils.qi(ev, nsIDOMMouseEvent.class);
        nsIDOMDocumentView view = XPCOMUtils.qi(doc, nsIDOMDocumentView.class);
        nsIDOMAbstractView aview = view.getDefaultView();
        mev.initMouseEvent("click", true, true, aview, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
        nsIDOMEventTarget evt = XPCOMUtils.qi(elem, nsIDOMEventTarget.class);
        boolean canceled = !evt.dispatchEvent(mev);
        return canceled;
    }

    public static boolean type(MozillaPanel moz, String id, String text) {
        assert (MozillaExecutor.isMozillaThread());
        ChromeAdapter chromeAdapter = moz.getChromeAdapter();
        if (chromeAdapter == null) {
            return true;
        }
        nsIWebBrowser brow = chromeAdapter.getWebBrowser();
        nsIDOMWindow domwin = brow.getContentDOMWindow();
        nsIDOMDocument doc = domwin.getDocument();
        nsIDOMElement elem = doc.getElementById(id);
        if (elem == null) {
            return true;
        }
        return MozillaAutomation.type(elem, text);
    }

    public static boolean mousemove(MozillaPanel moz, String id, float relX, float relY) {
        assert (MozillaExecutor.isMozillaThread());
        ChromeAdapter chromeAdapter = moz.getChromeAdapter();
        if (chromeAdapter == null) {
            return true;
        }
        nsIWebBrowser brow = chromeAdapter.getWebBrowser();
        nsIDOMDocument doc = brow.getContentDOMWindow().getDocument();
        nsIDOMElement elem = doc.getElementById(id);
        if (elem == null) {
            return true;
        }
        return MozillaAutomation.mousemove(elem, relX, relY);
    }

    public static boolean mousemove(nsIDOMElement elem, float relX, float relY) {
        assert (MozillaExecutor.isMozillaThread());
        nsIDOMDocument doc = elem.getOwnerDocument();
        nsIDOMNSDocument nsdoc = XPCOMUtils.qi(doc, nsIDOMNSDocument.class);
        nsIBoxObject box = nsdoc.getBoxObjectFor(elem);
        int sx = box.getScreenX();
        int sy = box.getScreenY();
        int h = box.getHeight();
        int w = box.getWidth();
        nsIDOMDocumentEvent evdoc = XPCOMUtils.qi(doc, nsIDOMDocumentEvent.class);
        nsIDOMEvent ev = evdoc.createEvent("MouseEvents");
        nsIDOMMouseEvent mev = XPCOMUtils.qi(ev, nsIDOMMouseEvent.class);
        nsIDOMDocumentView view = XPCOMUtils.qi(doc, nsIDOMDocumentView.class);
        nsIDOMAbstractView aview = view.getDefaultView();
        int x = (int)(relX * (float)w);
        int y = (int)(relY * (float)h);
        if (x < 0 || x >= w) {
            x = 0;
        }
        if (y < 0 || y >= h) {
            y = 0;
        }
        mev.initMouseEvent("mousemove", true, true, aview, 0, sx + x, sy + y, x, y, false, false, false, false, 0, null);
        nsIDOMEventTarget evt = XPCOMUtils.qi(elem, nsIDOMEventTarget.class);
        boolean canceled = !evt.dispatchEvent(mev);
        return canceled;
    }

    public static boolean type(nsIDOMElement elem, String text) {
        assert (MozillaExecutor.isMozillaThread());
        nsIDOMDocument doc = elem.getOwnerDocument();
        nsIDOMDocumentEvent evdoc = XPCOMUtils.qi(doc, nsIDOMDocumentEvent.class);
        nsIDOMEvent ev = evdoc.createEvent("KeyboardEvent");
        nsIDOMKeyEvent mev = XPCOMUtils.qi(ev, nsIDOMKeyEvent.class);
        nsIDOMDocumentView view = XPCOMUtils.qi(doc, nsIDOMDocumentView.class);
        nsIDOMAbstractView aview = view.getDefaultView();
        for (int i = 0; i < text.length(); ++i) {
            boolean canceled;
            char c = text.charAt(i);
            mev.initKeyEvent("keypress", true, true, aview, false, false, false, false, 0L, c);
            nsIDOMEventTarget evt = XPCOMUtils.qi(elem, nsIDOMEventTarget.class);
            boolean bl = canceled = !evt.dispatchEvent(mev);
            if (!canceled) continue;
            return canceled;
        }
        return false;
    }

    public static MozillaPanel waitForWindowWithTitle(String winTitle, int waitMillis) {
        assert (!MozillaExecutor.isMozillaThread());
        List<MozillaPanel> wins = MozillaAutomation.waitForNumWindowsWithTitle(winTitle, 1, waitMillis);
        return wins.isEmpty() ? null : wins.get(0);
    }

    public static List<MozillaPanel> waitForNumWindowsWithTitle(final String winTitle, int numWins, int waitMillis) {
        assert (!MozillaExecutor.isMozillaThread());
        final LinkedList<MozillaPanel> wins = new LinkedList<MozillaPanel>();
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                wins.clear();
                wins.addAll(MozillaAutomation.findWindowsByTitle(winTitle));
            }
        });
        for (int waited = 0; wins.size() < numWins && waited < waitMillis; waited += 300) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                log.error("wait interrupted", e);
            }
            MozillaExecutor.mozSyncExec(new Runnable(){

                public void run() {
                    wins.clear();
                    wins.addAll(MozillaAutomation.findWindowsByTitle(winTitle));
                }
            });
        }
        return wins;
    }

    public static MozillaPanel waitForNoWindowWithTitle(final String winTitle, int waitMillis) {
        assert (!MozillaExecutor.isMozillaThread());
        final LinkedList wins = new LinkedList();
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                wins.clear();
                wins.addAll(MozillaAutomation.findWindowsByTitle(winTitle));
            }
        });
        for (int waited = 0; !wins.isEmpty() && waited < waitMillis; waited += 300) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                log.error("wait interrupted", e);
            }
            MozillaExecutor.mozSyncExec(new Runnable(){

                public void run() {
                    wins.clear();
                    wins.addAll(MozillaAutomation.findWindowsByTitle(winTitle));
                }
            });
        }
        return wins.isEmpty() ? null : (MozillaPanel)wins.get(0);
    }

    public static MozillaPanel waitForWindowWithNodeText(String nodeText, int waitMillis) {
        assert (!MozillaExecutor.isMozillaThread());
        List<MozillaPanel> wins = MozillaAutomation.waitForNumWindowsWithNodeText(nodeText, 1, waitMillis);
        return wins.isEmpty() ? null : wins.get(0);
    }

    public static List<MozillaPanel> waitForNumWindowsWithNodeText(final String nodeText, int numWins, int waitMillis) {
        assert (!MozillaExecutor.isMozillaThread());
        final LinkedList<MozillaPanel> wins = new LinkedList<MozillaPanel>();
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                wins.clear();
                wins.addAll(MozillaAutomation.findWindowsByNodeText(nodeText));
            }
        });
        for (int waited = 0; wins.size() < numWins && waited < waitMillis; waited += 300) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                log.error("wait interrupted", e);
            }
            MozillaExecutor.mozSyncExec(new Runnable(){

                public void run() {
                    wins.clear();
                    wins.addAll(MozillaAutomation.findWindowsByNodeText(nodeText));
                }
            });
        }
        return wins;
    }

    public static MozillaPanel waitForNoWindowWithNodeText(final String nodeText, int waitMillis) {
        assert (!MozillaExecutor.isMozillaThread());
        final LinkedList wins = new LinkedList();
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                wins.clear();
                wins.addAll(MozillaAutomation.findWindowsByNodeText(nodeText));
            }
        });
        for (int waited = 0; !wins.isEmpty() && waited < waitMillis; waited += 300) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                log.error("wait interrupted", e);
            }
            MozillaExecutor.mozSyncExec(new Runnable(){

                public void run() {
                    wins.clear();
                    wins.addAll(MozillaAutomation.findWindowsByNodeText(nodeText));
                }
            });
        }
        return wins.isEmpty() ? null : (MozillaPanel)wins.get(0);
    }

    public static void sleep(int waitMillis) {
        assert (!MozillaExecutor.isMozillaThread());
        try {
            Thread.sleep(waitMillis);
        }
        catch (InterruptedException e) {
            log.error("wait interrupted", e);
        }
    }

    public static List<MozillaPanel> findWindowsByTitle(String winTitle) {
        assert (MozillaExecutor.isMozillaThread());
        LinkedList<MozillaPanel> wins = new LinkedList<MozillaPanel>();
        nsIWindowWatcher winWatcher = XPCOMUtils.getService("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.class);
        nsISimpleEnumerator en = winWatcher.getWindowEnumerator();
        while (en.hasMoreElements()) {
            MozillaPanel moz;
            nsIDOMWindow domWin = XPCOMUtils.qi(en.getNext(), nsIDOMWindow.class);
            if (domWin == null) continue;
            String title = null;
            nsIDOMHTMLDocument htmlDoc = XPCOMUtils.qi(domWin.getDocument(), nsIDOMHTMLDocument.class);
            if (htmlDoc != null) {
                title = htmlDoc.getTitle();
            } else {
                nsIDOMNSDocument nsDoc = XPCOMUtils.qi(domWin.getDocument(), nsIDOMNSDocument.class);
                if (nsDoc != null) {
                    title = nsDoc.getTitle();
                }
            }
            if (title == null || !winTitle.equals(title) || (moz = MozillaAutomation.findWindow(domWin)) == null) continue;
            wins.add(moz);
        }
        return wins;
    }

    public static List<MozillaPanel> findWindowsByNodeText(String nodeText) {
        assert (MozillaExecutor.isMozillaThread());
        LinkedList<MozillaPanel> wins = new LinkedList<MozillaPanel>();
        nsIWindowWatcher winWatcher = XPCOMUtils.getService("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.class);
        nsISimpleEnumerator en = winWatcher.getWindowEnumerator();
        while (en.hasMoreElements()) {
            MozillaPanel moz;
            nsIDOMDocument doc;
            nsIDOMXPathEvaluator eval;
            nsIDOMXPathResult ret;
            double count;
            nsIDOMWindow domWin = XPCOMUtils.qi(en.getNext(), nsIDOMWindow.class);
            if (domWin == null || !((count = (ret = XPCOMUtils.qi((eval = XPCOMUtils.qi(doc = domWin.getDocument(), nsIDOMXPathEvaluator.class)).evaluate("count(//*[text()='" + nodeText + "'])", doc, null, 0, null), nsIDOMXPathResult.class)).getNumberValue()) > 0.0) || (moz = MozillaAutomation.findWindow(domWin)) == null) continue;
            wins.add(moz);
        }
        return wins;
    }

    public static MozillaPanel findWindowByName(String winName) {
        assert (MozillaExecutor.isMozillaThread());
        nsIWindowWatcher winWatcher = XPCOMUtils.getService("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.class);
        nsIDOMWindow domWin = winWatcher.getWindowByName(winName, null);
        if (domWin == null) {
            return null;
        }
        return MozillaAutomation.findWindow(domWin);
    }

    public static MozillaPanel findWindow(nsIDOMWindow domWin) {
        assert (MozillaExecutor.isMozillaThread());
        nsIWindowWatcher winWatcher = XPCOMUtils.getService("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.class);
        nsIWebBrowserChrome chromeWin = winWatcher.getChromeForWindow(domWin);
        if (chromeWin == null) {
            return null;
        }
        return MozillaAutomation.findWindow(chromeWin);
    }

    public static MozillaPanel findWindow(nsIWebBrowserChrome chromeWin) {
        assert (MozillaExecutor.isMozillaThread());
        ChromeAdapter wina = (ChromeAdapter)chromeWin;
        return wina.getPanel();
    }

    public static void dumpWindows() {
        assert (MozillaExecutor.isMozillaThread());
        LinkedList<String> winTitles = new LinkedList<String>();
        nsIWindowWatcher winWatcher = XPCOMUtils.getService("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.class);
        nsISimpleEnumerator en = winWatcher.getWindowEnumerator();
        while (en.hasMoreElements()) {
            nsIDOMWindow domWin = XPCOMUtils.qi(en.getNext(), nsIDOMWindow.class);
            if (domWin == null) continue;
            String title = null;
            nsIDOMHTMLDocument htmlDoc = XPCOMUtils.qi(domWin.getDocument(), nsIDOMHTMLDocument.class);
            if (htmlDoc != null) {
                title = htmlDoc.getTitle();
            } else {
                nsIDOMNSDocument nsDoc = XPCOMUtils.qi(domWin.getDocument(), nsIDOMNSDocument.class);
                if (nsDoc != null) {
                    title = nsDoc.getTitle();
                }
            }
            winTitles.add(title != null ? title : "<none>");
        }
        StringBuffer sb = new StringBuffer();
        for (String s : winTitles) {
            sb.append(", ");
            sb.append(s);
        }
        log.debug(sb.toString());
    }

    public static List<MozillaPanel> getOpennedWindows() {
        assert (MozillaExecutor.isMozillaThread());
        LinkedList<MozillaPanel> wins = new LinkedList<MozillaPanel>();
        nsIWindowWatcher winWatcher = XPCOMUtils.getService("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.class);
        nsISimpleEnumerator en = winWatcher.getWindowEnumerator();
        while (en.hasMoreElements()) {
            nsIDOMWindow domWin = XPCOMUtils.qi(en.getNext(), nsIDOMWindow.class);
            if (domWin == null) continue;
            MozillaPanel moz = MozillaAutomation.findWindow(domWin);
            wins.add(moz);
        }
        return wins;
    }

    public static Object executeJavascript(final MozillaPanel moz, final String script) {
        Object[] ret = new Object[1];
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                ChromeAdapter chromeAdapter = moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return;
                }
                nsIWebNavigation nav = XPCOMUtils.qi(chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.loadURI("javascript:void " + script, 0L, null, null, null);
            }
        });
        return ret[0];
    }

    public static byte[] renderToImage(final MozillaPanel moz) {
        final MozillaWindow hiddenWin = new MozillaWindow();
        hiddenWin.addNotify();
        String b64data = MozillaExecutor.mozSyncExecQuiet(new Callable<String>(){

            @Override
            public String call() {
                int h;
                int w;
                nsIWebBrowser wb = hiddenWin.getPanel().getChromeAdapter().getWebBrowser();
                nsIDOMDocument doc = wb.getContentDOMWindow().getDocument();
                nsIDOMElement elem = doc.createElementNS("http://www.w3.org/1999/xhtml", "html:canvas");
                nsIDOMHTMLCanvasElement canvas = XPCOMUtils.qi(elem, nsIDOMHTMLCanvasElement.class);
                nsIDOMCanvasRenderingContext2D context = XPCOMUtils.qi(canvas.getContext("2d"), nsIDOMCanvasRenderingContext2D.class);
                nsIDOMWindow domWin = moz.getChromeAdapter().getWebBrowser().getContentDOMWindow();
                nsIDOMNSHTMLElement nselem = XPCOMUtils.qi(domWin.getDocument().getDocumentElement(), nsIDOMNSHTMLElement.class);
                if (nselem != null) {
                    w = nselem.getOffsetWidth() > nselem.getScrollWidth() ? nselem.getOffsetWidth() : nselem.getScrollWidth();
                    h = nselem.getOffsetHeight() > nselem.getScrollHeight() ? nselem.getOffsetHeight() : nselem.getScrollHeight();
                } else {
                    nsIDOMXULElement xulelem = XPCOMUtils.qi(domWin.getDocument().getDocumentElement(), nsIDOMXULElement.class);
                    if (xulelem != null) {
                        try {
                            w = Integer.parseInt(xulelem.getWidth());
                            h = Integer.parseInt(xulelem.getHeight());
                        }
                        catch (NumberFormatException e) {
                            h = 1000;
                            w = 1000;
                        }
                    } else {
                        h = 1000;
                        w = 1000;
                    }
                }
                if (h > 16384) {
                    h = 16384;
                }
                canvas.setWidth(w);
                canvas.setHeight(h);
                context.drawWindow(domWin, 0, 0, w, h, "rgb(255,255,255)");
                return canvas.toDataURLAs("image/png", "");
            }
        });
        b64data = b64data.replaceAll("^data:image/png;base64,", "");
        try {
            byte[] data = Base64.decode(b64data);
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Rectangle[] getElementRects(final Element e) {
        return MozillaExecutor.mozSyncExecQuiet(new Callable<Rectangle[]>(){

            @Override
            public Rectangle[] call() {
                nsIDOMElement el = ((ElementImpl)e).getInstance();
                nsIDOMNSElement nsel = XPCOMUtils.qi(el, nsIDOMNSElement.class);
                nsIDOMDocument doc = el.getOwnerDocument();
                nsIDOMNSDocument nsdoc = XPCOMUtils.qi(doc, nsIDOMNSDocument.class);
                nsIBoxObject box = nsdoc.getBoxObjectFor(el);
                int x0 = box.getX();
                int y0 = box.getY();
                int scrollx = 0;
                int scrolly = 0;
                nsIDOMClientRectList crl = nsel.getClientRects();
                int len = (int)crl.getLength();
                Rectangle[] rs = new Rectangle[len];
                for (int i = 0; i < len; ++i) {
                    Rectangle r;
                    nsIDOMClientRect dr = crl.item(i);
                    int x = (int)dr.getLeft();
                    int y = (int)dr.getTop();
                    int w = (int)(dr.getRight() - dr.getLeft());
                    int h = (int)(dr.getBottom() - dr.getTop());
                    if (i == 0) {
                        scrollx = x0 - x;
                        scrolly = y0 - y;
                    }
                    rs[i] = r = new Rectangle(x + scrollx, y + scrolly, w, h);
                }
                return rs;
            }
        });
    }

    public static Element getElementFromPoint(final Document doc, final int x, final int y) {
        return MozillaExecutor.mozSyncExecQuiet(new Callable<Element>(){

            @Override
            public Element call() {
                nsIDOMNSDocument nsdoc;
                nsIDOMElement el;
                nsIDOMDocument currDoc = ((DocumentImpl)doc).getInstance();
                nsIDOMElement currEl = null;
                while (currDoc != null && (el = (nsdoc = XPCOMUtils.qi(currDoc, nsIDOMNSDocument.class)).elementFromPoint(x, y)) != null) {
                    currEl = el;
                    nsIDOMHTMLFrameElement fel = XPCOMUtils.qi(el, nsIDOMHTMLFrameElement.class);
                    if (fel != null) {
                        currDoc = fel.getContentDocument();
                        continue;
                    }
                    nsIDOMHTMLIFrameElement iel = XPCOMUtils.qi(el, nsIDOMHTMLIFrameElement.class);
                    if (iel != null) {
                        currDoc = iel.getContentDocument();
                        continue;
                    }
                    currDoc = null;
                }
                return (Element)NodeFactory.getNodeInstance(currEl);
            }
        });
    }
}

