/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.impl.MozillaContainer;
import org.mozilla.browser.impl.WindowCreator;
import org.mozilla.browser.impl.components.JChromeButton;
import org.mozilla.browser.mt;
import org.mozilla.dom.NodeFactory;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIWebNavigation;
import org.w3c.dom.Document;

public class MozillaPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static Log log = LogFactory.getLog(MozillaPanel.class);
    protected final VisibilityMode toolbarVisMode;
    protected final VisibilityMode statusbarVisMode;
    protected JToolBar toolbar;
    protected JButton backButton;
    protected JButton forwardButton;
    protected JButton reloadButton;
    protected JButton stopButton;
    protected JButton goButton;
    protected JTextField urlBar;
    protected MozillaContainer mozContainer;
    protected JTextField statusField;
    protected MozillaPanel parentPanel;
    protected IMozillaWindow containerWin;
    private ChromeAdapter chromeAdapter;
    private boolean attachNewBrowserOnCreation;
    private String pendingUriToLoad;
    private String pendingContentToLoad;
    private String pendingContentUriToLoad;
    private Dimension initialPreferredSize;
    private static int DEFAULT_WIDTH = 300;
    private static int DEFAULT_HEIGHT = 300;
    protected boolean updateTitle = true;
    private boolean isFirstShow = true;

    public MozillaPanel() {
        this(null, true, null, null);
    }

    public MozillaPanel(boolean attachNewBrowserOnCreation) {
        this(null, attachNewBrowserOnCreation, null, null);
    }

    public MozillaPanel(VisibilityMode toolbarVisMode, VisibilityMode statusbarVisMode) {
        this(null, true, toolbarVisMode, statusbarVisMode);
    }

    public MozillaPanel(IMozillaWindow containerWin, boolean attachNewBrowserOnCreation, VisibilityMode toolbarVisMode, VisibilityMode statusbarVisMode) {
        this.containerWin = containerWin;
        this.attachNewBrowserOnCreation = attachNewBrowserOnCreation;
        MozillaInitialization.initialize();
        this.toolbarVisMode = toolbarVisMode != null ? toolbarVisMode : VisibilityMode.DEFAULT;
        this.statusbarVisMode = statusbarVisMode != null ? statusbarVisMode : VisibilityMode.DEFAULT;
        this.initialPreferredSize = new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT);
        this.createChrome();
    }

    public void attachNewBrowser() {
        assert (MozillaExecutor.isMozillaThread());
        WindowCreator.attachBrowser(this, 1L, null);
    }

    public void onAttachBrowser(final ChromeAdapter chromeAdapter, final ChromeAdapter parentChromeAdapter) {
        assert (MozillaExecutor.isMozillaThread());
        assert (chromeAdapter != null);
        assert (this.chromeAdapter == null);
        this.chromeAdapter = chromeAdapter;
        this.mozContainer.onAttachBrowser(chromeAdapter);
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                boolean showStatusbar;
                boolean showToolbar;
                VisibilityMode vm = MozillaPanel.this.toolbarVisMode;
                if (vm == VisibilityMode.DEFAULT && parentChromeAdapter != null) {
                    vm = parentChromeAdapter.getPanel().getToolbarVisibilityMode();
                }
                switch (vm) {
                    case FORCED_VISIBLE: {
                        showToolbar = true;
                        break;
                    }
                    case FORCED_HIDDEN: {
                        showToolbar = false;
                        break;
                    }
                    default: {
                        showToolbar = (chromeAdapter.getChromeFlags() & 0x60L) != 0L;
                    }
                }
                MozillaPanel.this.toolbar.setVisible(showToolbar);
                VisibilityMode vm2 = MozillaPanel.this.statusbarVisMode;
                if (vm2 == VisibilityMode.DEFAULT && parentChromeAdapter != null) {
                    vm2 = parentChromeAdapter.getPanel().getStatusbarVisibilityMode();
                }
                switch (vm2) {
                    case FORCED_VISIBLE: {
                        showStatusbar = true;
                        break;
                    }
                    case FORCED_HIDDEN: {
                        showStatusbar = false;
                        break;
                    }
                    default: {
                        showStatusbar = (chromeAdapter.getChromeFlags() & 0x80L) != 0L && (chromeAdapter.getChromeFlags() & 0x40000000L) == 0L;
                    }
                }
                MozillaPanel.this.statusField.setVisible(showStatusbar);
                if (MozillaPanel.this.parentPanel != null) {
                    Dimension d = MozillaPanel.this.parentPanel.getSize();
                    MozillaPanel.this.onSetOuterSize(d.width, d.height);
                } else {
                    MozillaPanel.this.onSetPreferredOuterSize(MozillaPanel.this.initialPreferredSize);
                }
                MozillaPanel.this.adjustLocation(chromeAdapter.getChromeFlags());
                if (MozillaPanel.this.pendingUriToLoad != null) {
                    MozillaPanel.this.load(MozillaPanel.this.pendingUriToLoad);
                } else if (MozillaPanel.this.pendingContentToLoad != null) {
                    MozillaPanel.this.loadHTML(MozillaPanel.this.pendingContentToLoad, MozillaPanel.this.pendingContentUriToLoad);
                }
                MozillaPanel.this.pendingUriToLoad = (MozillaPanel.this.pendingContentToLoad = (MozillaPanel.this.pendingContentUriToLoad = null));
            }
        });
    }

    public void onDetachBrowser() {
        assert (MozillaExecutor.isMozillaThread());
        this.chromeAdapter = null;
        this.mozContainer.onDetachBrowser();
    }

    protected void createChrome() {
        this.setLayout(new BorderLayout());
        this.createToolbar();
        this.toolbar.setVisible(false);
        this.createMozillaPanel();
        this.createStatusbar();
        this.statusField.setVisible(false);
    }

    protected void createToolbar() {
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "North");
        this.backButton = new JChromeButton("back", mt.t("MozillaPanel.Tooltip_Back"));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaPanel.this.goBack();
            }
        });
        this.toolbar.add(this.backButton);
        this.forwardButton = new JChromeButton("forward", mt.t("MozillaPanel.Tooltip_Forward"));
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaPanel.this.goForward();
            }
        });
        this.toolbar.add(this.forwardButton);
        this.reloadButton = new JChromeButton("reload", mt.t("MozillaPanel.Tooltip_Reload"));
        this.reloadButton.setEnabled(false);
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaPanel.this.reload();
            }
        });
        this.toolbar.add(this.reloadButton);
        this.stopButton = new JChromeButton("stop", mt.t("MozillaPanel.Tooltip_Stop"));
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaPanel.this.stop();
            }
        });
        this.toolbar.add(this.stopButton);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.urlBar = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        p.add((Component)this.urlBar, c);
        this.urlBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String uri = MozillaPanel.this.urlBar.getText();
                MozillaPanel.this.load(uri);
            }
        });
        this.toolbar.add(p);
        this.goButton = new JChromeButton("go", mt.t("MozillaPanel.Tooltip_Go"));
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String uri = MozillaPanel.this.urlBar.getText();
                MozillaPanel.this.load(uri);
            }
        });
        this.toolbar.add(this.goButton);
    }

    protected void createMozillaPanel() {
        this.mozContainer = new MozillaContainer();
        this.add((Component)this.mozContainer, "Center");
    }

    public void addNotify() {
        super.addNotify();
        if (MozillaInitialization.isInitialized() && this.attachNewBrowserOnCreation) {
            Runnable r = new Runnable(){

                public void run() {
                    MozillaPanel.this.attachNewBrowser();
                }
            };
            MozillaExecutor.mozAsyncExec(r);
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected void createStatusbar() {
        this.statusField = new JTextField("");
        this.statusField.setEditable(false);
        this.statusField.setFocusable(false);
        this.add((Component)this.statusField, "South");
    }

    protected void adjustLocation(long chromeMask) {
        if (this.containerWin != null) {
            MozillaPanel parentPanel = this.getParentPanel();
            if (parentPanel == null) {
                return;
            }
            IMozillaWindow parentContainerWin = parentPanel.getContainerWindow();
            if (parentContainerWin == null || !parentContainerWin.isShowing()) {
                return;
            }
            Point pos = parentContainerWin.getLocationOnScreen();
            if ((chromeMask & 0x8000000L) != 0L) {
                Dimension parentSize = parentContainerWin.getSize();
                Point p = new Point(parentSize.width / 2, parentSize.height / 2);
                Dimension size = this.containerWin.getSize();
                p.translate(-size.width / 2, -size.height / 2);
                log.trace(String.format("adjustLocation: %d, %d", p.x, p.y));
                pos.translate(p.x, p.y);
                if (pos.x < 0) {
                    pos.x = 0;
                }
                if (pos.y < 0) {
                    pos.y = 0;
                }
            } else {
                Insets insets = this.getInsets();
                pos.translate(insets.top, insets.top);
            }
            this.containerWin.setLocation(pos);
        }
    }

    public void goBack() {
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi(MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.goBack();
            }
        });
    }

    public void goForward() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi(MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.goForward();
            }
        });
    }

    public void reload() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi(MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.reload(0L);
            }
        });
    }

    public void stop() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi(MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.stop(3L);
            }
        });
    }

    public void load(final String uri) {
        if (uri == null || uri.length() == 0) {
            return;
        }
        if (this.chromeAdapter == null) {
            this.pendingUriToLoad = uri;
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi(MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.loadURI(uri, 0L, null, null, null);
            }
        });
    }

    public void loadHTML(String content) {
        this.loadHTML(content, null);
    }

    public void loadHTML(final String content, final String asUrl) {
        if (content == null) {
            return;
        }
        if (this.chromeAdapter == null) {
            this.pendingContentToLoad = content;
            this.pendingContentUriToLoad = asUrl;
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                MozillaAutomation.triggerLoadHTML(MozillaPanel.this, content, asUrl);
            }
        });
    }

    public String getUrl() {
        if (this.chromeAdapter == null) {
            return null;
        }
        return MozillaExecutor.mozSyncExecQuiet(new Callable<String>(){

            @Override
            public String call() {
                return MozillaAutomation.getCurrentURI(MozillaPanel.this);
            }
        });
    }

    public Object jsexec(String script) {
        if (this.chromeAdapter == null) {
            return null;
        }
        return MozillaAutomation.executeJavascript(this, script);
    }

    public MozillaContainer getMozillaContainer() {
        return this.mozContainer;
    }

    public ChromeAdapter getChromeAdapter() {
        return this.chromeAdapter;
    }

    public void setParentPanel(MozillaPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    public MozillaPanel getParentPanel() {
        return this.parentPanel;
    }

    public void setContainerWindow(IMozillaWindow parentWin) {
        this.containerWin = parentWin;
    }

    public IMozillaWindow getContainerWindow() {
        return this.containerWin;
    }

    public void onSetStatus(String text) {
        this.statusField.setText(text);
    }

    public void onEnableBackButton(boolean enabled) {
        this.backButton.setEnabled(enabled);
    }

    public void onEnableForwardButton(boolean enabled) {
        this.forwardButton.setEnabled(enabled);
    }

    public void onEnableReloadButton(boolean enabled) {
        this.reloadButton.setEnabled(true);
    }

    public void onEnableStopButton(boolean enabled) {
        this.stopButton.setEnabled(enabled);
    }

    public void onSetUrlbarText(String url) {
        this.urlBar.setText(url);
    }

    public void onSetOuterSize(int w, int h) {
        if (this.containerWin != null) {
            this.containerWin.setSize(w, h);
        } else {
            log.debug("ignored onSetOuterSize in mozpanel");
        }
    }

    public void onSetPreferredOuterSize(Dimension d) {
        if (this.containerWin != null) {
            this.containerWin.setPreferredSize(d);
        } else {
            log.debug("ignored onSetOuterPreferredSize in mozpanel");
        }
    }

    public void onSetInnerSize(int w, int h) {
        if (this.containerWin != null) {
            Insets insets = this.containerWin.getInsets();
            w = w + insets.left + insets.right;
            h = h + insets.top + insets.bottom;
            this.containerWin.setSize(w, h);
        } else {
            log.debug("ignored onSetInnerSize in mozpanel");
        }
    }

    public void setUpdateTitle(boolean updateTitle) {
        this.updateTitle = updateTitle;
    }

    public void onSetTitle(String title) {
        if (this.updateTitle) {
            this.setTitle(title);
        }
    }

    public void setTitle(String title) {
        Container tabPane;
        Container tab = this;
        for (tabPane = this.getParent(); tabPane != null && !(tabPane instanceof JTabbedPane); tabPane = tabPane.getParent()) {
            tab = tabPane;
        }
        if (tabPane != null) {
            JTabbedPane tabPane2 = (JTabbedPane)tabPane;
            int idx = tabPane2.indexOfComponent(tab);
            if (idx >= 0) {
                tabPane2.setTitleAt(idx, title);
            }
        } else if (this.containerWin != null) {
            this.containerWin.setTitle(title);
        }
    }

    public String getTitle() {
        Container tabPane;
        Container tab = this;
        for (tabPane = this.getParent(); tabPane != null && !(tabPane instanceof JTabbedPane); tabPane = tabPane.getParent()) {
            tab = tabPane;
        }
        if (tabPane != null) {
            JTabbedPane tabPane2 = (JTabbedPane)tabPane;
            int idx = tabPane2.indexOfComponent(tab);
            if (idx >= 0) {
                return tabPane2.getTitleAt(idx);
            }
            log.error("Unknown tab index");
            return "";
        }
        if (this.containerWin != null) {
            return this.containerWin.getTitle();
        }
        log.error("Unknown window type");
        return "";
    }

    public void onSetVisible(boolean visibility) {
        if (visibility && this.isFirstShow) {
            this.adjustLocation(this.chromeAdapter.getChromeFlags());
            this.isFirstShow = false;
        }
        if (this.containerWin != null) {
            if (this.containerWin.isVisible() != visibility) {
                this.containerWin.setVisible(visibility);
            }
        } else {
            log.debug("Ignoring mozilla request to change visibility of the panel");
        }
    }

    public void onLoadingStarted() {
    }

    public void onLoadingEnded() {
    }

    public void onCloseWindow() {
        if (this.containerWin != null) {
            this.onSetVisible(false);
            this.containerWin.dispose();
        } else {
            log.debug("Ignoring mozilla request to close the panel");
        }
    }

    public void onDispatchEvent(AWTEvent e) {
        super.processEvent(e);
    }

    public Document getDocument() {
        if (this.chromeAdapter == null) {
            return null;
        }
        return MozillaExecutor.mozSyncExecQuiet(new Callable<Document>(){

            @Override
            public Document call() {
                nsIDOMDocument nsdoc = MozillaPanel.this.chromeAdapter.getWebBrowser().getContentDOMWindow().getDocument();
                return (Document)NodeFactory.getNodeInstance(nsdoc);
            }
        });
    }

    public void setInitialPreferredSize(Dimension preferredSize) {
        this.initialPreferredSize = preferredSize;
    }

    public VisibilityMode getToolbarVisibilityMode() {
        return this.toolbarVisMode;
    }

    public VisibilityMode getStatusbarVisibilityMode() {
        return this.statusbarVisMode;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public JTextField getStatusbar() {
        return this.statusField;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VisibilityMode {
        DEFAULT,
        FORCED_VISIBLE,
        FORCED_HIDDEN;

    }
}

