/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.examples;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.common.Platform;

public class Example10_RenderToImage {
    public static void main(String[] args) throws Exception {
        MozillaWindow win = new MozillaWindow();
        MozillaPanel moz = win.getPanel();
        win.setSize(1024, 768);
        if (Platform.platform != Platform.OSX) {
            win.addNotify();
        } else {
            win.setUndecorated(true);
            win.setLocation(2000, 2000);
            win.setVisible(true);
        }
        MozillaAutomation.blockingLoad(moz, "http://www.yahoo.com");
        byte[] pngImage = MozillaAutomation.renderToImage(moz);
        ByteArrayInputStream bis = new ByteArrayInputStream(pngImage);
        BufferedImage img = ImageIO.read(bis);
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setSize(300, 300);
        TransPanel p = new TransPanel(img);
        f.getContentPane().add((Component)p, "Center");
        f.setVisible(true);
    }

    static class TransPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        BufferedImage img;
        double angle = 0.0;

        public TransPanel(BufferedImage img) {
            this.img = img;
            this.setBackground(Color.white);
            new Thread(){

                public void run() {
                    while (true) {
                        try {
                            1.sleep(33L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        TransPanel.this.angle += 0.05235987755982988;
                        TransPanel.this.repaint();
                    }
                }
            }.start();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            double w = d.width;
            double h = d.height;
            double ih = this.img.getHeight();
            double iw = this.img.getWidth();
            AffineTransform at = new AffineTransform();
            double sx = 0.66 * w / iw;
            double sy = 0.66 * h / ih;
            iw = sx * iw;
            ih = sy * ih;
            at.translate((w - iw) / 2.0, (h - ih) / 2.0);
            at.rotate(0.7853981633974483 + this.angle, iw / 2.0, ih / 2.0);
            g2.setTransform(at);
            AffineTransform at2 = new AffineTransform();
            at2.scale(sx, sy);
            g2.drawImage(this.img, at2, null);
        }
    }
}

