/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaKeyEvent;
import org.mozilla.browser.MozillaMouseEvent;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.dom.NodeFactory;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;
import org.w3c.dom.Node;

public class DOMAdapter
implements nsIDOMEventListener {
    static Log log = LogFactory.getLog(DOMAdapter.class);
    public static String[] hookedEvents = new String[]{"click", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout", "keydown", "keyup", "keypress"};
    private final ChromeAdapter chromeAdapter;

    DOMAdapter(ChromeAdapter chromeAdapter) {
        this.chromeAdapter = chromeAdapter;
    }

    public void handleEvent(nsIDOMEvent event) {
        assert (MozillaExecutor.isMozillaThread());
        nsIDOMMouseEvent nsmev = XPCOMUtils.qi(event, nsIDOMMouseEvent.class);
        if (nsmev != null) {
            this.fireAWTEvent(nsmev);
        } else {
            nsIDOMKeyEvent nskev = XPCOMUtils.qi(event, nsIDOMKeyEvent.class);
            if (nskev != null) {
                this.fireAWTEvent(nskev);
            }
        }
    }

    private void fireAWTEvent(nsIDOMMouseEvent nsmev) {
        int clickCount;
        int id;
        final MozillaPanel source = this.chromeAdapter.getPanel();
        String type = nsmev.getType();
        if (type.equals("click")) {
            id = 500;
        } else if (type.equals("mousedown")) {
            id = 501;
        } else if (type.equals("mouseup")) {
            id = 502;
        } else if (type.equals("mouseover")) {
            id = 504;
        } else if (type.equals("mousemove")) {
            id = 503;
        } else if (type.equals("mouseout")) {
            id = 505;
        } else {
            log.error("Unknown mouse event type " + type);
            return;
        }
        final Node sourceNode = NodeFactory.getNodeInstance(nsmev.getTarget());
        final long when = System.currentTimeMillis();
        int mods = 0;
        if (nsmev.getShiftKey()) {
            mods |= 0x40;
        }
        if (nsmev.getCtrlKey()) {
            mods |= 0x80;
        }
        if (nsmev.getMetaKey()) {
            mods |= 0x100;
        }
        if (nsmev.getAltKey()) {
            mods |= 0x200;
        }
        if (nsmev.getButton() == 0) {
            mods |= 0x400;
        }
        if (nsmev.getButton() == 1) {
            mods |= 0x800;
        }
        if (nsmev.getButton() == 2) {
            mods |= 0x1000;
        }
        final int modifiers = mods;
        final int x = nsmev.getClientX();
        final int y = nsmev.getClientY();
        int n = clickCount = "click".equals(nsmev.getType()) ? 1 : 0;
        final int button = nsmev.getButton() == 0 ? 1 : (nsmev.getButton() == 1 ? 2 : (nsmev.getButton() == 2 ? 3 : 0));
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                try {
                    MozillaMouseEvent ev = new MozillaMouseEvent(source, sourceNode, id, when, modifiers, x, y, clickCount, false, button);
                    MozillaPanel moz = (MozillaPanel)ev.getSource();
                    moz.onDispatchEvent(ev);
                }
                catch (Exception e) {
                    log.error("failed to dispatch awt event", e);
                }
            }
        });
    }

    private void fireAWTEvent(nsIDOMKeyEvent nskev) {
        int id;
        final MozillaPanel source = this.chromeAdapter.getPanel();
        String type = nskev.getType();
        if (type.equals("keydown")) {
            id = 401;
        } else if (type.equals("keyup")) {
            id = 402;
        } else if (type.equals("keypress")) {
            id = 400;
        } else {
            log.error("Unknown key event type " + type);
            return;
        }
        final Node sourceNode = NodeFactory.getNodeInstance(nskev.getTarget());
        final long when = System.currentTimeMillis();
        int mods = 0;
        if (nskev.getShiftKey()) {
            mods |= 0x40;
        }
        if (nskev.getCtrlKey()) {
            mods |= 0x80;
        }
        if (nskev.getMetaKey()) {
            mods |= 0x100;
        }
        if (nskev.getAltKey()) {
            mods |= 0x200;
        }
        final int modifiers = mods;
        long mozKeyCode = nskev.getKeyCode();
        long mozCharCode = nskev.getCharCode();
        log.debug("moz keycode=" + mozKeyCode + " charcode=" + mozCharCode);
        final int awtKeyCode = id != 400 ? (int)mozKeyCode : 0;
        final char awtKeyChar1 = mozCharCode != 0L ? (char)mozCharCode : (char)'\u0000';
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                try {
                    MozillaKeyEvent ev = new MozillaKeyEvent(source, sourceNode, id, when, modifiers, awtKeyCode, awtKeyChar1);
                    if (awtKeyChar1 == '\u0000' && !ev.isActionKey()) {
                        char awtKeyChar2 = (char)awtKeyCode;
                        if (Character.isLetter(awtKeyChar2) && (modifiers & 0x40) == 0) {
                            awtKeyChar2 = Character.toLowerCase(awtKeyChar2);
                        }
                        ev.setKeyChar(awtKeyChar2);
                    }
                    log.debug("awt id=" + id + " keycode=" + ev.getKeyCode() + " keychar='" + ev.getKeyChar() + "'");
                    MozillaPanel moz = (MozillaPanel)ev.getSource();
                    moz.onDispatchEvent(ev);
                }
                catch (Exception e) {
                    log.error("failed to dispatch awt event", e);
                }
            }
        });
    }

    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface(this, uuid);
    }
}

