/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import mediathek.controller.filme.BeobFilmeLaden;
import mediathek.controller.io.starter.ListeStarts;
import mediathek.controller.io.starter.StartEvent;
import mediathek.controller.io.starter.StartListener;
import mediathek.daten.DDaten;
import mediathek.daten.DatenPset;
import mediathek.gui.OSXAdapter;
import mediathek.gui.beobachter.CellRendererFilme;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiKonstanten;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.TModel;

public class MediathekAuto
extends JFrame {
    private DDaten daten;
    private boolean podsLadenJetzt = false;
    private boolean abosLadenJetzt = false;
    private boolean keinePods = false;
    private boolean keineAbos = false;
    private TModel tModel;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private JButton jButtonAufraeumen;
    private JButton jButtonNachFilm;
    private JButton jButtonStop;
    private JLabel jLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelDownload;
    private JProgressBar jProgressDownloads;
    private JProgressBar jProgressFilme;
    private JProgressBar jProgressPods;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerDownload;
    private JTable jTable1;
    private JTextField jTextFieldDownloads;

    public MediathekAuto(String[] ar) {
        boolean debug = false;
        String pfad = "";
        this.initComponents();
        if (ar != null && ar.length > 0 && !ar[0].startsWith("-")) {
            if (!ar[0].endsWith(File.separator)) {
                ar[0] = ar[0] + File.separator;
            }
            pfad = ar[0];
        }
        this.jProgressDownloads.setForeground(new Color(102, 153, 255));
        this.daten = new DDaten(pfad);
        this.setTitle("MediathekView-Auto");
        if (DDaten.system[15].equals("")) {
            this.jSpinnerDownload.setValue(1);
            DDaten.system[15] = "1";
        } else {
            this.jSpinnerDownload.setValue(Integer.parseInt(DDaten.system[15]));
        }
        if (DDaten.system[1].equals("")) {
            DDaten.system[1] = "0";
        }
        GuiFunktionen.setLook(this);
        this.registerForMacOSXEvents();
        this.initListener();
        this.tModel = ListeStarts.getNewModel();
        this.jTable1.setModel(this.tModel);
        this.jTable1.setDefaultRenderer(Object.class, new CellRendererFilme(this.daten));
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.addMouseListener(new BeobMausTabelle(this.jTable1));
        this.pack();
        this.setDefaultCloseOperation(3);
    }

    private void initListener() {
        this.jSpinnerDownload.addChangeListener(new BeobSpinnerDownload());
        this.daten.starterClass.addListener(new BeobachterStart());
        this.jButtonStop.addActionListener(new AlleAbbrechen());
        this.jButtonNachFilm.addActionListener(new AlleAbbrechenNachFilm());
        this.jButtonAufraeumen.addActionListener(new BeobachterAufraeumen());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MediathekAuto.this.beenden();
            }
        });
        DDaten.filmeLaden.addAdListener(new BeobachterLadenFilme());
    }

    private void progressBar(JProgressBar bar, int max, int progress, String text, boolean seiten) {
        if (max == 0) {
            bar.setIndeterminate(false);
            bar.setMaximum(0);
            bar.setMinimum(0);
            bar.setValue(0);
            bar.setStringPainted(false);
        } else if (max == 1) {
            bar.setIndeterminate(true);
            bar.setMaximum(1);
            bar.setMinimum(0);
            bar.setValue(0);
            bar.setStringPainted(false);
            bar.setVisible(true);
        } else {
            bar.setIndeterminate(false);
            bar.setMaximum(max);
            bar.setMinimum(0);
            int proz = 0;
            if (progress != 0 && (proz = progress * 100 / max) >= 100) {
                proz = 99;
            }
            if (!seiten) {
                bar.setString("( " + proz + "% von " + max + " Themen )  " + GuiFunktionen.textLaenge(50, text));
            }
            bar.setStringPainted(true);
            bar.setValue(progress);
        }
    }

    private void progressBarFilmliste(int max, int progress, String text) {
        if (max == 0) {
            this.jProgressFilme.setString(GuiFunktionen.textLaenge(text));
            this.jProgressFilme.setIndeterminate(false);
            this.jProgressFilme.setMaximum(0);
            this.jProgressFilme.setMinimum(0);
            this.jProgressFilme.setValue(0);
            this.jProgressFilme.setVisible(false);
            this.jButtonStop.setVisible(false);
        } else if (max == 1) {
            this.jProgressFilme.setString(GuiFunktionen.textLaenge(text));
            this.jProgressFilme.setIndeterminate(true);
            this.jProgressFilme.setMaximum(1);
            this.jProgressFilme.setMinimum(0);
            this.jProgressFilme.setValue(0);
            this.jProgressFilme.setVisible(true);
            this.jButtonStop.setVisible(true);
        } else {
            this.jProgressFilme.setIndeterminate(false);
            this.jProgressFilme.setVisible(true);
            this.jButtonStop.setVisible(true);
            this.jProgressFilme.setMaximum(max);
            this.jProgressFilme.setMinimum(0);
            int proz = 0;
            if (progress != 0 && (proz = progress * 100 / max) >= 100) {
                proz = 99;
            }
            this.jProgressFilme.setString(text + "  ( " + proz + "% )");
            this.jProgressFilme.setValue(progress);
        }
        this.jProgressFilme.setStringPainted(true);
        this.validate();
    }

    private void panelUpdate() {
        this.jTable1.repaint();
        this.validate();
    }

    private void tabelleLaden() {
        this.tModel = this.daten.starterClass.getStarterModell(this.tModel);
        this.jTable1.updateUI();
    }

    private void setProgressBarDownload(StartEvent ev) {
        this.panelUpdate();
        if (ev.nixTun()) {
            this.jLabelDownload.setText("Downloads:");
            this.jProgressDownloads.setMaximum(0);
            this.jProgressDownloads.setMinimum(0);
            this.jProgressDownloads.setValue(0);
            this.jProgressDownloads.setStringPainted(false);
        } else {
            this.jLabelDownload.setText("Downloads (" + ev.getMax() + "):");
            this.jProgressDownloads.setMaximum(ev.getMax());
            this.jProgressDownloads.setMinimum(0);
            this.jProgressDownloads.setValue(ev.getProgress());
            this.jProgressDownloads.setStringPainted(true);
        }
        if (ev.getDown() == 0) {
            this.jTextFieldDownloads.setText(String.valueOf(""));
            this.jTextFieldDownloads.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        } else {
            this.jTextFieldDownloads.setText(String.valueOf(ev.getDown()));
            this.jTextFieldDownloads.setBackground(GuiKonstanten.DOWNLOAD_FARBE_RUN);
        }
        this.repaint();
    }

    private void beenden() {
        this.daten.allesAbbrechen();
        MediathekAuto mediathekAuto = this;
        if (mediathekAuto.daten.isGeaendert()) {
            this.daten.allesSpeichern();
        }
    }

    private void undTschuess() {
        this.daten.allesSpeichern();
        this.dispose();
        System.exit(0);
    }

    private synchronized void alleDownloadsAbbrechen() {
        this.daten.allesAbbrechen();
    }

    private synchronized void alleDownloadsAbbrechenNachFilm() {
        this.daten.allesAbbrechenNachFilm();
    }

    private void downloadPods() {
        this.podsLadenJetzt = true;
        this.tabelleLaden();
        this.check();
    }

    private void downloadFilme() {
        this.abosLadenJetzt = true;
        this.tabelleLaden();
        this.check();
    }

    private void check() {
        if (this.keineAbos && this.keinePods) {
            this.undTschuess();
        }
    }

    private void aufraeumen() {
        if (this.jTable1.getModel() != null && this.jTable1.getModel().getRowCount() > 0) {
            TModel tModel = (TModel)this.jTable1.getModel();
            for (int i = 0; i < tModel.getRowCount(); ++i) {
                int s = this.daten.starterClass.getState(tModel.getValueAt(i, 6).toString());
                if (s < 3) continue;
                tModel.removeRow(i);
                --i;
            }
        }
        this.daten.starterClass.aufraeumen();
    }

    private void downloadLoeschen(boolean dauerhaft) {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length > 0) {
            TModel tModel = (TModel)this.jTable1.getModel();
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = this.jTable1.convertRowIndexToModel(rows[i]);
                if (dauerhaft) {
                    this.daten.erledigteAbos.zeileSchreiben(tModel.getValueAt(delRow, 2).toString(), tModel.getValueAt(delRow, 3).toString(), tModel.getValueAt(delRow, 6).toString());
                }
                this.daten.starterClass.filmLoeschen(tModel.getValueAt(delRow, 6).toString());
                tModel.removeRow(delRow);
            }
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void open(DatenPset gruppe) {
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.jProgressDownloads = new JProgressBar();
        this.jButtonStop = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldDownloads = new JTextField();
        this.jLabelDownload = new JLabel();
        this.jProgressPods = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jProgressFilme = new JProgressBar();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jSpinnerDownload = new JSpinner();
        this.jButtonAufraeumen = new JButton();
        this.jButtonNachFilm = new JButton();
        this.setDefaultCloseOperation(3);
        this.jLabel.setText("Liste Podcasts:");
        this.jProgressDownloads.setFont(new Font("Monospaced", 1, 12));
        this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/process-stop.png")));
        this.jButtonStop.setText("sofort stoppen");
        this.jButtonStop.setToolTipText("Downloads sofort stoppen");
        this.jLabel2.setText("laufende Downloads:");
        this.jTextFieldDownloads.setEditable(false);
        this.jTextFieldDownloads.setHorizontalAlignment(0);
        this.jLabelDownload.setText("Downloads:");
        this.jProgressPods.setFont(new Font("Monospaced", 1, 12));
        this.jLabel1.setText("Liste Filme:");
        this.jProgressFilme.setFont(new Font("Monospaced", 1, 12));
        this.jLabel3.setText("Downloads:");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jSpinnerDownload.setModel(new SpinnerNumberModel(1, 1, 9, 1));
        this.jButtonAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-clear.png")));
        this.jButtonAufraeumen.setText("Aufr\u00e4umen");
        this.jButtonAufraeumen.setToolTipText("Abgeschlossene Downloads aus der Tabelle entfernen");
        this.jButtonNachFilm.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/emblem-unreadable.png")));
        this.jButtonNachFilm.setText("nach Film stoppen");
        this.jButtonNachFilm.setToolTipText("Downloads nach dem Laufendem Film abbrechen");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 830, Short.MAX_VALUE).addComponent(this.jLabel).addComponent(this.jProgressPods, -1, 830, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jProgressFilme, -1, 830, Short.MAX_VALUE).addComponent(this.jLabel3).addComponent(this.jProgressDownloads, GroupLayout.Alignment.TRAILING, -1, 830, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabelDownload).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 507, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDownloads, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerDownload, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonStop).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonNachFilm).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonAufraeumen))).addContainerGap()));
        layout.linkSize(0, this.jButtonAufraeumen, this.jButtonNachFilm, this.jButtonStop);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressPods, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressFilme, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressDownloads, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelDownload).addComponent(this.jSpinnerDownload, -2, -1, -2).addComponent(this.jTextFieldDownloads, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 143, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonStop).addComponent(this.jButtonNachFilm).addComponent(this.jButtonAufraeumen)).addContainerGap()));
        layout.linkSize(1, this.jProgressDownloads, this.jProgressFilme, this.jProgressPods);
        layout.linkSize(1, this.jButtonAufraeumen, this.jButtonNachFilm, this.jButtonStop);
        this.pack();
    }

    public void registerForMacOSXEvents() {
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quitForMac", null));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
            }
        }
    }

    public void quitForMac() {
        this.beenden();
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private BeobUrl beobUrl = new BeobUrl();
        private Point p;
        private JTable tabelle;

        public BeobMausTabelle(JTable ttabelle) {
            this.tabelle = ttabelle;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() > 1) {
                    DatenPset gruppe = ((MediathekAuto)MediathekAuto.this).daten.listePset.getPsetAbspielen();
                    if (gruppe != null) {
                        MediathekAuto.this.open(gruppe);
                    } else {
                        JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.", "keine Standardbutton!", 1);
                    }
                }
            } else if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            JMenuItem itemVor = new JMenuItem("URL kopieren");
            itemVor.addActionListener(this.beobUrl);
            menu.add(itemVor);
            menu.addSeparator();
            JMenuItem itemLoeschen = new JMenuItem("Download l\u00f6schen");
            itemLoeschen.addActionListener(new BeobDownloadLoeschen(false));
            menu.add(itemLoeschen);
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download dauerhaft l\u00f6schen");
            itemDauerhaftLoeschen.addActionListener(new BeobDownloadLoeschen(true));
            menu.add(itemDauerhaftLoeschen);
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobUrl
        implements ActionListener {
            private BeobUrl() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = BeobMausTabelle.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFunktionen.copyToClipboard(BeobMausTabelle.this.tabelle.getModel().getValueAt(BeobMausTabelle.this.tabelle.convertRowIndexToModel(nr), 6).toString());
                }
            }
        }
    }

    private class BeobDownloadLoeschen
    implements ActionListener {
        boolean dauerhaft = false;

        public BeobDownloadLoeschen(boolean d) {
            this.dauerhaft = d;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MediathekAuto.this.downloadLoeschen(this.dauerhaft);
        }
    }

    private class BeobachterAufraeumen
    implements ActionListener {
        private BeobachterAufraeumen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MediathekAuto.this.aufraeumen();
        }
    }

    private class BeobSpinnerDownload
    implements ChangeListener {
        private BeobSpinnerDownload() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            MediathekAuto.this.daten;
            DDaten.system[15] = String.valueOf(((Number)MediathekAuto.this.jSpinnerDownload.getModel().getValue()).intValue());
            MediathekAuto.this.daten;
            DDaten.setGeaendert();
        }
    }

    private class BeobachterLadenFilme
    extends BeobFilmeLaden {
        private BeobachterLadenFilme() {
        }
    }

    private class BeobachterStart
    implements StartListener {
        private BeobachterStart() {
        }

        @Override
        public void starter(StartEvent ev) {
            MediathekAuto.this.setProgressBarDownload(ev);
            if (ev.nixTun() && MediathekAuto.this.podsLadenJetzt && MediathekAuto.this.abosLadenJetzt) {
                MediathekAuto.this.undTschuess();
            }
        }
    }

    private class AlleAbbrechenNachFilm
    implements ActionListener {
        private AlleAbbrechenNachFilm() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MediathekAuto.this.alleDownloadsAbbrechenNachFilm();
        }
    }

    private class AlleAbbrechen
    implements ActionListener {
        private AlleAbbrechen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MediathekAuto.this.alleDownloadsAbbrechen();
        }
    }
}

