/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filme.filmUpdateServer;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.Daten;
import mediathek.controller.filme.filmUpdateServer.DatenFilmUpdateServer;
import mediathek.controller.filme.filmUpdateServer.ListeFilmUpdateServer;

public class FilmUpdateServerSuchen {
    public static String[] getListe(String url, ListeFilmUpdateServer sListe) throws MalformedURLException, IOException, XMLStreamException {
        String[] ret = new String[]{"", "", ""};
        sListe.clear();
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        int timeout = 10000;
        URLConnection conn = new URL(url).openConnection();
        conn.setRequestProperty("User-Agent", Daten.getUserAgent());
        conn.setReadTimeout(timeout);
        conn.setConnectTimeout(timeout);
        InputStreamReader inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
        XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 1) continue;
            if (parser.getLocalName().equals("Program_Version")) {
                ret[0] = parser.getElementText();
                continue;
            }
            if (parser.getLocalName().equals("Program_Release_Info")) {
                ret[1] = parser.getElementText();
                continue;
            }
            if (parser.getLocalName().equals("Download_Programm")) {
                ret[2] = parser.getElementText();
                continue;
            }
            if (!parser.getLocalName().equals("Server")) continue;
            FilmUpdateServerSuchen.getServer(parser, sListe);
        }
        return ret;
    }

    private static void getServer(XMLStreamReader parser, ListeFilmUpdateServer sListe) {
        String anzahl = "";
        String zeit = "";
        String datum = "";
        String serverUrl = "";
        try {
            while (parser.hasNext()) {
                String prio = "1";
                int event = parser.next();
                if (event == 2 && parser.getLocalName().equals("Server")) {
                    if (!serverUrl.equals("")) {
                        sListe.addWithCheck(new DatenFilmUpdateServer(serverUrl, prio, zeit, datum, anzahl));
                    }
                    break;
                }
                if (event != 1) continue;
                if (parser.getLocalName().equals("Download_Filme_1")) {
                    serverUrl = parser.getElementText();
                    prio = "1";
                    continue;
                }
                if (parser.getLocalName().equals("Download_Filme_2")) {
                    serverUrl = parser.getElementText();
                    prio = "2";
                    continue;
                }
                if (parser.getLocalName().equals("Datum")) {
                    datum = parser.getElementText();
                    continue;
                }
                if (parser.getLocalName().equals("Zeit")) {
                    zeit = parser.getElementText();
                    continue;
                }
                if (!parser.getLocalName().equals("Anzahl")) continue;
                anzahl = parser.getElementText();
            }
        }
        catch (XMLStreamException ex) {
            // empty catch block
        }
    }
}

