/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filme.filmeImportieren;

import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.Log;
import mediathek.controller.filme.FilmListener;
import mediathek.controller.filme.FilmListenerElement;
import mediathek.controller.filme.FilmeLaden;
import mediathek.controller.filme.filmUpdateServer.FilmUpdateServer;
import mediathek.controller.io.IoXmlFilmlisteLesen;
import mediathek.daten.ListeFilme;

public class FilmeImportieren {
    public ListeFilme listeFilme;
    public String[] filmlisteMetaDaten;
    private EventListenerList listeners = new EventListenerList();
    private IoXmlFilmlisteLesen ioXmlFilmlisteLesen = null;
    public FilmUpdateServer filmUpdateServer = new FilmUpdateServer();

    public FilmeImportieren() {
        this.ioXmlFilmlisteLesen = new IoXmlFilmlisteLesen();
        this.ioXmlFilmlisteLesen.addAdListener(new BeobLaden());
    }

    public void filmeImportierenAuto() {
        new Thread(new FilmeImportierenAutoThread()).start();
    }

    public void filmeDirektImportierenDatei(String pfad, boolean istUrl) {
        this.urlLaden(pfad, istUrl);
    }

    public void filmeImportierenDatei(String pfad, boolean istUrl) {
        new Thread(new filmeImportierenDateiThread(pfad, istUrl)).start();
    }

    private boolean urlLaden(String dateiUrl, boolean istUrl) {
        boolean ret = false;
        try {
            if (!dateiUrl.equals("")) {
                Log.systemMeldung("Filmliste laden von: " + dateiUrl);
                this.listeFilme = new ListeFilme();
                ret = this.ioXmlFilmlisteLesen.filmlisteLesen(dateiUrl, istUrl, this.listeFilme);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung("ImportListe.urlLaden: ", ex);
        }
        return ret;
    }

    private synchronized void fertigMelden() {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig(new FilmListenerElement("", "", 0, 0));
        }
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    private class BeobLaden
    implements FilmListener {
        private BeobLaden() {
        }

        @Override
        public synchronized void start(FilmListenerElement filmListenerElement) {
            for (FilmListener l : (FilmListener[])FilmeImportieren.this.listeners.getListeners(FilmListener.class)) {
                l.start(filmListenerElement);
            }
        }

        @Override
        public synchronized void progress(FilmListenerElement filmListenerElement) {
            for (FilmListener l : (FilmListener[])FilmeImportieren.this.listeners.getListeners(FilmListener.class)) {
                l.progress(filmListenerElement);
            }
        }

        @Override
        public synchronized void fertig(FilmListenerElement filmListenerElement) {
            for (FilmListener l : (FilmListener[])FilmeImportieren.this.listeners.getListeners(FilmListener.class)) {
                l.fertig(filmListenerElement);
            }
        }
    }

    private class filmeImportierenDateiThread
    implements Runnable {
        String pfad;
        boolean istUrl;

        public filmeImportierenDateiThread(String ppfad, boolean iistUrl) {
            this.pfad = ppfad;
            this.istUrl = iistUrl;
        }

        @Override
        public synchronized void run() {
            if (!FilmeImportieren.this.urlLaden(this.pfad, this.istUrl)) {
                JOptionPane.showMessageDialog(null, "Das Laden der Filmliste hat nicht geklappt!", "Fehler", 0);
            }
        }
    }

    private class FilmeImportierenAutoThread
    implements Runnable {
        private FilmeImportierenAutoThread() {
        }

        @Override
        public synchronized void run() {
            boolean ret = false;
            FilmeLaden.updateUrl = FilmeImportieren.this.filmUpdateServer.suchen();
            if (!FilmeLaden.updateUrl.equals("")) {
                for (int i = 0; i < 10; ++i) {
                    if (FilmeImportieren.this.urlLaden(FilmeLaden.updateUrl, true)) {
                        ret = true;
                        break;
                    }
                    FilmeLaden.updateUrl = FilmeImportieren.this.filmUpdateServer.listeUpdateServer.getRand(i);
                }
            } else {
                FilmeImportieren.this.fertigMelden();
            }
            if (!ret) {
                JOptionPane.showMessageDialog(null, "Das Laden der Filmliste hat nicht geklappt!", "Fehler", 0);
                Log.fehlerMeldung("Filme laden", "Es konnten keine Filme geladen werden!");
            }
        }
    }
}

