/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filme.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.Daten;
import mediathek.Log;
import mediathek.controller.filme.filmeSuchen.FilmeSuchen;
import mediathek.controller.filme.filmeSuchen.sender.MediathekReader;
import mediathek.controller.io.GetUrl;
import mediathek.daten.DatenFilm;

public class MediathekMdr
extends MediathekReader
implements Runnable {
    public static final String SENDER = "MDR";
    private String addr = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100.html";

    public MediathekMdr(FilmeSuchen ssearch) {
        super(ssearch, SENDER, "MDR  (ca. 3 MB, 1000 Filme)", 2, 1000);
    }

    @Override
    public void addToList() {
        String MUSTER = "<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_letter-";
        String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100_letter-";
        StringBuffer seite = new StringBuffer();
        this.listeThemen.clear();
        seite = this.getUrlIo.getUri_Utf(this.senderName, this.addr, seite, "");
        int pos = 0;
        int pos1 = 0;
        int pos2 = 0;
        String url = "";
        while ((pos = seite.indexOf("<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_letter-", pos)) != -1) {
            pos1 = pos += "<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_letter-".length();
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
            }
            if (url.equals("")) {
                Log.fehlerMeldung("MediathekMdr.addToList", "keine URL");
                continue;
            }
            url = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100_letter-" + url;
            if (this.istInListe(this.listeThemen, url, 0)) continue;
            this.listeThemen.add(new String[]{url});
        }
        if (!Daten.filmeLaden.getStop() && this.listeThemen.size() > 0) {
            this.meldungStart(this.listeThemen.size());
            MediathekMdr.listeSort(this.listeThemen, 0);
            for (int t = 0; t < this.senderMaxThread; ++t) {
                new Thread(new MdrThemaLaden()).start();
            }
        }
    }

    private class MdrThemaLaden
    implements Runnable {
        GetUrl getUrl;
        private StringBuffer seite1;
        private StringBuffer seite2;
        private StringBuffer seite3;
        private StringBuffer seite4;

        private MdrThemaLaden() {
            this.getUrl = new GetUrl(MediathekMdr.this.senderWartenSeiteLaden);
            this.seite1 = new StringBuffer();
            this.seite2 = new StringBuffer();
            this.seite3 = new StringBuffer();
            this.seite4 = new StringBuffer();
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekMdr.this.meldungAddThread();
                while (!Daten.filmeLaden.getStop() && (link = MediathekMdr.this.getListeThemen()) != null) {
                    MediathekMdr.this.meldungProgress(link[0]);
                    this.addThema(link[0]);
                }
                MediathekMdr.this.meldungThreadUndFertig();
            }
            catch (Exception ex) {
                Log.fehlerMeldung("MediathekMdr.MdrThemaLaden.run", ex);
            }
        }

        void addThema(String strUrlFeed) {
            String MUSTER_TITEL = "title=\"Alle verf\u00fcgbaren Sendungen anzeigen\">";
            String MUSTER_URL = "<h3><a href=\"/mediathek/fernsehen/a-z/";
            String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/";
            int pos = 0;
            int pos2 = 0;
            String thema = "";
            String url = "";
            try {
                this.seite1 = this.getUrl.getUri_Utf(MediathekMdr.this.senderName, strUrlFeed, this.seite1, "");
                while ((pos = this.seite1.indexOf("<h3><a href=\"/mediathek/fernsehen/a-z/", pos)) != -1) {
                    url = "";
                    pos2 = this.seite1.indexOf("\"", pos += "<h3><a href=\"/mediathek/fernsehen/a-z/".length());
                    if (pos == -1 || pos2 == -1) continue;
                    url = this.seite1.substring(pos, pos2);
                    pos = pos2;
                    if ((pos = this.seite1.indexOf("title=\"Alle verf\u00fcgbaren Sendungen anzeigen\">", pos)) == -1) continue;
                    pos2 = this.seite1.indexOf("<", pos += "title=\"Alle verf\u00fcgbaren Sendungen anzeigen\">".length());
                    if (pos != -1 && pos2 != -1) {
                        thema = this.seite1.substring(pos, pos2);
                        pos = pos2;
                        if (!MediathekMdr.this.themaLaden(MediathekMdr.this.senderName, thema)) continue;
                    }
                    if (url.equals("")) {
                        Log.fehlerMeldung("MediathekMdr.addThema", "keine URL: " + strUrlFeed);
                        continue;
                    }
                    this.addSendug(strUrlFeed, thema, "http://www.mdr.de/mediathek/fernsehen/a-z/" + url);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung("MediathekMdr.addThema", ex);
            }
        }

        private void addSendug(String strUrlFeed, String thema, String urlThema) {
            String MUSTER_START = "<span class=\"ressortHead\">Sendungen von A bis Z</span>";
            String MUSTER = "<a href=\"/mediathek/fernsehen/a-z/";
            String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/";
            LinkedList<String> tmpListe = new LinkedList<String>();
            this.seite2 = this.getUrl.getUri_Utf(MediathekMdr.this.senderName, urlThema, this.seite2, "Thema: " + thema);
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            pos = this.seite2.indexOf("<span class=\"ressortHead\">Sendungen von A bis Z</span>");
            if (pos != -1) {
                while ((pos = this.seite2.indexOf("<a href=\"/mediathek/fernsehen/a-z/", pos)) != -1) {
                    pos1 = pos += "<a href=\"/mediathek/fernsehen/a-z/".length();
                    pos2 = this.seite2.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        url = this.seite2.substring(pos1, pos2);
                    }
                    if (url.equals("")) {
                        Log.fehlerMeldung("MediathekMdr.addSendug", new String[]{"keine URL: " + urlThema, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
                        continue;
                    }
                    url = "http://www.mdr.de/mediathek/fernsehen/a-z/" + url;
                    if (tmpListe.contains(url)) continue;
                    tmpListe.add(url);
                }
            }
            Iterator it = tmpListe.iterator();
            while (it.hasNext()) {
                this.addFilme1(strUrlFeed, thema, (String)it.next());
            }
        }

        void addFilme1(String strUrlFeed, String thema, String urlFilm) {
            String MUSTER_START = "<span class=\"ressortHead\">Sendungen von A bis Z</span>";
            String MUSTER_URL = "<a href=\"/mediathek/fernsehen/a-z/";
            String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/";
            LinkedList<String> tmpListe = new LinkedList<String>();
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            try {
                this.seite3 = this.getUrl.getUri_Utf(MediathekMdr.this.senderName, urlFilm, this.seite3, "Thema: " + thema);
                pos = this.seite3.indexOf("<span class=\"ressortHead\">Sendungen von A bis Z</span>");
                if (pos != -1) {
                    while ((pos = this.seite3.indexOf("<a href=\"/mediathek/fernsehen/a-z/", pos)) != -1) {
                        url = "";
                        pos1 = pos += "<a href=\"/mediathek/fernsehen/a-z/".length();
                        pos2 = this.seite3.indexOf("\"", pos);
                        if (pos1 != -1 && pos2 != -1) {
                            pos = pos2;
                            url = this.seite3.substring(pos1, pos2);
                        }
                        if (url.equals("")) {
                            Log.fehlerMeldung("MediathekMdr.addFilme1", new String[]{"keine URL: " + urlFilm, "Thema: " + thema, " UrlFeed: " + strUrlFeed});
                            continue;
                        }
                        url = "http://www.mdr.de/mediathek/fernsehen/a-z/" + url;
                        if (tmpListe.contains(url)) continue;
                        tmpListe.add(url);
                    }
                    Iterator it = tmpListe.iterator();
                    while (it.hasNext()) {
                        this.addFilme2(strUrlFeed, thema, (String)it.next());
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung("MediathekMdr.addFilme1", ex);
            }
        }

        void addFilme2(String strUrlFeed, String thema, String urlFilm) {
            String MUSTER_TITEL = "<title>";
            String MUSTER_URL = "<a class=\"avWmLink\" href=\"";
            String MUSTER_DATUM = "<meta name=\"date\" content=\"";
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String titel = "";
            String url = "";
            String datum = "";
            try {
                this.seite4 = this.getUrl.getUri_Utf(MediathekMdr.this.senderName, urlFilm, this.seite4, "Thema: " + thema);
                pos = this.seite4.indexOf("<a class=\"avWmLink\" href=\"");
                if (pos != -1) {
                    url = "";
                    pos1 = pos += "<a class=\"avWmLink\" href=\"".length();
                    pos2 = this.seite4.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        url = this.seite4.substring(pos1, pos2);
                    }
                    if (url.equals("")) {
                        Log.fehlerMeldung("MediathekMdr.addFilme2", new String[]{"keine URL: " + urlFilm, "Thema: " + thema, " UrlFeed: " + strUrlFeed});
                    } else {
                        pos = this.seite4.indexOf("<title>");
                        if (pos != -1) {
                            pos1 = pos += "<title>".length();
                            pos2 = this.seite4.indexOf("<", pos);
                            if (pos1 != -1 && pos2 != -1 && (titel = this.seite4.substring(pos1, pos2)).contains("|")) {
                                titel = titel.substring(0, titel.indexOf("|")).trim();
                            }
                        }
                        if ((pos = this.seite4.indexOf("<meta name=\"date\" content=\"")) != -1) {
                            pos1 = pos += "<meta name=\"date\" content=\"".length();
                            pos2 = this.seite4.indexOf("\"", pos);
                            if (pos1 != -1 && pos2 != -1 && (datum = this.seite4.substring(pos1, pos2)).contains("+")) {
                                datum = datum.substring(0, datum.indexOf("+")).trim();
                            }
                        }
                        MediathekMdr.this.addFilm(new DatenFilm(MediathekMdr.this.senderName, thema, strUrlFeed, titel, url, this.convertDatum(datum), this.convertTime(datum)));
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung("MediathekMdr.addFilme2", ex);
            }
        }

        private String convertDatum(String datum) {
            try {
                SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Date filmDate = sdfIn.parse(datum);
                SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
                datum = sdfOut.format(filmDate);
            }
            catch (Exception ex) {
                Log.fehlerMeldung("MediathekMdr.convertDatum", ex);
            }
            return datum;
        }

        private String convertTime(String datum) {
            try {
                SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Date filmDate = sdfIn.parse(datum);
                SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
                datum = sdfOut.format(filmDate);
            }
            catch (Exception ex) {
                Log.fehlerMeldung("MediatheMdr.convertTime", ex);
            }
            return datum;
        }
    }
}

