/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.Daten;
import mediathek.Log;

public class GetUrl {
    public static final long UrlWartenBasis = 500L;
    private int faktorWarten = 1;
    private int timeout = 10000;
    private long wartenBasis = 500L;
    private static LinkedList<Seitenzaehler> listeSeitenZaehler = new LinkedList();
    private static LinkedList<Seitenzaehler> listeSeitenZaehlerFehler = new LinkedList();

    public GetUrl() {
    }

    public GetUrl(int ttimeout, long wwartenBasis) {
        this.timeout = ttimeout;
        this.wartenBasis = wwartenBasis;
    }

    public GetUrl(long wwartenBasis) {
        this.wartenBasis = wwartenBasis;
    }

    public StringBuffer getUri_Utf(String sender, String addr, StringBuffer seite, String meldung) {
        return this.getUri(sender, addr, seite, "UTF-8", this.timeout, meldung);
    }

    public StringBuffer getUri_Iso(String sender, String addr, StringBuffer seite, String meldung) {
        return this.getUri(sender, addr, seite, "ISO-8859-15", this.timeout, meldung);
    }

    public static int getSeitenZaehler(String sender) {
        for (Seitenzaehler sz : listeSeitenZaehler) {
            if (!sz.senderName.equals(sender)) continue;
            return sz.seitenAnzahl;
        }
        return 0;
    }

    public static synchronized int getSeitenZaehler() {
        int ret = 0;
        Iterator it = listeSeitenZaehler.iterator();
        while (it.hasNext()) {
            ret += ((Seitenzaehler)it.next()).seitenAnzahl;
        }
        return ret;
    }

    public static int getSeitenZaehlerFehler(String sender) {
        for (Seitenzaehler sz : listeSeitenZaehlerFehler) {
            if (!sz.senderName.equals(sender)) continue;
            return sz.seitenAnzahl;
        }
        return 0;
    }

    public static synchronized void resetSeitenZaehler() {
        listeSeitenZaehler.clear();
        listeSeitenZaehlerFehler.clear();
    }

    private synchronized void incSeitenZaehler(String sender) {
        boolean gefunden = false;
        for (Seitenzaehler sz : listeSeitenZaehler) {
            if (!sz.senderName.equals(sender)) continue;
            ++sz.seitenAnzahl;
            gefunden = true;
            break;
        }
        if (!gefunden) {
            listeSeitenZaehler.add(new Seitenzaehler(sender));
        }
    }

    private synchronized void incSeitenZaehlerFehler(String sender) {
        boolean gefunden = false;
        for (Seitenzaehler sz : listeSeitenZaehlerFehler) {
            if (!sz.senderName.equals(sender)) continue;
            ++sz.seitenAnzahl;
            gefunden = true;
            break;
        }
        if (!gefunden) {
            listeSeitenZaehlerFehler.add(new Seitenzaehler(sender));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StringBuffer getUri(String sender, String addr, StringBuffer seite, String kodierung, int timeout, String meldung) {
        char[] zeichen = new char[1];
        try {
            long w = this.wartenBasis * (long)this.faktorWarten;
            this.wait(w);
        }
        catch (Exception ex) {
            Log.fehlerMeldung("GetUrl.getUri", ex);
        }
        this.incSeitenZaehler(sender);
        seite.setLength(0);
        InputStream in = null;
        InputStreamReader inReader = null;
        try {
            URL url = new URL(addr);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", Daten.getUserAgent());
            if (timeout > 0) {
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
            }
            in = conn.getInputStream();
            inReader = new InputStreamReader(in, kodierung);
            while (!Daten.filmeLaden.getStop() && inReader.read(zeichen) != -1) {
                seite.append(zeichen);
            }
        }
        catch (Exception ex) {
            this.incSeitenZaehlerFehler(sender);
            if (!meldung.equals("")) {
                Log.fehlerMeldung("GetUrl.getUri f\u00fcr: ", meldung);
            }
            Log.fehlerMeldung("GetUrl.getUri", ex, addr);
        }
        finally {
            try {
                if (in != null) {
                    inReader.close();
                }
            }
            catch (IOException ex) {}
        }
        return seite;
    }

    private class Seitenzaehler {
        String senderName = "";
        int seitenAnzahl = 0;

        public Seitenzaehler(String ssenderName) {
            this.senderName = ssenderName;
            this.seitenAnzahl = 1;
        }
    }
}

