/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipInputStream;
import javax.swing.event.EventListenerList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.Daten;
import mediathek.Log;
import mediathek.controller.filme.FilmListener;
import mediathek.controller.filme.FilmListenerElement;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.tool.DatumZeit;
import mediathek.tool.GuiFunktionen;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class IoXmlFilmlisteLesen {
    private EventListenerList listeners = new EventListenerList();
    private int max = 0;
    private int progress = 0;

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filmlisteLesen(String datei, boolean istUrl, ListeFilme listeFilme) {
        boolean ret = true;
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        InputStreamReader inReader = null;
        int timeout = 10000;
        try {
            ZipInputStream zipInputStream;
            if (istUrl && datei.endsWith(".bz2")) {
                this.notifyStart(1000);
                this.notifyProgress(datei);
            } else {
                this.notifyStart(500);
                this.notifyProgress(datei);
            }
            if (!istUrl) {
                if (datei.endsWith(".bz2")) {
                    BZip2CompressorInputStream bZip2CompressorInputStream = new BZip2CompressorInputStream((InputStream)new FileInputStream(datei));
                    inReader = new InputStreamReader((InputStream)bZip2CompressorInputStream, "UTF-8");
                } else if (datei.endsWith(".zip")) {
                    zipInputStream = new ZipInputStream(new FileInputStream(datei));
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                }
            } else {
                URLConnection conn = new URL(datei).openConnection();
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
                conn.setRequestProperty("User-Agent", Daten.getUserAgent());
                if (datei.endsWith(".bz2")) {
                    File tmpFile = File.createTempFile("mediathek", null);
                    tmpFile.deleteOnExit();
                    BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                    FileOutputStream fOut = new FileOutputStream(tmpFile);
                    byte[] buffer = new byte[100];
                    int n = 0;
                    int count = 0;
                    this.notifyProgress(datei);
                    while (!Daten.filmeLaden.getStop() && -1 != (n = in.read(buffer))) {
                        fOut.write(buffer, 0, n);
                        if (++count <= 30) continue;
                        this.notifyProgress("Download: " + datei);
                        count = 0;
                    }
                    fOut.close();
                    in.close();
                    inReader = new InputStreamReader((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(tmpFile)), "UTF-8");
                } else if (datei.endsWith(".zip")) {
                    zipInputStream = new ZipInputStream(conn.getInputStream());
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
                }
            }
            XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
            ret = this.datenFilmlisteLesen(parser, datei, listeFilme);
        }
        catch (Exception ex) {
            ret = false;
            Log.fehlerMeldung("IoXmlLesen.importDatenFilm", ex, "von: " + datei);
        }
        finally {
            try {
                if (inReader != null) {
                    inReader.close();
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung("IoXmlLesen.importDatenFilm", ex);
            }
        }
        this.notifyFertig(listeFilme);
        return ret;
    }

    private boolean datenFilmlisteLesen(XMLStreamReader parser, String text, ListeFilme listeFilme) {
        boolean ret = true;
        int count = 0;
        text = GuiFunktionen.textLaenge(text);
        DatenFilm datenFilmAlt = new DatenFilm();
        try {
            String filmTag = "X";
            String[] namen = DatenFilm.FILME_COLUMN_NAMES_;
            while (!Daten.filmeLaden.getStop() && parser.hasNext()) {
                int event = parser.next();
                if (event == 1 && parser.getLocalName().equals("Filmliste")) {
                    this.get(parser, event, "Filmliste", ListeFilme.FILMLISTE_COLUMN_NAMES, listeFilme.metaDaten);
                    if (listeFilme.metaDaten[4].startsWith("3")) {
                        filmTag = "X";
                        namen = DatenFilm.FILME_COLUMN_NAMES_;
                    } else {
                        filmTag = "Filme";
                        namen = DatenFilm.FILME_COLUMN_NAMES;
                    }
                    int anz = 1;
                    try {
                        anz = Integer.parseInt(listeFilme.metaDaten[3]);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (event != 1 || !parser.getLocalName().equals(filmTag)) continue;
                DatenFilm datenFilm = new DatenFilm();
                if (!this.get(parser, event, filmTag, namen, datenFilm.arr)) continue;
                if (datenFilm.arr[1].equals("")) {
                    datenFilm.arr[1] = datenFilmAlt.arr[1];
                }
                if (datenFilm.arr[2].equals("")) {
                    datenFilm.arr[2] = datenFilmAlt.arr[2];
                }
                if (++count > 100) {
                    count = 0;
                    this.notifyProgress(text);
                }
                listeFilme.addWithNr(datenFilm);
                datenFilmAlt = datenFilm;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung("IoXml.datenLesenFilme", ex);
            ret = false;
        }
        return ret;
    }

    private boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        int i;
        boolean ret = true;
        int maxElem = strRet.length;
        for (i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            Log.fehlerMeldung("IoXmlLesen.get", ex);
        }
        return ret;
    }

    private void notifyStart(int mmax) {
        this.max = mmax;
        this.progress = 0;
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start(new FilmListenerElement("", "", this.max, 0));
        }
    }

    private void notifyProgress(String text) {
        if (this.progress < this.max) {
            ++this.progress;
        }
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress(new FilmListenerElement("", text, this.max, this.progress));
        }
    }

    private void notifyFertig(ListeFilme liste) {
        Log.systemMeldung("Liste Filme gelesen: " + DatumZeit.getHeute_dd_MM_yyyy() + " " + DatumZeit.getJetzt_HH_MM_SS());
        Log.systemMeldung("Anzahl Filme: " + liste.size());
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig(new FilmListenerElement("", "", this.max, this.progress));
        }
    }
}

