/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import mediathek.Log;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class IoXmlFilmlisteSchreiben {
    private XMLOutputFactory outFactory;
    private XMLStreamWriter writer;
    private OutputStreamWriter out = null;
    ZipOutputStream zipOutputStream = null;
    BZip2CompressorOutputStream bZip2CompressorOutputStream = null;

    public void filmeSchreiben(String datei, ListeFilme listeFilme) {
        try {
            Log.systemMeldung("Filme Schreiben");
            this.xmlSchreibenStart(datei);
            this.xmlSchreibenFilmliste(listeFilme);
            this.xmlSchreibenEnde(datei);
        }
        catch (Exception ex) {
            Log.fehlerMeldung("IoXmlSchreiben.FilmeSchreiben", ex, "nach: " + datei);
        }
    }

    private void xmlSchreibenStart(String datei) throws Exception {
        File file = new File(datei);
        Log.systemMeldung("Start Schreiben nach: " + datei);
        this.outFactory = XMLOutputFactory.newInstance();
        if (datei.endsWith(".bz2")) {
            this.bZip2CompressorOutputStream = new BZip2CompressorOutputStream((OutputStream)new FileOutputStream(file), 2);
            this.out = new OutputStreamWriter((OutputStream)this.bZip2CompressorOutputStream, "UTF-8");
        } else if (datei.endsWith(".zip")) {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            ZipEntry entry = new ZipEntry("filme.xml");
            this.zipOutputStream.putNextEntry(entry);
            this.out = new OutputStreamWriter((OutputStream)this.zipOutputStream, "UTF-8");
        } else {
            this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        }
        this.writer = this.outFactory.createXMLStreamWriter(this.out);
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeCharacters("\n");
        this.writer.writeStartElement("Mediathek");
        this.writer.writeCharacters("\n");
    }

    private void xmlSchreibenFilmliste(ListeFilme listeFilme) {
        listeFilme.metaDaten[4] = "3.0.0";
        this.xmlSchreibenDaten("Filmliste", ListeFilme.FILMLISTE_COLUMN_NAMES, listeFilme.metaDaten);
        this.xmlSchreibenDaten("Filmliste-Infos", ListeFilme.FILMLISTE_INFOS_COLUMN_NAMES, listeFilme.infos);
        this.xmlSchreibenFeldInfo();
        DatenFilm datenFilmAlt = new DatenFilm();
        ListIterator iterator = listeFilme.listIterator();
        while (iterator.hasNext()) {
            DatenFilm datenFilm = (DatenFilm)iterator.next();
            DatenFilm kopie = datenFilm.getCopy();
            if (datenFilm.arr[1].equals(datenFilmAlt.arr[1])) {
                datenFilm.arr[1] = "";
            }
            if (datenFilm.arr[2].equals(datenFilmAlt.arr[2])) {
                datenFilm.arr[2] = "";
            }
            this.xmlSchreibenDaten("X", DatenFilm.FILME_COLUMN_NAMES_, datenFilm.getClean().arr);
            datenFilmAlt = kopie;
        }
    }

    private void xmlSchreibenFeldInfo() {
        int xmlMax = DatenFilm.FILME_COLUMN_NAMES.length;
        try {
            this.writer.writeStartElement("Feldinfo");
            this.writer.writeCharacters("\n");
            for (int i = 0; i < xmlMax; ++i) {
                this.writer.writeStartElement(DatenFilm.FILME_COLUMN_NAMES_[i]);
                this.writer.writeCharacters(DatenFilm.FILME_COLUMN_NAMES[i]);
                this.writer.writeEndElement();
                this.writer.writeCharacters("\n");
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            Log.fehlerMeldung("IoXmlSchreiben.xmlSchreibenFeldInfo", ex);
        }
    }

    private void xmlSchreibenDaten(String xmlName, String[] xmlSpalten, String[] datenArray) {
        int xmlMax = datenArray.length;
        try {
            this.writer.writeStartElement(xmlName);
            for (int i = 0; i < xmlMax; ++i) {
                if (datenArray[i].equals("")) continue;
                this.writer.writeStartElement(xmlSpalten[i]);
                this.writer.writeCharacters(datenArray[i]);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            Log.fehlerMeldung("IoXmlSchreiben.xmlSchreibenDaten", ex);
        }
    }

    private void xmlSchreibenEnde(String datei) throws Exception {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
        if (datei.endsWith(".bz2")) {
            this.writer.close();
            this.bZip2CompressorOutputStream.close();
        } else if (datei.endsWith(".zip")) {
            this.zipOutputStream.closeEntry();
            this.writer.close();
            this.zipOutputStream.close();
        } else {
            this.writer.close();
        }
        Log.systemMeldung("geschrieben!");
    }
}

