/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.Daten;
import mediathek.Log;
import mediathek.daten.DDaten;
import mediathek.gui.dialog.DialogHinweisUpdate;
import mediathek.tool.DatumZeit;

public class ProgrammUpdateSuchen {
    public boolean checkVersion(DDaten ddaten, boolean anzeigen) {
        boolean neueVersion = false;
        try {
            String[] ret = this.suchen();
            String version = ret[0];
            String release = ret[1];
            String downloadUrlProgramm = ret[2];
            if (!version.equals("")) {
                Daten.system[28] = DatumZeit.getHeute_yyyyMMdd();
                if (this.checkObNeueVersion(version, "3.0.0")) {
                    neueVersion = true;
                    new DialogHinweisUpdate(null, true, "   ==================================================\n   Neue Version:\n   " + version + "\n\n" + "   ==================================================\n" + "   \u00c4nderungen:\n" + "   " + release + "\n\n" + "   ==================================================\n" + "   URL:\n" + "   " + downloadUrlProgramm + "\n\n", "Eine neue Version liegt vor").setVisible(true);
                } else {
                    DialogHinweisUpdate dialog = new DialogHinweisUpdate(null, true, "Alles aktuell!", "Update suchen");
                    if (anzeigen) {
                        dialog.setVisible(true);
                    }
                }
            } else {
                new DialogHinweisUpdate(null, true, "Es ist ein Fehler aufgetreten!\n\n", "Fehler bei der Versionspr\u00fcfung!").setVisible(true);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung("FilmUpdateServer.checkVersion", ex);
        }
        return neueVersion;
    }

    private boolean checkObNeueVersion(String infoVersion, String ichVersion) {
        try {
            int info = Integer.parseInt(infoVersion.substring(0, 1) + infoVersion.substring(2, 3) + infoVersion.substring(4, 5));
            int ich = Integer.parseInt(ichVersion.substring(0, 1) + ichVersion.substring(2, 3) + ichVersion.substring(4, 5));
            if (info > ich) {
                return true;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung("FilmUpdateServer.checkObNeueVersion", ex);
        }
        return false;
    }

    private String[] suchen() throws MalformedURLException, IOException, XMLStreamException {
        String[] ret = new String[]{"", "", ""};
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        int timeout = 10000;
        URLConnection conn = new URL("http://zdfmediathk.sourceforge.net/version.xml").openConnection();
        conn.setRequestProperty("User-Agent", Daten.getUserAgent());
        conn.setReadTimeout(timeout);
        conn.setConnectTimeout(timeout);
        InputStreamReader inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
        XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 1) continue;
            if (parser.getLocalName().equals("Program_Version")) {
                ret[0] = parser.getElementText();
                continue;
            }
            if (parser.getLocalName().equals("Program_Release_Info")) {
                ret[1] = parser.getElementText();
                continue;
            }
            if (!parser.getLocalName().equals("Download_Programm")) continue;
            ret[2] = parser.getElementText();
        }
        return ret;
    }
}

