/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.awt.Color;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import mediathek.Daten;
import mediathek.Log;
import mediathek.daten.DDaten;
import mediathek.daten.DatenProg;
import mediathek.daten.ListeProg;
import mediathek.tool.GuiFunktionenProgramme;

public class DatenPset {
    public static final String PROGRAMMSET = "Programmset";
    public static final int PROGRAMMSET_MAX_ELEM = 13;
    public static final String PROGRAMMSET_NAME = "Name";
    public static final int PROGRAMMSET_NAME_NR = 0;
    public static final String PROGRAMMSET_PRAEFIX_DIREKT = "Praefix";
    public static final int PROGRAMMSET_PRAEFIX_DIREKT_NR = 1;
    public static final String PROGRAMMSET_SUFFIX_DIREKT = "Suffix";
    public static final int PROGRAMMSET_SUFFIX_DIREKT_NR = 2;
    public static final String PROGRAMMSET_FARBE = "Farbe";
    public static final int PROGRAMMSET_FARBE_NR = 3;
    public static final String PROGRAMMSET_ZIEL_PFAD = "Zielpfad";
    public static final int PROGRAMMSET_ZIEL_PFAD_NR = 4;
    public static final String PROGRAMMSET_ZIEL_DATEINAME = "Zieldateiname";
    public static final int PROGRAMMSET_ZIEL_DATEINAME_NR = 5;
    public static final String PROGRAMMSET_IST_ABSPIELEN = "Abspielen";
    public static final int PROGRAMMSET_IST_ABSPIELEN_NR = 6;
    public static final String PROGRAMMSET_IST_SPEICHERN = "Speichern";
    public static final int PROGRAMMSET_IST_SPEICHERN_NR = 7;
    public static final String PROGRAMMSET_IST_BUTTON = "Button";
    public static final int PROGRAMMSET_IST_BUTTON_NR = 8;
    public static final String PROGRAMMSET_IST_ABO = "Abo";
    public static final int PROGRAMMSET_IST_ABO_NR = 9;
    public static final String PROGRAMMSET_LAENGE_BESCHRAENKEN = "Laenge";
    public static final int PROGRAMMSET_LAENGE_BESCHRAENKEN_NR = 10;
    public static final String PROGRAMMSET_MAX_LAENGE = "max-Laenge";
    public static final int PROGRAMMSET_MAX_LAENGE_NR = 11;
    public static final String PROGRAMMSET_BESCHREIBUNG = "Beschreibung";
    public static final int PROGRAMMSET_BESCHREIBUNG_NR = 12;
    public static final String[] PROGRAMMSET_COLUMN_NAMES = new String[]{"Name", "Praefix", "Suffix", "Farbe", "Zielpfad", "Zieldateiname", "Abspielen", "Speichern", "Button", "Abo", "Laenge", "max-Laenge", "Beschreibung"};
    public String[] arr;
    private ListeProg listeProg = new ListeProg();

    public DatenPset() {
        this.makeArray();
    }

    public DatenPset(String name) {
        this.makeArray();
        this.arr[0] = name;
    }

    public boolean addProg(DatenProg prog) {
        return this.listeProg.add(prog);
    }

    public ListeProg getListeProg() {
        return this.listeProg;
    }

    public DatenProg getProg(int i) {
        return (DatenProg)this.listeProg.get(i);
    }

    public boolean needsPath() {
        boolean ret = false;
        if (!this.arr[5].contains("%p")) {
            for (DatenProg prog : this.listeProg) {
                if (!prog.arr[3].contains("**")) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public boolean istAbspielen() {
        return Boolean.parseBoolean(this.arr[6]);
    }

    public boolean istSpeichern() {
        return Boolean.parseBoolean(this.arr[7]);
    }

    public boolean istButton() {
        return Boolean.parseBoolean(this.arr[8]);
    }

    public boolean istAbo() {
        return Boolean.parseBoolean(this.arr[9]);
    }

    public boolean isLable() {
        return this.listeProg.isEmpty() && !this.arr[0].equals("");
    }

    public boolean isFreeLine() {
        return this.arr[0].equals("");
    }

    public void setAbspielen(DDaten ddaten) {
        for (DatenPset datenPset : ddaten.listePset) {
            datenPset.arr[6] = Boolean.FALSE.toString();
        }
        this.arr[6] = Boolean.TRUE.toString();
    }

    public void setSpeichern(boolean set) {
        this.arr[7] = Boolean.toString(set);
    }

    public void setButton(boolean set) {
        this.arr[8] = Boolean.toString(set);
    }

    public void setAbo(boolean set) {
        this.arr[9] = Boolean.toString(set);
    }

    public DatenProg getProgUrl(String url) {
        DatenProg ret = null;
        if (this.listeProg.size() == 0) {
            JOptionPane.showMessageDialog(null, "Programme einrichten!", "Kein Programm", 1);
        } else if (this.listeProg.size() == 1) {
            ret = (DatenProg)this.listeProg.getFirst();
        } else {
            for (DatenProg prog : this.listeProg) {
                if (!prog.urlTesten(url)) continue;
                ret = prog;
                break;
            }
            if (this.listeProg.size() > 0 && ret == null) {
                ret = (DatenProg)this.listeProg.getLast();
            }
        }
        return ret;
    }

    public String getZielDateiname(String url) {
        DatenProg prog = this.getProgUrl(url);
        String ret = this.arr[5];
        if (this.checkDownloadDirekt(url) != 1 && prog != null && !prog.arr[1].equals("")) {
            ret = prog.arr[1];
        }
        return ret;
    }

    public String getZielPfad() {
        return this.arr[4];
    }

    public DatenPset copy() {
        DatenPset ret = new DatenPset();
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        ret.arr[0] = "Kopie-" + this.arr[0];
        ret.arr[6] = Boolean.toString(false);
        ListIterator it = this.getListeProg().listIterator(0);
        while (it.hasNext()) {
            ret.addProg(((DatenProg)it.next()).copy());
        }
        return ret;
    }

    public Color getFarbe(DDaten daten) {
        Color ret = null;
        if (!this.arr[3].equals("")) {
            String r = this.arr[3].substring(0, this.arr[3].indexOf(","));
            String g = this.arr[3].substring(this.arr[3].indexOf(",") + 1, this.arr[3].lastIndexOf(","));
            String b = this.arr[3].substring(this.arr[3].lastIndexOf(",") + 1);
            try {
                ret = new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
            }
            catch (Exception ex) {
                Log.fehlerMeldung(this.getClass().getName() + ".getFarbe", ex);
            }
        }
        return ret;
    }

    public void setFarbe(Color farbe) {
        this.arr[3] = String.valueOf(farbe.getRed()) + "," + String.valueOf(farbe.getGreen()) + "," + String.valueOf(farbe.getBlue());
    }

    public int checkDownloadDirekt(String url) {
        int ret = 2;
        if ((!this.arr[1].equals("") || !this.arr[2].equals("")) && GuiFunktionenProgramme.praefixTesten(this.arr[1], url, true) && GuiFunktionenProgramme.praefixTesten(this.arr[2], url, false)) {
            ret = 1;
        }
        return ret;
    }

    public String toString() {
        int i;
        String ret = "";
        ret = ret + "================================================" + Daten.LINE_SEPARATOR;
        ret = ret + "| Programmset" + Daten.LINE_SEPARATOR;
        for (i = 0; i < 11; ++i) {
            ret = ret + "| " + PROGRAMMSET_COLUMN_NAMES[i] + ": " + this.arr[i] + Daten.LINE_SEPARATOR;
        }
        for (i = 0; i < this.listeProg.size(); ++i) {
            ret = ret + "|" + Daten.LINE_SEPARATOR;
            ret = ret + ((DatenProg)this.listeProg.get(i)).toString();
        }
        ret = ret + "|_______________________________________________" + Daten.LINE_SEPARATOR;
        return ret;
    }

    private void makeArray() {
        this.arr = new String[13];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
        this.arr[6] = Boolean.toString(false);
        this.arr[7] = Boolean.toString(false);
        this.arr[8] = Boolean.toString(false);
        this.arr[9] = Boolean.toString(false);
    }
}

