/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mediathek.Daten;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.tool.DatumZeit;
import mediathek.tool.TModelAbo;

public class ListeAbo
extends LinkedList<DatenAbo> {
    DDaten daten;
    private int nr = 0;

    public ListeAbo(DDaten ddaten) {
        this.daten = ddaten;
    }

    public boolean addAbo(String filmSender, String filmThema, String filmTitel) {
        boolean ret = false;
        DatenAbo datenAbo = new DatenAbo(filmThema, filmSender, filmThema, filmTitel, filmThema, "");
        DialogEditAbo dialogEditAbo = new DialogEditAbo(null, true, this.daten, datenAbo);
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.ok) {
            if (this.getAbo(filmSender, filmThema, filmTitel) == null) {
                this.addAbo(datenAbo);
                this.sort();
                ret = true;
                Daten.notifyMediathekListener(8, ListeAbo.class.getSimpleName());
            } else {
                JOptionPane.showMessageDialog(null, "Abo existiert bereits", "Abo anlegen", 1);
            }
        }
        return ret;
    }

    public void aboLoeschen(DatenAbo abo) {
        if (abo != null) {
            this.remove(abo);
            Daten.notifyMediathekListener(8, ListeAbo.class.getSimpleName());
        }
    }

    public void addAbo(DatenAbo datenAbo) {
        String str = String.valueOf(this.nr++);
        while (str.length() < 3) {
            str = "0" + str;
        }
        datenAbo.arr[0] = str;
        super.add(datenAbo);
        Daten.notifyMediathekListener(8, ListeAbo.class.getSimpleName());
    }

    public DatenAbo getAboNr(int i) {
        return (DatenAbo)this.get(i);
    }

    public void sort() {
        Collections.sort(this);
    }

    public void addObjectData(TModelAbo model) {
        model.setRowCount(0);
        ListIterator iterator = this.listIterator();
        Object[] object = new Object[10];
        while (iterator.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)iterator.next();
            for (int m = 0; m < 10; ++m) {
                object[m] = m == 8 ? DatumZeit.getDatumForObject(datenAbo.arr[8]) : (m == 1 ? "" : datenAbo.arr[m]);
            }
            model.addRow(object);
        }
    }

    public DatenAbo getAbo(String filmSender, String filmThema, String FilmTitel) {
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)it.next();
            if (!ListeAbo.filterAufAboPruefen(datenAbo.arr[3], datenAbo.arr[4], datenAbo.arr[5], datenAbo.arr[6], filmSender, filmThema, FilmTitel)) continue;
            return datenAbo;
        }
        return null;
    }

    public static boolean filterAufAboPruefen(String aboFilter_SenderSuchen, String aboFilter_themaSuchen, String aboFilter_titelSuchen, String aboFilter_themaTitelSuchen, String imFilm_Sender, String imFilm_Thema, String imFilm_Titel) {
        if ((aboFilter_SenderSuchen.equals("") || imFilm_Sender.equalsIgnoreCase(aboFilter_SenderSuchen)) && (aboFilter_themaSuchen.equals("") || imFilm_Thema.equalsIgnoreCase(aboFilter_themaSuchen)) && (aboFilter_titelSuchen.equals("") || imFilm_Titel.toLowerCase().contains(aboFilter_titelSuchen.toLowerCase()))) {
            if (aboFilter_themaTitelSuchen.equals("")) {
                return true;
            }
            if (ListeAbo.pruefen(aboFilter_themaTitelSuchen, imFilm_Thema)) {
                return true;
            }
            if (ListeAbo.pruefen(aboFilter_themaTitelSuchen, imFilm_Titel)) {
                return true;
            }
        }
        return false;
    }

    private static boolean pruefen(String aboFilter, String im) {
        Pattern p = ListeAbo.makePattern(aboFilter);
        if (p != null) {
            return p.matcher(im).matches();
        }
        if (!aboFilter.contains(" ")) {
            return ListeAbo.textPruefen(aboFilter, im);
        }
        String[] arr = ListeAbo.getArr(aboFilter);
        for (int i = 0; i < arr.length; ++i) {
            if (!ListeAbo.textPruefen(arr[i], im)) continue;
            return true;
        }
        return false;
    }

    private static String[] getArr(String str) {
        LinkedList<String> liste = new LinkedList<String>();
        String[] s = str.split(" ");
        for (int i = 0; i < s.length; ++i) {
            if (s[i].equals("")) continue;
            liste.add(s[i]);
        }
        return liste.toArray(new String[0]);
    }

    private static boolean textPruefen(String aboFilter_themaTitelSuchen, String imFilm) {
        return aboFilter_themaTitelSuchen.equals("") || imFilm.toLowerCase().contains(aboFilter_themaTitelSuchen.toLowerCase());
    }

    public static boolean isPattern(String textSuchen) {
        return textSuchen.startsWith("#:");
    }

    public static Pattern makePattern(String textSuchen) {
        Pattern p = null;
        try {
            if (ListeAbo.isPattern(textSuchen)) {
                p = Pattern.compile(textSuchen.substring(2));
            }
        }
        catch (Exception ex) {
            p = null;
        }
        return p;
    }
}

