/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Daten;
import mediathek.Log;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.gui.GuiFilme;
import mediathek.tool.DatumZeit;

public class ListeBlacklist
extends LinkedList<DatenBlacklist> {
    private long tage = 0L;

    @Override
    public boolean add(DatenBlacklist db) {
        boolean ret = super.add(db);
        Daten.notifyMediathekListener(1, ListeBlacklist.class.getSimpleName());
        return ret;
    }

    public Object[][] getObjectData() {
        int i = 0;
        ListIterator iterator = this.listIterator();
        Object[][] object = new Object[this.size()][2];
        while (iterator.hasNext()) {
            DatenBlacklist blacklist = (DatenBlacklist)iterator.next();
            object[i] = blacklist.arr;
            ++i;
        }
        return object;
    }

    public ListeFilme filterListe(ListeFilme listeFilme) {
        try {
            if (Daten.system[31].equals("") || Daten.system[31].equals("0")) {
                this.tage = 0L;
            } else {
                long max = 86400000L * (long)GuiFilme.COMBO_ZEIT_INT[Integer.parseInt(Daten.system[31])];
                this.tage = new Date().getTime() - max;
            }
        }
        catch (Exception ex) {
            this.tage = 0L;
        }
        ListeFilme listeRet = new ListeFilme();
        if (listeFilme != null) {
            listeRet.setMeta(listeFilme.metaDaten);
            listeRet.setInfo(listeFilme.infos);
            for (DatenFilm film : listeFilme) {
                if (!this.checkBlackOk(film)) continue;
                listeRet.add(film);
            }
        }
        return listeRet;
    }

    private boolean checkBlackOk(DatenFilm film) {
        Iterator it = this.iterator();
        if (this.tage != 0L && !this.checkDate(film)) {
            return false;
        }
        while (it.hasNext()) {
            DatenBlacklist blacklist = (DatenBlacklist)it.next();
            if (!(!blacklist.arr[0].equals("") && !blacklist.arr[1].equals("") ? blacklist.arr[0].equalsIgnoreCase(film.arr[1]) && blacklist.arr[1].equalsIgnoreCase(film.arr[2]) : (!blacklist.arr[0].equals("") ? blacklist.arr[0].equalsIgnoreCase(film.arr[1]) : blacklist.arr[1].equalsIgnoreCase(film.arr[2])))) continue;
            return false;
        }
        return true;
    }

    private boolean checkDate(DatenFilm film) {
        try {
            long d = DatumZeit.getDatumForObject(film).getTime();
            return d == 0L || d > this.tage;
        }
        catch (Exception ex) {
            Log.fehlerMeldung("ListeBlacklist.checkDate: ", ex);
            return true;
        }
    }
}

