/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Daten;
import mediathek.controller.io.starter.Starts;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.DialogPsetSpeichern;
import mediathek.tool.DatumZeit;
import mediathek.tool.TModelDownload;

public class ListeDownloads
extends LinkedList<DatenDownload> {
    private DDaten ddaten;

    public ListeDownloads(DDaten ddaten) {
        this.ddaten = ddaten;
    }

    public void sort() {
        Collections.sort(this);
    }

    public synchronized DatenDownload getDownloadByUrl(String url) {
        DatenDownload ret = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (!d.arr[7].equals(url)) continue;
            ret = d;
            break;
        }
        return ret;
    }

    public synchronized boolean delDownloadByUrl(String url) {
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenDownload)it.next()).arr[7].equals(url)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public synchronized void getModel(TModelDownload tModel, boolean abos, boolean downloads) {
        tModel.setRowCount(0);
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            while (iterator.hasNext()) {
                DatenDownload download = (DatenDownload)iterator.next();
                boolean istAbo = download.istAbo();
                if ((!abos || !istAbo) && (!downloads || istAbo)) continue;
                DatenDownload datenDownload = download.getCopy();
                Object[] object = new Object[19];
                for (int i = 0; i < 19; ++i) {
                    object[i] = i == 13 ? "" : (i == 5 ? DatumZeit.getDatumForObject(datenDownload) : datenDownload.arr[i]);
                }
                tModel.addRow(object);
            }
        }
    }

    public synchronized void addFilmDownload(DatenFilm film) {
        DatenDownload download = new DatenDownload(film, 2);
        DialogPsetSpeichern dialog = new DialogPsetSpeichern(null, true, this.ddaten, film);
        dialog.setVisible(true);
        if (dialog.ok && dialog.gruppe != null) {
            download.aufrufBauen(dialog.gruppe, null);
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!((DatenDownload)it.next()).arr[7].equals(film.arr[6])) continue;
                it.remove();
            }
            this.add(download);
            if (dialog.starten) {
                this.ddaten.starterClass.addStarts(new Starts(download));
            }
            Daten.notifyMediathekListener(7, ListeDownloads.class.getSimpleName());
        }
    }

    public synchronized void abosEintragen() {
        ListIterator itFilm = Daten.listeFilme.listIterator();
        while (itFilm.hasNext()) {
            DatenFilm film = (DatenFilm)itFilm.next();
            DatenAbo abo = this.ddaten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3]);
            if (abo == null || !abo.aboIstEingeschaltet() || this.ddaten.erledigteAbos.urlPruefen(film.arr[6]) || this.checkListe(film.arr[6])) continue;
            abo.arr[8] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
            DDaten.setGeaendert();
            DatenDownload download = new DatenDownload(film, 3);
            DatenPset gruppe = this.ddaten.listePset.getPsetAbo(abo.arr[9]);
            if (!abo.arr[9].equals(gruppe.arr[0])) {
                abo.arr[9] = gruppe.arr[0];
            }
            if (gruppe == null) continue;
            download.aufrufBauen(gruppe, abo);
            this.add(download);
        }
    }

    public synchronized void abosLoschen() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Starts s;
            DatenDownload d = (DatenDownload)it.next();
            if (!d.istAbo() || (s = this.ddaten.starterClass.getStart(d.arr[7])) != null) continue;
            it.remove();
        }
    }

    private boolean checkListe(String url) {
        boolean ret = false;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (!url.equals(d.arr[7])) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

