/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mediathek.Log;
import mediathek.controller.io.IoXmlLesen;
import mediathek.controller.io.ListePsetVorlagen;
import mediathek.daten.DDaten;
import mediathek.daten.ListePset;
import mediathek.gui.PanelVorlage;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.TModel;

public class PanelPsetImport
extends PanelVorlage {
    ListePsetVorlagen listeVorlagen = new ListePsetVorlagen();
    private JButton jButtonAktualisieren;
    private JButton jButtonImportDatei;
    private JButton jButtonImportStandard;
    private JButton jButtonImportText;
    private JButton jButtonImportVorlage;
    private JButton jButtonPfad;
    private JComboBox jComboBoxBs;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTabbedPane jTabbedPane1;
    private JTable jTableVorlagen;
    private JTextArea jTextArea1;
    private JTextArea jTextAreaBeschreibung;
    private JTextArea jTextAreaImport;
    private JTextField jTextFieldBs;
    private JTextField jTextFieldDatei;
    private JTextField jTextFieldName;
    private JTextField jTextFieldUrl;

    public PanelPsetImport(DDaten d) {
        super(d);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jComboBoxBs.setModel(new DefaultComboBoxModel<String>(ListePsetVorlagen.BS));
        this.jComboBoxBs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPsetImport.this.tabelleLaden();
            }
        });
        this.jButtonImportDatei.setEnabled(false);
        this.jButtonImportText.setEnabled(false);
        this.jButtonPfad.addActionListener(new BeobPfad());
        this.jTextFieldDatei.getDocument().addDocumentListener(new BeobPfadDoc());
        this.jTextAreaImport.getDocument().addDocumentListener(new BeobTextArea());
        this.jButtonImportVorlage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PanelPsetImport.this.jTextFieldUrl.getText().equals("")) {
                    PanelPsetImport.this.importDatei(PanelPsetImport.this.jTextFieldUrl.getText());
                }
            }
        });
        this.jButtonImportDatei.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPsetImport.this.importDatei(PanelPsetImport.this.jTextFieldDatei.getText());
            }
        });
        this.jButtonImportText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPsetImport.this.importText();
            }
        });
        this.jButtonAktualisieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPsetImport.this.listeVorlagen.getListe();
                PanelPsetImport.this.tabelleLaden();
            }
        });
        this.jTableVorlagen.getSelectionModel().addListSelectionListener(new BeobTableSelect());
        this.jTableVorlagen.setModel(new TModel(new Object[0][], ListePsetVorlagen.PGR_COLUMN_NAMES));
        this.jButtonImportStandard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFunktionenProgramme.addVorlagen(PanelPsetImport.this.ddaten, GuiFunktionenProgramme.getStandardprogramme(PanelPsetImport.this.ddaten), false);
            }
        });
    }

    private void importDatei(String datei) {
        ListePset pSet = IoXmlLesen.importPset(datei, true);
        GuiFunktionenProgramme.addVorlagen(this.ddaten, pSet, false);
    }

    private void importText() {
        ListePset pSet = IoXmlLesen.importPsetText(this.jTextAreaImport.getText(), true);
        GuiFunktionenProgramme.addVorlagen(this.ddaten, pSet, false);
    }

    private void tabelleLaden() {
        this.jTableVorlagen.setModel(this.listeVorlagen.getTModel(this.jComboBoxBs.getSelectedItem().toString()));
    }

    private void table1Select() {
        String[] vorlage = new String[4];
        for (int i = 0; i < 4; ++i) {
            vorlage[i] = "";
        }
        int selectedTableRow = this.jTableVorlagen.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = this.jTableVorlagen.convertRowIndexToModel(selectedTableRow);
            for (int i = 0; i < 4; ++i) {
                vorlage[i] = this.jTableVorlagen.getModel().getValueAt(selectedModelRow, i).toString();
            }
        }
        this.jTextFieldName.setText(vorlage[0]);
        this.jTextFieldBs.setText(vorlage[2]);
        this.jTextFieldUrl.setText(vorlage[3]);
        this.jTextAreaBeschreibung.setText(vorlage[1]);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableVorlagen = new JTable();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldUrl = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaBeschreibung = new JTextArea();
        this.jButtonImportVorlage = new JButton();
        this.jLabel6 = new JLabel();
        this.jTextFieldBs = new JTextField();
        this.jButtonAktualisieren = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxBs = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jButtonImportStandard = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jTextFieldDatei = new JTextField();
        this.jButtonPfad = new JButton();
        this.jButtonImportDatei = new JButton();
        this.jLabel7 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jTextAreaImport = new JTextArea();
        this.jButtonImportText = new JButton();
        this.jTableVorlagen.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane2.setViewportView(this.jTableVorlagen);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Name:");
        this.jTextFieldName.setEditable(false);
        this.jLabel2.setText("URL:");
        this.jTextFieldUrl.setEditable(false);
        this.jLabel3.setText("Beschreibung:");
        this.jTextAreaBeschreibung.setColumns(20);
        this.jTextAreaBeschreibung.setEditable(false);
        this.jTextAreaBeschreibung.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextAreaBeschreibung);
        this.jButtonImportVorlage.setText("Set Importieren");
        this.jLabel6.setText("Betriebssystem:");
        this.jTextFieldBs.setEditable(false);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldBs).addComponent(this.jTextFieldName))).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(26, 26, 26).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldUrl).addComponent(this.jScrollPane3))).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonImportVorlage))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldBs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldUrl, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane3, -1, 182, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonImportVorlage).addContainerGap()));
        jPanel4Layout.linkSize(1, this.jButtonImportVorlage, this.jTextFieldBs, this.jTextFieldName, this.jTextFieldUrl);
        this.jButtonAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh_16.png")));
        this.jButtonAktualisieren.setToolTipText("Neu laden");
        this.jLabel4.setText("Vorlagen von der Website laden:");
        this.jLabel5.setText("Betriebssystem:");
        this.jComboBoxBs.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 620, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxBs, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAktualisieren))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(7, 7, 7).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.jButtonAktualisieren).addComponent(this.jLabel5).addComponent(this.jComboBoxBs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 154, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Setvorlagen", this.jPanel3);
        this.jButtonImportStandard.setText("Set anlegen");
        this.jTextArea1.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Das Standardprogrammset, das beim ersten Programmstart\nangelegt wird, nochmals anlegen.\n\nDie bestehenden Programmsets bleiben unver\u00e4ndert erhalten.");
        this.jTextArea1.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane4.setViewportView(this.jTextArea1);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 620, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonImportStandard))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonImportStandard).addContainerGap(414, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Standardset", this.jPanel5);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Programmset aus Datei importieren"));
        this.jButtonPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/fileopen_16.png")));
        this.jButtonImportDatei.setText("Set importieren");
        this.jLabel7.setText("Datei/URL:");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap(12, -2).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDatei).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPfad)).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonImportDatei))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonPfad).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDatei, -2, -1, -2).addComponent(this.jLabel7))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonImportDatei).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.linkSize(1, this.jButtonPfad, this.jTextFieldDatei);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Programmset als Text importieren"));
        this.jTextAreaImport.setColumns(20);
        this.jTextAreaImport.setRows(5);
        this.jButtonImportText.setText("Set importieren");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextAreaImport, -1, 586, Short.MAX_VALUE).addGroup(jPanel7Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonImportText))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextAreaImport, -1, 287, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonImportText).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel7, -2, -1, -2).addContainerGap(42, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Set imporieren", this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
    }

    private class BeobTableSelect
    implements ListSelectionListener {
        public int selectedModelRow = -1;

        private BeobTableSelect() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                PanelPsetImport.this.table1Select();
            }
        }
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setFileHidingEnabled(false);
            if (PanelPsetImport.this.jTextFieldDatei.getText().equals("")) {
                chooser.setCurrentDirectory(new File(GuiFunktionen.getHomePath()));
            } else {
                chooser.setCurrentDirectory(new File(PanelPsetImport.this.jTextFieldDatei.getText()));
            }
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    PanelPsetImport.this.jTextFieldDatei.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    Log.fehlerMeldung("PanelImportPset.BeobPfad", ex);
                }
            }
        }
    }

    private class BeobTextArea
    implements DocumentListener {
        private BeobTextArea() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            PanelPsetImport.this.jButtonImportText.setEnabled(!PanelPsetImport.this.jTextAreaImport.getText().equals(""));
            if (PanelPsetImport.this.jTextAreaImport.getText().equals("")) {
                PanelPsetImport.this.jTextAreaImport.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
            } else if (IoXmlLesen.importPsetText(PanelPsetImport.this.jTextAreaImport.getText(), false) != null) {
                PanelPsetImport.this.jTextAreaImport.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
                PanelPsetImport.this.jButtonImportText.setEnabled(true);
            } else {
                PanelPsetImport.this.jTextAreaImport.setBackground(new Color(255, 200, 200));
                PanelPsetImport.this.jButtonImportText.setEnabled(false);
            }
        }
    }

    private class BeobPfadDoc
    implements DocumentListener {
        private BeobPfadDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            PanelPsetImport.this.jButtonImportDatei.setEnabled(!PanelPsetImport.this.jTextFieldDatei.getText().equals(""));
            if (PanelPsetImport.this.jTextFieldDatei.getText().equals("")) {
                PanelPsetImport.this.jTextFieldDatei.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            } else if (IoXmlLesen.importPset(PanelPsetImport.this.jTextFieldDatei.getText(), false) != null) {
                PanelPsetImport.this.jTextFieldDatei.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            } else {
                PanelPsetImport.this.jTextFieldDatei.setBackground(new Color(255, 200, 200));
            }
        }
    }
}

