/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mediathek.Log;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.tool.Datum;

public class DatumZeit {
    public static String getJetzt_ddMMyyyy_HHmm() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getJetzt_HH_MM_SS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getJetzt_HHMMSS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getHeute_yyyyMMdd() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getHeute_dd_MM_yyyy() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String convertDatum(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.fehlerMeldung("DatumDatum.convertDatum", ex);
        }
        return datum;
    }

    public static String convertTime(String zeit) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(zeit);
            SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
            zeit = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.fehlerMeldung("DatumZeit.convertTime", ex);
        }
        return zeit;
    }

    public static String checkDatum(String datum, String fehlermeldung) {
        long MAX = 4320000000L;
        String ret = datum.trim();
        if (ret.equals("")) {
            return "";
        }
        if (!ret.contains(".")) {
            Log.fehlerMeldung("DatumZeit.CheckDatum-1", datum + " " + fehlermeldung);
            return "";
        }
        if (ret.length() != 10) {
            Log.fehlerMeldung("DatumZeit.CheckDatum-2", datum + " " + fehlermeldung);
            return "";
        }
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy");
            Date filmDate = sdfIn.parse(ret);
            if (filmDate.getTime() < 0L) {
                Log.fehlerMeldung("DatumZeit.CheckDatum-3", "Unsinniger Wert: " + datum + " " + fehlermeldung);
                ret = "";
            }
            if (new Date().getTime() + 4320000000L < filmDate.getTime()) {
                Log.fehlerMeldung("DatumZeit.CheckDatum-4", "Unsinniger Wert: " + datum + " " + fehlermeldung);
                ret = "";
            }
        }
        catch (Exception ex) {
            ret = "";
            Log.fehlerMeldung("DatumZeit.checkDatum-5", ex);
            Log.fehlerMeldung("DatumZeit.CheckDatum-6", datum + " " + fehlermeldung);
        }
        if (ret.equals("")) {
            // empty if block
        }
        return ret;
    }

    public static String checkZeit(String datum, String zeit, String text) {
        String ret = zeit.trim();
        if (datum.equals("")) {
            ret = "";
        } else if (!ret.equals("")) {
            if (!ret.contains(":")) {
                ret = "";
            }
            if (ret.length() != 8) {
                ret = "";
            }
            if (ret.equals("")) {
                Log.fehlerMeldung("DatumZeit.CheckZeit", zeit + " " + text);
            }
        }
        return ret;
    }

    public static String datumDrehen(String datum) {
        String ret = "";
        if (!datum.equals("")) {
            try {
                if (datum.length() == 10) {
                    String tmp = datum.substring(6);
                    tmp = tmp + "." + datum.substring(3, 5);
                    ret = tmp = tmp + "." + datum.substring(0, 2);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung("DatumZeit.datumDrehen", ex);
            }
        }
        return ret;
    }

    public static String datumDatumZeitReinigen(String datum) {
        String ret = "";
        ret = datum;
        ret = ret.replace(":", "");
        ret = ret.replace(".", "");
        return ret;
    }

    public static Datum getDatumForObject(String datum) {
        Datum tmp = new Datum(0L);
        if (!datum.equals("")) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                tmp.setTime(sdf.parse(datum).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tmp;
    }

    public static Datum getDatumForObject(DatenFilm film) {
        SimpleDateFormat sdf_datum_zeit = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
        SimpleDateFormat sdf_datum = new SimpleDateFormat("dd.MM.yyyy");
        Datum tmp = new Datum(0L);
        if (!film.arr[4].equals("")) {
            try {
                if (!film.arr[5].equals("")) {
                    tmp.setTime(sdf_datum_zeit.parse(film.arr[4] + film.arr[5]).getTime());
                } else {
                    tmp.setTime(sdf_datum.parse(film.arr[4]).getTime());
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return tmp;
    }

    public static Datum getDatumForObject(DatenDownload datenDownload) {
        SimpleDateFormat sdf_datum_zeit = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
        SimpleDateFormat sdf_datum = new SimpleDateFormat("dd.MM.yyyy");
        Datum tmp = new Datum(0L);
        if (!datenDownload.arr[5].equals("")) {
            try {
                if (!datenDownload.arr[6].equals("")) {
                    tmp.setTime(sdf_datum_zeit.parse(datenDownload.arr[5] + datenDownload.arr[6]).getTime());
                } else {
                    tmp.setTime(sdf_datum.parse(datenDownload.arr[5]).getTime());
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return tmp;
    }
}

