/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden;

import javax.swing.event.EventListenerList;
import mediathek.controller.filmeLaden.ListenerFilmeLaden;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.controller.filmeLaden.importieren.ImportFilmliste;
import mediathek.controller.filmeLaden.importieren.ListeDownloadUrlsFilmlisten;
import mediathek.controller.filmeLaden.importieren.ListeFilmlistenServer;
import mediathek.controller.filmeLaden.suchen.FilmeSuchenSender;
import mediathek.daten.Daten;
import mediathek.daten.ListeFilme;
import mediathek.tool.GuiFunktionen;

public class FilmeLaden {
    public static final int UPDATE_FILME_AUS = 0;
    public static final int UPDATE_FILME_URL = 1;
    public static final int UPDATE_FILME_AUTO = 2;
    public static final int ALTER_FILMLISTE_SEKUNDEN_FUER_AUTOUPDATE = 10800;
    private boolean stop = false;
    private ListeFilme listeFilmeAlt = null;
    private FilmeSuchenSender filmeSuchen;
    private ImportFilmliste filmeImportieren;
    private EventListenerList listeners = new EventListenerList();
    private boolean istAmLaufen = false;

    public FilmeLaden() {
        this.filmeSuchen = new FilmeSuchenSender();
        this.filmeImportieren = new ImportFilmliste();
        this.filmeSuchen.addAdListener(new BeobLadenSuchen());
        this.filmeImportieren.addAdListener(new BeobLadenImportieren());
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    private void notifyStart(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.start(event);
        }
    }

    private void notifyProgress(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.progress(event);
        }
    }

    private void notifyFertig(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.fertig(event);
        }
    }

    public void setAllesLaden(boolean alles) {
        this.filmeSuchen.allesLaden = alles;
    }

    public synchronized void setStop() {
        this.stop = true;
    }

    public synchronized boolean getStop() {
        return this.stop;
    }

    public ListeDownloadUrlsFilmlisten getDownloadUrlsFilmlisten(boolean update) {
        if (update) {
            this.filmeImportieren.filmlistenSuchen.suchen(null);
        }
        return this.filmeImportieren.filmlistenSuchen.listeDownloadUrlsFilmlisten;
    }

    public ListeFilmlistenServer getListeFilmlistnServer() {
        return this.filmeImportieren.filmlistenSuchen.listeFilmlistenServer;
    }

    public String[] getSenderNamen() {
        return this.filmeSuchen.getNamenSenderFilmliste();
    }

    public void importFilmliste(String dateiUrl) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.stop = false;
            if (dateiUrl.equals("")) {
                this.filmeImportieren.filmeImportierenAuto();
            } else {
                this.filmeImportieren.filmeImportierenDatei(dateiUrl, GuiFunktionen.istUrl(dateiUrl));
            }
        }
    }

    public void filmeBeimSenderSuchen(ListeFilme llisteFilme, boolean allesLaden) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.stop = false;
            this.listeFilmeAlt = llisteFilme;
            this.filmeSuchen.filmeBeimSenderLaden(allesLaden, this.listeFilmeAlt);
        }
    }

    public void updateSender(String[] sender, ListeFilme llisteFilme) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.stop = false;
            this.listeFilmeAlt = llisteFilme;
            this.filmeSuchen.updateSender(sender, llisteFilme);
        }
    }

    private void undEnde(ListenerFilmeLadenEvent event, ListeFilme listeFilme) {
        this.istAmLaufen = false;
        Daten.listeFilme = listeFilme != null ? listeFilme : new ListeFilme();
        this.notifyFertig(event);
    }

    private class BeobLadenImportieren
    extends ListenerFilmeLaden {
        private BeobLadenImportieren() {
        }

        @Override
        public synchronized void start(ListenerFilmeLadenEvent event) {
            FilmeLaden.this.notifyStart(event);
        }

        @Override
        public synchronized void progress(ListenerFilmeLadenEvent event) {
            FilmeLaden.this.notifyProgress(event);
        }

        @Override
        public synchronized void fertig(ListenerFilmeLadenEvent event) {
            FilmeLaden.this.undEnde(event, ((FilmeLaden)FilmeLaden.this).filmeImportieren.listeFilme);
        }
    }

    private class BeobLadenSuchen
    extends ListenerFilmeLaden {
        private BeobLadenSuchen() {
        }

        @Override
        public synchronized void start(ListenerFilmeLadenEvent event) {
            FilmeLaden.this.notifyStart(event);
        }

        @Override
        public synchronized void progress(ListenerFilmeLadenEvent event) {
            FilmeLaden.this.notifyProgress(event);
        }

        @Override
        public synchronized void fertig(ListenerFilmeLadenEvent event) {
            FilmeLaden.this.undEnde(event, ((FilmeLaden)FilmeLaden.this).filmeSuchen.listeFilmeNeu);
        }
    }
}

