/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden.importieren;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.controller.filmeLaden.importieren.DatenFilmlistenServer;
import mediathek.controller.filmeLaden.importieren.DatenUrlFilmliste;
import mediathek.controller.filmeLaden.importieren.ListeDownloadUrlsFilmlisten;
import mediathek.controller.filmeLaden.importieren.ListeFilmlistenServer;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.tool.DatumZeit;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.Log;

public class FilmlistenSuchen {
    public static final String FILM_UPDATE_SERVER_PRIO_1 = "1";
    public static final String FILM_UPDATE_SERVER = "film-update-server";
    public static final int FILM_UPDATE_SERVER_MAX_ELEM = 5;
    public static final String FILM_UPDATE_SERVER_NR = "film-update-server-nr";
    public static final int FILM_UPDATE_SERVER_NR_NR = 0;
    public static final String FILM_UPDATE_SERVER_URL = "film-update-server-url";
    public static final int FILM_UPDATE_SERVER_URL_NR = 1;
    public static final String FILM_UPDATE_SERVER_DATUM = "film-update-server-datum";
    public static final int FILM_UPDATE_SERVER_DATUM_NR = 2;
    public static final String FILM_UPDATE_SERVER_ZEIT = "film-update-server-zeit";
    public static final int FILM_UPDATE_SERVER_ZEIT_NR = 3;
    public static final String FILM_UPDATE_SERVER_PRIO = "film-update-server-prio";
    public static final int FILM_UPDATE_SERVER_PRIO_NR = 4;
    public static final String[] FILM_UPDATE_SERVER_COLUMN_NAMES = new String[]{"film-update-server-nr", "film-update-server-url", "film-update-server-datum", "film-update-server-zeit", "film-update-server-prio"};
    public static final String[] FILM_UPDATE_SERVER_COLUMN_NAMES_ANZEIGE = new String[]{"Nr", "Update-Url", "Datum", "Zeit", "Prio"};
    public ListeDownloadUrlsFilmlisten listeDownloadUrlsFilmlisten = new ListeDownloadUrlsFilmlisten();
    public ListeFilmlistenServer listeFilmlistenServer = new ListeFilmlistenServer();

    public String suchen(ArrayList<String> bereitsVersucht) {
        ListeDownloadUrlsFilmlisten tmp = new ListeDownloadUrlsFilmlisten();
        try {
            if (DDaten.debug && !DDaten.system[23].equals("")) {
                FilmlistenSuchen.getDownloadUrlsFilmlisten(DDaten.system[23], tmp, Daten.getUserAgent());
            } else {
                FilmlistenSuchen.getDownloadUrlsFilmlisten("http://zdfmediathk.sourceforge.net/update.xml", tmp, Daten.getUserAgent());
                if (tmp.size() > 0) {
                    this.updateListeFilmlistenServer(tmp);
                    ListenerMediathekView.notify(8, this.getClass().getSimpleName());
                }
                if (tmp.size() == 0) {
                    this.getDownloadUrlsFilmlisten__backuplisten(tmp, Daten.getUserAgent());
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(347895642, 0, "FilmUpdateServer.suchen", ex);
        }
        if (tmp.size() == 0) {
            Log.systemMeldung(new String[]{"Es ist ein Fehler aufgetreten!", "Es konnten keine Updateserver zum aktualisieren der Filme", "gefunden werden."});
        } else {
            this.listeDownloadUrlsFilmlisten = tmp;
        }
        if (this.listeDownloadUrlsFilmlisten.size() < 5) {
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek1/Mediathek_02.bz2", FILM_UPDATE_SERVER_PRIO_1, "03:40:00", this.getTag("03:40:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek1/Mediathek_08.bz2", FILM_UPDATE_SERVER_PRIO_1, "09:10:00", this.getTag("09:10:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek1/Mediathek_10.bz2", FILM_UPDATE_SERVER_PRIO_1, "11:10:00", this.getTag("11:10:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek2/Mediathek_12.bz2", FILM_UPDATE_SERVER_PRIO_1, "13:10:00", this.getTag("13:10:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek3/Mediathek_14.bz2", FILM_UPDATE_SERVER_PRIO_1, "15:10:00", this.getTag("15:10:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek4/Mediathek_16.bz2", FILM_UPDATE_SERVER_PRIO_1, "17:10:00", this.getTag("17:10:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek1/Mediathek_18.bz2", FILM_UPDATE_SERVER_PRIO_1, "19:10:00", this.getTag("19:10:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek1/Mediathek_20.bz2", FILM_UPDATE_SERVER_PRIO_1, "21:10:00", this.getTag("21:10:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek1/Mediathek_22.bz2", FILM_UPDATE_SERVER_PRIO_1, "23:10:00", this.getTag("23:10:00")));
            this.listeDownloadUrlsFilmlisten.add(new DatenUrlFilmliste("http://176.28.14.91/mediathek1/Mediathek_00.bz2", FILM_UPDATE_SERVER_PRIO_1, "01:10:00", this.getTag("01:10:00")));
        }
        this.listeDownloadUrlsFilmlisten.sort();
        String retUrl = this.listeDownloadUrlsFilmlisten.getRand(bereitsVersucht, 0);
        ListenerMediathekView.notify(7, this.getClass().getSimpleName());
        if (bereitsVersucht != null) {
            bereitsVersucht.add(retUrl);
        }
        return retUrl;
    }

    private void updateListeFilmlistenServer(ListeDownloadUrlsFilmlisten tmp) {
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            String serverUrl = ((DatenUrlFilmliste)it.next()).arr[1];
            String url = serverUrl.replace(GuiFunktionen.getDateiName(serverUrl), "");
            url = GuiFunktionen.addUrl(url, "filmlisten.xml");
            this.listeFilmlistenServer.addCheck(new DatenFilmlistenServer(url));
        }
        this.listeFilmlistenServer.alteLoeschen();
    }

    private String getTag(String zeit) {
        SimpleDateFormat sdf_zeit = new SimpleDateFormat("dd.MM.yyyy__HH:mm:ss");
        try {
            Date tmp = sdf_zeit.parse(DatumZeit.getHeute_dd_MM_yyyy() + "__" + zeit);
            if (tmp.compareTo(new Date()) > 0) {
                return DatumZeit.getGestern_dd_MM_yyyy();
            }
            return DatumZeit.getHeute_dd_MM_yyyy();
        }
        catch (Exception ex) {
            return DatumZeit.getHeute_dd_MM_yyyy();
        }
    }

    private void getDownloadUrlsFilmlisten__backuplisten(ListeDownloadUrlsFilmlisten sListe, String userAgent) {
        FilmlistenSuchen.getDownloadUrlsFilmlisten(GuiFunktionen.addUrl("http://176.28.14.91/mediathek1", "filmlisten.xml"), sListe, userAgent);
        FilmlistenSuchen.getDownloadUrlsFilmlisten(GuiFunktionen.addUrl("http://176.28.14.91/mediathek2", "filmlisten.xml"), sListe, userAgent);
        FilmlistenSuchen.getDownloadUrlsFilmlisten(GuiFunktionen.addUrl("http://176.28.14.91/mediathek3", "filmlisten.xml"), sListe, userAgent);
        FilmlistenSuchen.getDownloadUrlsFilmlisten(GuiFunktionen.addUrl("http://176.28.14.91/mediathek4", "filmlisten.xml"), sListe, userAgent);
        Iterator it = this.listeFilmlistenServer.iterator();
        while (it.hasNext() && sListe.size() <= 100) {
            DatenFilmlistenServer fs = (DatenFilmlistenServer)it.next();
            FilmlistenSuchen.getDownloadUrlsFilmlisten(fs.arr[1], sListe, userAgent);
        }
    }

    public static void getDownloadUrlsFilmlisten(String dateiUrl, ListeDownloadUrlsFilmlisten sListe, String userAgent) {
        try {
            InputStreamReader inReader;
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            if (GuiFunktionen.istUrl(dateiUrl)) {
                int timeout = 20000;
                URLConnection conn = new URL(dateiUrl).openConnection();
                conn.setRequestProperty("User-Agent", userAgent);
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
                inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
            } else {
                inReader = new InputStreamReader((InputStream)new FileInputStream(dateiUrl), "UTF-8");
            }
            XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
            while (parser.hasNext()) {
                String parsername;
                int event = parser.next();
                if (event != 1 || (parsername = parser.getLocalName()).equals("Program_Version") || parsername.equals("Program_Release_Info") || parsername.equals("Download_Programm") || !parsername.equals("Server")) continue;
                FilmlistenSuchen.getServer(parser, sListe);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(821069874, 0, FilmlistenSuchen.class.getName(), ex, "Die URL-Filmlisten konnte nicht geladen werden: " + dateiUrl);
        }
    }

    private static void getServer(XMLStreamReader parser, ListeDownloadUrlsFilmlisten sListe) {
        String zeit = "";
        String datum = "";
        String serverUrl = "";
        String prio = "";
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 1) {
                    if (parser.getLocalName().equals("URL")) {
                        serverUrl = parser.getElementText();
                    } else if (parser.getLocalName().equals("Prio")) {
                        prio = parser.getElementText();
                    } else if (parser.getLocalName().equals("Datum")) {
                        datum = parser.getElementText();
                    } else if (parser.getLocalName().equals("Zeit")) {
                        zeit = parser.getElementText();
                    }
                }
                if (event != 2 || !parser.getLocalName().equals("Server")) continue;
                if (!serverUrl.equals("")) {
                    if (prio.equals("")) {
                        prio = FILM_UPDATE_SERVER_PRIO_1;
                    }
                    sListe.addWithCheck(new DatenUrlFilmliste(serverUrl, prio, zeit, datum));
                }
                break;
            }
        }
        catch (XMLStreamException ex) {
            // empty catch block
        }
    }
}

