/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden.importieren;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.controller.filmeLaden.ListenerFilmeLaden;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.controller.filmeLaden.importieren.FilmlistenSuchen;
import mediathek.controller.io.IoXmlFilmlisteLesen;
import mediathek.daten.ListeFilme;
import mediathek.tool.Log;

public class ImportFilmliste {
    public ListeFilme listeFilme;
    public String[] filmlisteMetaDaten;
    private EventListenerList listeners = new EventListenerList();
    private IoXmlFilmlisteLesen ioXmlFilmlisteLesen = null;
    public FilmlistenSuchen filmlistenSuchen = new FilmlistenSuchen();

    public ImportFilmliste() {
        this.ioXmlFilmlisteLesen = new IoXmlFilmlisteLesen();
        this.ioXmlFilmlisteLesen.addAdListener(new BeobLaden());
    }

    public void filmeImportierenAuto() {
        new Thread(new FilmeImportierenAutoThread()).start();
    }

    public void filmeImportierenDatei(String pfad, boolean istUrl) {
        new Thread(new filmeImportierenDateiThread(pfad, istUrl)).start();
    }

    private boolean urlLaden(String dateiUrl, boolean istUrl) {
        boolean ret = false;
        try {
            if (!dateiUrl.equals("")) {
                Log.systemMeldung("Filmliste laden von: " + dateiUrl);
                this.listeFilme = new ListeFilme();
                ret = this.ioXmlFilmlisteLesen.filmlisteLesen(dateiUrl, istUrl, this.listeFilme);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(965412378, 0, "ImportListe.urlLaden: ", ex);
        }
        return ret;
    }

    private synchronized void fertigMelden() {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.fertig(new ListenerFilmeLadenEvent("", "", 0, 0));
        }
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    private class BeobLaden
    extends ListenerFilmeLaden {
        private BeobLaden() {
        }

        @Override
        public synchronized void start(ListenerFilmeLadenEvent event) {
            for (ListenerFilmeLaden l : (ListenerFilmeLaden[])ImportFilmliste.this.listeners.getListeners(ListenerFilmeLaden.class)) {
                l.start(event);
            }
        }

        @Override
        public synchronized void progress(ListenerFilmeLadenEvent event) {
            for (ListenerFilmeLaden l : (ListenerFilmeLaden[])ImportFilmliste.this.listeners.getListeners(ListenerFilmeLaden.class)) {
                l.progress(event);
            }
        }

        @Override
        public synchronized void fertig(ListenerFilmeLadenEvent event) {
        }
    }

    private class filmeImportierenDateiThread
    implements Runnable {
        String pfad;
        boolean istUrl;

        public filmeImportierenDateiThread(String ppfad, boolean iistUrl) {
            this.pfad = ppfad;
            this.istUrl = iistUrl;
        }

        @Override
        public synchronized void run() {
            if (!ImportFilmliste.this.urlLaden(this.pfad, this.istUrl)) {
                JOptionPane.showMessageDialog(null, "Das Laden der Filmliste hat nicht geklappt!", "Fehler", 0);
            }
            ImportFilmliste.this.fertigMelden();
        }
    }

    private class FilmeImportierenAutoThread
    implements Runnable {
        private FilmeImportierenAutoThread() {
        }

        @Override
        public synchronized void run() {
            boolean ret = false;
            ArrayList<String> versuchteUrls = new ArrayList<String>();
            String updateUrl = ImportFilmliste.this.filmlistenSuchen.suchen(versuchteUrls);
            if (!updateUrl.equals("")) {
                for (int i = 0; i < 10; ++i) {
                    if (ImportFilmliste.this.urlLaden(updateUrl, true)) {
                        ret = true;
                        if (i >= 4 || !ImportFilmliste.this.listeFilme.filmlisteIstAelter(18000)) break;
                        Log.systemMeldung("Filmliste zu alt, neuer Versuch");
                    }
                    updateUrl = ImportFilmliste.this.filmlistenSuchen.listeDownloadUrlsFilmlisten.getRand(versuchteUrls, i);
                    versuchteUrls.add(updateUrl);
                }
            }
            if (!ret) {
                JOptionPane.showMessageDialog(null, "Das Laden der Filmliste hat nicht geklappt!", "Fehler", 0);
                Log.fehlerMeldung(951235497, 0, "Filme laden", "Es konnten keine Filme geladen werden!");
            }
            ImportFilmliste.this.fertigMelden();
        }
    }
}

