/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden.suchen;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import mediathek.controller.filmeLaden.ListenerFilmeLaden;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.controller.filmeLaden.suchen.ListeRunSender;
import mediathek.controller.filmeLaden.suchen.RunSender;
import mediathek.controller.filmeLaden.suchen.sender.Mediathek3Sat;
import mediathek.controller.filmeLaden.suchen.sender.MediathekArd;
import mediathek.controller.filmeLaden.suchen.sender.MediathekArdPodcast;
import mediathek.controller.filmeLaden.suchen.sender.MediathekArte7;
import mediathek.controller.filmeLaden.suchen.sender.MediathekBr;
import mediathek.controller.filmeLaden.suchen.sender.MediathekHr;
import mediathek.controller.filmeLaden.suchen.sender.MediathekKika;
import mediathek.controller.filmeLaden.suchen.sender.MediathekMdr;
import mediathek.controller.filmeLaden.suchen.sender.MediathekNdr;
import mediathek.controller.filmeLaden.suchen.sender.MediathekOrf;
import mediathek.controller.filmeLaden.suchen.sender.MediathekRbb;
import mediathek.controller.filmeLaden.suchen.sender.MediathekReader;
import mediathek.controller.filmeLaden.suchen.sender.MediathekSf;
import mediathek.controller.filmeLaden.suchen.sender.MediathekSfPod;
import mediathek.controller.filmeLaden.suchen.sender.MediathekSwr;
import mediathek.controller.filmeLaden.suchen.sender.MediathekWdr;
import mediathek.controller.filmeLaden.suchen.sender.MediathekZdf;
import mediathek.controller.io.GetUrl;
import mediathek.daten.Daten;
import mediathek.daten.ListeFilme;
import mediathek.tool.DatumZeit;
import mediathek.tool.Log;

public class FilmeSuchenSender {
    public LinkedList<MediathekReader> mediathekListe = new LinkedList();
    public boolean allesLaden = false;
    public ListeFilme listeFilmeNeu;
    private ListeFilme listeFilmeAlt = null;
    private EventListenerList listeners = new EventListenerList();
    private ListeRunSender listeSenderLaufen = new ListeRunSender();
    private LinkedList<String> fertigMeldung = new LinkedList();
    private Date startZeit = null;
    private Date stopZeit = null;

    public FilmeSuchenSender() {
        this.mediathekListe.add(new MediathekArd(this, 0));
        this.mediathekListe.add(new MediathekArdPodcast(this, 1));
        this.mediathekListe.add(new MediathekZdf(this, 0));
        this.mediathekListe.add(new MediathekArte7(this, 1));
        this.mediathekListe.add(new Mediathek3Sat(this, 0));
        this.mediathekListe.add(new MediathekSwr(this, 1));
        this.mediathekListe.add(new MediathekNdr(this, 1));
        this.mediathekListe.add(new MediathekKika(this, 0));
        this.mediathekListe.add(new MediathekMdr(this, 0));
        this.mediathekListe.add(new MediathekWdr(this, 0));
        this.mediathekListe.add(new MediathekHr(this, 0));
        this.mediathekListe.add(new MediathekRbb(this, 1));
        this.mediathekListe.add(new MediathekBr(this, 0));
        this.mediathekListe.add(new MediathekSf(this, 1));
        this.mediathekListe.add(new MediathekSfPod(this, 0));
        this.mediathekListe.add(new MediathekOrf(this, 0));
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    public synchronized void filmeBeimSenderLaden(boolean aallesLaden, ListeFilme alteListe) {
        this.allesLaden = aallesLaden;
        this.initStart(alteListe);
        this.listeFilmeNeu.liveStreamEintragen();
        this.mrStarten(0);
        this.mrStarten(1);
    }

    private synchronized void mrStarten(int prio) {
        for (MediathekReader mr : this.mediathekListe) {
            if (mr.getStartPrio() != prio) continue;
            new Thread(mr).start();
        }
        try {
            this.wait(180000L);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(952210369, 0, "FilmeSuchenSender.mrStarten", ex);
        }
    }

    public void updateSender(String[] nameSenderFilmliste, ListeFilme alteListe) {
        boolean starten = false;
        this.initStart(alteListe);
        for (MediathekReader reader : this.mediathekListe) {
            for (String s : nameSenderFilmliste) {
                if (!reader.checkNameSenderFilmliste(s)) continue;
                starten = true;
                new Thread(reader).start();
            }
        }
        if (!starten) {
            this.meldenFertig("");
        }
    }

    public MediathekReader getMReaderNameSenderMreader(String nameSenderMreader) {
        for (MediathekReader reader : this.mediathekListe) {
            if (!reader.getNameSenderMreader().equals(nameSenderMreader)) continue;
            return reader;
        }
        return null;
    }

    public String[] getNamenSenderFilmliste() {
        int i;
        LinkedList<String> liste = new LinkedList<String>();
        Iterator it = this.mediathekListe.iterator();
        while (it.hasNext()) {
            String[] s = ((MediathekReader)it.next()).getNameSenderFilmliste();
            for (i = 0; i < s.length; ++i) {
                liste.add(s[i]);
            }
        }
        String[] ret = new String[liste.size()];
        for (i = 0; i < liste.size(); ++i) {
            ret[i] = (String)liste.get(i);
        }
        return ret;
    }

    public synchronized void melden(String sender, int max, int progress, String text) {
        RunSender runSender = this.listeSenderLaufen.getSender(sender);
        if (runSender != null) {
            runSender.max = max;
            runSender.progress = progress;
        } else {
            Log.systemMeldung("Starten[" + (this.allesLaden ? "alles" : "update") + "] " + sender + ": " + DatumZeit.getJetzt_HH_MM_SS());
            this.listeSenderLaufen.add(new RunSender(sender, max, progress));
            if (this.listeSenderLaufen.size() <= 1) {
                this.notifyStart(new ListenerFilmeLadenEvent(sender, text, this.listeSenderLaufen.getMax(), this.listeSenderLaufen.getProgress()));
            }
        }
        this.notifyProgress(new ListenerFilmeLadenEvent(sender, text, this.listeSenderLaufen.getMax(), this.listeSenderLaufen.getProgress()));
        this.progressBar();
    }

    public void meldenFertig(String sender) {
        int MAX_SENDER = 15;
        int MAX1 = 24;
        int MAX2 = 30;
        Log.systemMeldung("Fertig " + sender + ": " + DatumZeit.getJetzt_HH_MM_SS());
        RunSender run = this.listeSenderLaufen.senderFertig(sender);
        if (run != null) {
            this.fertigMeldung.add("");
            String zeile = "==================================================================================================================";
            this.fertigMeldung.add(zeile);
            zeile = this.textLaenge(MAX_SENDER, run.sender);
            zeile = zeile + this.textLaenge(MAX1, "Laufzeit[Min.]: " + run.getLaufzeitMinuten());
            zeile = zeile + this.textLaenge(MAX1, "      Seiten: " + GetUrl.getSeitenZaehler(1, run.sender));
            String[] nameFilmliste = this.getMReaderNameSenderMreader(run.sender).getNameSenderFilmliste();
            if (nameFilmliste.length == 1) {
                zeile = zeile + "Filme: " + this.listeFilmeNeu.countSender(nameFilmliste[0]);
            } else {
                for (int i = 0; i < nameFilmliste.length; ++i) {
                    zeile = zeile + "Filme [" + nameFilmliste[i] + "]: " + this.listeFilmeNeu.countSender(nameFilmliste[i]) + "  ";
                }
            }
            this.fertigMeldung.add(zeile);
            zeile = this.textLaenge(MAX_SENDER, "");
            zeile = zeile + this.textLaenge(MAX1, "    Ladefehler: " + GetUrl.getSeitenZaehler(2, run.sender));
            zeile = zeile + this.textLaenge(MAX1, "Fehlversuche: " + GetUrl.getSeitenZaehler(3, run.sender));
            zeile = zeile + this.textLaenge(MAX2, "Wartezeit Fehler[s]: " + GetUrl.getSeitenZaehler(4, run.sender));
            String groesse = GetUrl.getSeitenZaehler(5, run.sender) == 0L ? "<1" : Long.toString(GetUrl.getSeitenZaehler(5, run.sender));
            zeile = zeile + this.textLaenge(MAX1, "Daten[MByte]: " + groesse);
            this.fertigMeldung.add(zeile);
        }
        if (this.listeSenderLaufen.listeFertig()) {
            int sekunden;
            Log.progressEnde();
            int anzFilme = this.listeFilmeNeu.size();
            if (!this.allesLaden) {
                this.listeFilmeNeu.updateListe(this.listeFilmeAlt, true);
            }
            this.listeFilmeNeu.sort();
            this.listeFilmeAlt = null;
            this.listeFilmeNeu.metaDatenSchreiben(!Daten.filmeLaden.getStop());
            this.stopZeit = new Date(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            try {
                sekunden = Math.round((this.stopZeit.getTime() - this.startZeit.getTime()) / 1000L);
            }
            catch (Exception ex) {
                sekunden = -1;
            }
            Log.systemMeldung("");
            Log.systemMeldung("");
            Log.systemMeldung("==================================================================================================================");
            Log.systemMeldung("==  Sender  ======================================================================================================");
            Log.systemMeldung("");
            Iterator it = this.fertigMeldung.iterator();
            while (it.hasNext()) {
                Log.systemMeldung((String)it.next());
            }
            Log.systemMeldung("");
            Log.systemMeldung("==================================================================================================================");
            Log.systemMeldung("");
            Log.systemMeldung("        Filme geladen: " + anzFilme);
            Log.systemMeldung("       Seiten geladen: " + GetUrl.getSeitenZaehler(1));
            String groesse = GetUrl.getSeitenZaehler(5) == 0L ? "<1" : Long.toString(GetUrl.getSeitenZaehler(5));
            Log.systemMeldung(" Summe geladen[MByte]: " + groesse);
            if (sekunden <= 0) {
                sekunden = 1;
            }
            long kb = GetUrl.getSeitenZaehler(5) * 1024L / (long)sekunden;
            Log.systemMeldung("     -> Rate[kByte/s]: " + (kb == 0L ? "<1" : Long.valueOf(kb)));
            Log.systemMeldung("     ->    Dauer[Min]: " + (sekunden / 60 == 0 ? "<1" : Integer.valueOf(sekunden / 60)));
            Log.systemMeldung("            ->  Start: " + sdf.format(this.startZeit));
            Log.systemMeldung("            ->   Ende: " + sdf.format(this.stopZeit));
            Log.systemMeldung("");
            Log.systemMeldung("==================================================================================================================");
            Log.systemMeldung("==================================================================================================================");
            this.notifyFertig(new ListenerFilmeLadenEvent(sender, "", this.listeSenderLaufen.getMax(), this.listeSenderLaufen.getProgress()));
        } else {
            this.notifyProgress(new ListenerFilmeLadenEvent(sender, "", this.listeSenderLaufen.getMax(), this.listeSenderLaufen.getProgress()));
        }
    }

    private void initStart(ListeFilme alteListe) {
        this.startZeit = new Date(System.currentTimeMillis());
        this.fertigMeldung.clear();
        this.listeFilmeAlt = alteListe;
        this.listeFilmeNeu = new ListeFilme();
        GetUrl.resetZaehler();
    }

    private void progressBar() {
        int max = this.listeSenderLaufen.getMax();
        int progress = this.listeSenderLaufen.getProgress();
        int proz = 0;
        if (max != 0) {
            int i;
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            if (max > 0 && proz == 100) {
                proz = 99;
            }
            String text = "  [ ";
            int a = proz / 10;
            for (i = 0; i < a; ++i) {
                text = text + "#";
            }
            for (i = 0; i < 10 - a; ++i) {
                text = text + "-";
            }
            text = text + " ]  " + GetUrl.getSeitenZaehler(1) + " Seiten  /  " + proz + "% von " + max + " Themen  /  Filme: " + this.listeFilmeNeu.size();
            Log.progress(text);
        }
    }

    private String textLaenge(int max, String text) {
        if (text.length() > max) {
            text = text.substring(0, max - 1);
        }
        while (text.length() < max) {
            text = text + " ";
        }
        return text;
    }

    private void notifyStart(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.start(event);
        }
    }

    private void notifyProgress(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.progress(event);
        }
    }

    private void notifyFertig(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.fertig(event);
        }
    }
}

