/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden.suchen.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import mediathek.controller.filmeLaden.suchen.FilmeSuchenSender;
import mediathek.controller.filmeLaden.suchen.sender.MediathekReader;
import mediathek.controller.io.GetUrl;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.tool.Log;

public class MediathekNdr
extends MediathekReader
implements Runnable {
    public static final String SENDER = "NDR";

    public MediathekNdr(FilmeSuchenSender ssearch, int startPrio) {
        super(ssearch, SENDER, 4, 500, startPrio);
    }

    @Override
    void addToList() {
        String ADRESSE = "http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_searchtype-broadcasts.xml";
        String MUSTER_URL1 = "<broadcast id=\"";
        this.listeThemen.clear();
        this.meldungStart();
        StringBuffer seite = new StringBuffer(81920);
        seite = this.getUrlIo.getUri(this.nameSenderMReader, "http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_searchtype-broadcasts.xml", "UTF-8", 5, seite, "");
        int pos = 0;
        String url = "";
        String thema = "";
        while ((pos = seite.indexOf("<broadcast id=\"", pos)) != -1) {
            try {
                int pos1 = pos += "<broadcast id=\"".length();
                int pos2 = seite.indexOf("\"", pos);
                if (pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                pos1 = seite.indexOf(">", pos);
                pos2 = seite.indexOf("<", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 < pos2) {
                    thema = seite.substring(pos1 + 1, pos2);
                }
                if (url.equals("")) {
                    Log.fehlerMeldung(-210367600, 2, "MediathekNdr.addToList", "keine Url");
                    continue;
                }
                String[] add = this.suchen.allesLaden ? new String[]{"http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_broadcast-" + url + "_pageSize-300.xml", thema} : new String[]{"http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_broadcast-" + url + "_pageSize-24.xml", thema};
                this.listeThemen.addUrl(add);
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-332945670, 2, "MediathekNdr.finden", ex);
            }
        }
        this.addTage();
        if (Daten.filmeLaden.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                new Thread(new ThemaLaden()).start();
            }
        }
    }

    private void addTage() {
        String[] add = new String[]{"http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_pageSize-24.xml", ""};
        this.listeThemen.addUrl(add);
        int m = this.suchen.allesLaden ? 20 : 10;
        for (int i = 0; i <= m; ++i) {
            add = new String[]{"http://www.ndr.de/mediathek/mediathek100-mediathek_page-" + Integer.toString(i) + "_medium-tv_pageSize-24.xml", ""};
            this.listeThemen.addUrl(add);
        }
    }

    private class ThemaLaden
    implements Runnable {
        GetUrl getUrl;
        private StringBuffer seite1;
        private StringBuffer seite2;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekNdr.this.wartenSeiteLaden);
            this.seite1 = new StringBuffer(81920);
            this.seite2 = new StringBuffer(81920);
        }

        @Override
        public synchronized void run() {
            try {
                String[] link;
                MediathekNdr.this.meldungAddThread();
                while (!Daten.filmeLaden.getStop() && (link = MediathekNdr.this.listeThemen.getListeThemen()) != null) {
                    try {
                        MediathekNdr.this.meldungProgress(link[1]);
                        this.feedEinerSeiteSuchen(link[0], link[1]);
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(-336901211, 2, "MediathekNdr.ThemaLaden.run.1", ex);
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-554632590, 2, "MediathekNdr.ThemaLaden.run.2", ex);
            }
            MediathekNdr.this.meldungThreadUndFertig();
        }

        void feedEinerSeiteSuchen(String strUrlFeed, String tthema) {
            String MUSTER_URL = "<mediaItem id=\"";
            String MUSTER_TITEL = "<title><![CDATA[";
            String MUSTER_THEMA = "<broadcast id=\"";
            String MUSTER_ENDE = "</mediaItem>";
            this.seite1 = MediathekNdr.this.getUrlIo.getUri(MediathekNdr.this.nameSenderMReader, strUrlFeed, "UTF-8", 3, this.seite1, "Thema: " + tthema);
            int pos = 0;
            String titel = "";
            String thema = tthema;
            try {
                while (!Daten.filmeLaden.getStop() && (pos = this.seite1.indexOf("<mediaItem id=\"", pos)) != -1) {
                    int pos1 = pos += "<mediaItem id=\"".length();
                    int posEnde = this.seite1.indexOf("</mediaItem>", pos);
                    int pos2 = this.seite1.indexOf("\"", pos1);
                    if (pos2 == -1) continue;
                    String url = this.seite1.substring(pos1, pos2);
                    if (url.equals("")) {
                        Log.fehlerMeldung(-659210274, 2, "MediathekNdr.feddEinerSeiteSuchen", "keine Url feedEinerSeiteSuchen" + strUrlFeed);
                        continue;
                    }
                    pos1 = this.seite1.indexOf("<title><![CDATA[", pos);
                    if (pos1 != -1 && (pos2 = this.seite1.indexOf("]", pos1 += "<title><![CDATA[".length())) != -1) {
                        titel = this.seite1.substring(pos1, pos2);
                    }
                    if (tthema.equals("")) {
                        thema = "";
                        pos1 = this.seite1.indexOf("<broadcast id=\"", pos);
                        if (pos1 != -1 && pos1 < posEnde) {
                            pos1 += "<broadcast id=\"".length();
                            if ((pos1 = this.seite1.indexOf("\"", pos1)) != -1) {
                                ++pos1;
                                if ((pos2 = this.seite1.indexOf("<", ++pos1)) != -1) {
                                    thema = this.seite1.substring(pos1, pos2);
                                }
                            }
                        }
                        if (thema.equals("")) {
                            thema = MediathekNdr.SENDER;
                        }
                    }
                    this.filmSuchen(strUrlFeed, thema, titel, "http://www.ndr.de/mediathek/" + url + "-mediathek_details-true.xml");
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-693219870, 2, "MediathekNdr.feddEinerSeiteSuchen", strUrlFeed);
            }
        }

        void filmSuchen(String strUrlThema, String thema, String titel, String urlFilm) {
            String MUSTER_DATUM = "<date ";
            String MUSTER_URL = "<source format=\"mp4hq\" mimetype=\"video/mp4\" protocol=\"rtmpt\">";
            this.seite2 = this.getUrl.getUri_Utf(MediathekNdr.this.nameSenderMReader, urlFilm, this.seite2, "strUrlThema: " + strUrlThema);
            MediathekNdr.this.meldung(urlFilm);
            String datum = "";
            String zeit = "";
            try {
                int pos2;
                int pos1;
                int pos = this.seite2.indexOf("<date ");
                if (pos != -1 && (pos1 = this.seite2.indexOf(">", pos += "<date ".length())) != -1 && (pos2 = this.seite2.indexOf("<", ++pos1)) != -1) {
                    String tmp = this.seite2.substring(pos1, pos2);
                    try {
                        SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        Date filmDate = sdfIn.parse(tmp);
                        SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
                        datum = sdfOut.format(filmDate);
                        sdfOut = new SimpleDateFormat("HH:mm:ss");
                        zeit = sdfOut.format(filmDate);
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(-623657941, 2, "MediathekNdr.FilmSuchen", "convertDatum: " + strUrlThema);
                    }
                }
                if ((pos = this.seite2.indexOf("<source format=\"mp4hq\" mimetype=\"video/mp4\" protocol=\"rtmpt\">")) != -1) {
                    pos1 = pos += "<source format=\"mp4hq\" mimetype=\"video/mp4\" protocol=\"rtmpt\">".length();
                    pos2 = this.seite2.indexOf("<", pos);
                    if (pos2 != -1) {
                        String url = this.seite2.substring(pos1, pos2);
                        if (!url.equals("")) {
                            String s1 = "rtmpt://cp160844.edgefcs.net/ondemand/mp4:";
                            String s2 = url.substring(url.indexOf("flashmedia"));
                            String sUrl = s1 + s2;
                            if (!sUrl.equals("")) {
                                MediathekNdr.this.addFilm(new DatenFilm(MediathekNdr.this.nameSenderMReader, thema, strUrlThema, titel, sUrl, datum, zeit));
                            } else {
                                Log.fehlerMeldung(-878542100, 2, "MediathekNdr.FilmSuchen", "Zusammenbau URL: " + url);
                            }
                        } else {
                            Log.fehlerMeldung(-623657941, 2, "MediathekNdr.FilmSuchen", "keine URL: " + urlFilm);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-699830157, 2, "MediathekNdr.FilmSuchen", ex);
            }
        }
    }
}

