/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.daten.Daten;
import mediathek.tool.Log;

public class GetUrl {
    public static final int LISTE_SEITEN_ZAEHLER = 1;
    public static final int LISTE_SEITEN_ZAEHLER_FEHlER = 2;
    public static final int LISTE_SEITEN_ZAEHLER_FEHLERVERSUCHE = 3;
    public static final int LISTE_SEITEN_ZAEHLER_WARTEZEIT_FEHLVERSUCHE = 4;
    public static final int LISTE_SUMME_BYTE = 5;
    private static final long UrlWartenBasis = 500L;
    private int faktorWarten = 1;
    private int timeout = 10000;
    private long wartenBasis = 500L;
    private static LinkedList<Seitenzaehler> listeSeitenZaehler = new LinkedList();
    private static LinkedList<Seitenzaehler> listeSeitenZaehlerFehler = new LinkedList();
    private static LinkedList<Seitenzaehler> listeSeitenZaehlerFehlerVersuche = new LinkedList();
    private static LinkedList<Seitenzaehler> listeSeitenZaehlerWartezeitFehlerVersuche = new LinkedList();
    private static LinkedList<Seitenzaehler> listeSummeByte = new LinkedList();

    public GetUrl(long wwartenBasis) {
        this.wartenBasis = wwartenBasis;
    }

    public StringBuffer getUri_Utf(String sender, String addr, StringBuffer seite, String meldung) {
        return this.getUri(sender, addr, "UTF-8", 1, seite, meldung);
    }

    public StringBuffer getUri_Iso(String sender, String addr, StringBuffer seite, String meldung) {
        return this.getUri(sender, addr, "ISO-8859-15", 1, seite, meldung);
    }

    public synchronized StringBuffer getUri(String sender, String addr, String kodierung, int maxVersuche, StringBuffer seite, String meldung) {
        int PAUSE = 1000;
        int aktTimeout = this.timeout;
        int aktVer = 0;
        do {
            ++aktVer;
            try {
                boolean letzterVersuch;
                if (aktVer > 1) {
                    this.wait(1000L);
                }
                if ((seite = this.getUri(sender, addr, seite, kodierung, aktTimeout, meldung, maxVersuche, letzterVersuch = aktVer >= maxVersuche)).length() > 0) {
                    if (Daten.debug && aktVer > 1) {
                        String text = sender + " [" + aktVer + "/" + maxVersuche + "] ~~~> " + addr;
                        Log.systemMeldung(text);
                    }
                    this.incSeitenZaehler(1, sender, 1);
                    return seite;
                }
                int wartezeit = aktVer > 1 ? aktTimeout + 1000 : aktTimeout;
                this.incSeitenZaehler(4, sender, wartezeit / 1000);
                this.incSeitenZaehler(3, sender, 1);
                if (!letzterVersuch) continue;
                this.incSeitenZaehler(2, sender, 1);
            }
            catch (Exception ex) {
                Log.fehlerMeldung(698963200, 1, GetUrl.class.getName() + ".getUri", ex, sender);
            }
        } while (!Daten.filmeLaden.getStop() && aktVer < maxVersuche);
        return seite;
    }

    public synchronized void getDummy(String sender) {
        this.incSeitenZaehler(1, sender, 1);
    }

    public void setTimeout(int ttimeout) {
        this.timeout = ttimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static long getSeitenZaehler(int art, String sender) {
        long ret = 0L;
        LinkedList<Seitenzaehler> liste = GetUrl.getListe(art);
        for (Seitenzaehler sz : liste) {
            if (!sz.senderName.equals(sender)) continue;
            ret = sz.seitenAnzahl;
        }
        if (art == 5) {
            ret = ret / 1024L / 1024L;
        }
        return ret;
    }

    public static synchronized long getSeitenZaehler(int art) {
        long ret = 0L;
        LinkedList<Seitenzaehler> liste = GetUrl.getListe(art);
        Iterator it = liste.iterator();
        while (it.hasNext()) {
            ret += ((Seitenzaehler)it.next()).seitenAnzahl;
        }
        if (art == 5) {
            ret = ret / 1024L / 1024L;
        }
        return ret;
    }

    public static synchronized void resetZaehler() {
        listeSeitenZaehler.clear();
        listeSeitenZaehlerFehler.clear();
        listeSeitenZaehlerFehlerVersuche.clear();
        listeSeitenZaehlerWartezeitFehlerVersuche.clear();
        listeSummeByte.clear();
    }

    private static LinkedList<Seitenzaehler> getListe(int art) {
        switch (art) {
            case 1: {
                return listeSeitenZaehler;
            }
            case 3: {
                return listeSeitenZaehlerFehlerVersuche;
            }
            case 2: {
                return listeSeitenZaehlerFehler;
            }
            case 4: {
                return listeSeitenZaehlerWartezeitFehlerVersuche;
            }
            case 5: {
                return listeSummeByte;
            }
        }
        return null;
    }

    private synchronized void incSeitenZaehler(int art, String sender, int inc) {
        boolean gefunden = false;
        LinkedList<Seitenzaehler> liste = GetUrl.getListe(art);
        for (Seitenzaehler sz : liste) {
            if (!sz.senderName.equals(sender)) continue;
            sz.seitenAnzahl += (long)inc;
            gefunden = true;
            break;
        }
        if (!gefunden) {
            liste.add(new Seitenzaehler(sender, inc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StringBuffer getUri(String sender, String addr, StringBuffer seite, String kodierung, int timeout, String meldung, int versuch, boolean lVersuch) {
        int timeo = timeout;
        boolean proxyB = false;
        char[] zeichen = new char[1];
        seite.setLength(0);
        int code = 0;
        InputStream in = null;
        InputStreamReader inReader = null;
        Object proxy = null;
        Object saddr = null;
        try {
            long w = this.wartenBasis * (long)this.faktorWarten;
            this.wait(w);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(976120379, 1, GetUrl.class.getName() + ".getUri", ex, sender);
        }
        try {
            URL url = new URL(addr);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", Daten.getUserAgent());
            if (timeout > 0) {
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
            }
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)conn;
                code = httpConnection.getResponseCode();
            } else {
                Log.fehlerMeldung(949697315, 1, GetUrl.class.getName() + ".getUri", "keine HTTPcon");
            }
            in = conn.getInputStream();
            inReader = new InputStreamReader(in, kodierung);
            while (!Daten.filmeLaden.getStop() && inReader.read(zeichen) != -1) {
                seite.append(zeichen);
                this.incSeitenZaehler(5, sender, 1);
            }
        }
        catch (IOException ex) {
            if (lVersuch) {
                String[] text = meldung.equals("") ? new String[]{sender + " - timout: " + timeo + " Versuche: " + versuch, addr} : new String[]{sender + " - timout: " + timeo + " Versuche: " + versuch, addr, meldung};
                Log.fehlerMeldung(502739817, 1, GetUrl.class.getName() + ".getUri", (Exception)ex, (proxyB ? "Porxy - " : "") + text);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(973969801, 1, GetUrl.class.getName() + ".getUri", ex, proxyB ? "Porxy - " : "");
        }
        finally {
            try {
                if (in != null) {
                    inReader.close();
                }
            }
            catch (IOException ex) {}
        }
        return seite;
    }

    private class Seitenzaehler {
        String senderName = "";
        long seitenAnzahl = 0L;

        public Seitenzaehler(String ssenderName) {
            this.senderName = ssenderName;
            this.seitenAnzahl = 1L;
        }

        public Seitenzaehler(String ssenderName, int sseitenAnzahl) {
            this.senderName = ssenderName;
            this.seitenAnzahl = sseitenAnzahl;
        }
    }
}

