/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import mediathek.controller.filmeLaden.importieren.DatenFilmlistenServer;
import mediathek.controller.filmeLaden.importieren.DatenUrlFilmliste;
import mediathek.controller.filmeLaden.importieren.FilmlistenSuchen;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.tool.Konstanten;
import mediathek.tool.Log;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class IoXmlSchreiben {
    private XMLOutputFactory outFactory;
    private XMLStreamWriter writer;
    private OutputStreamWriter out = null;
    ZipOutputStream zipOutputStream = null;
    BZip2CompressorOutputStream bZip2CompressorOutputStream = null;

    public synchronized void datenSchreiben(DDaten daten) {
        this.xmlDatenSchreiben(daten);
        daten.history.speichern();
    }

    public synchronized void exportPset(DatenPset[] pSet, String datei) {
        try {
            Log.systemMeldung("Pset exportieren");
            this.xmlSchreibenStart(datei);
            this.xmlSchreibenPset(pSet);
            this.xmlSchreibenEnde(datei);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(392846204, 0, "IoXmlSchreiben.exportPset", ex, "nach: " + datei);
        }
    }

    private void xmlDatenSchreiben(DDaten daten) {
        try {
            Log.systemMeldung("Daten Schreiben");
            this.xmlSchreibenStart(Daten.getBasisVerzeichnis(true) + "mediathek.xml");
            this.xmlSchreibenDaten("system", Konstanten.SYSTEM_COLUMN_NAMES, DDaten.system);
            this.xmlSchreibenProg(daten);
            this.xmlSchreibenDownloads(daten);
            this.xmlSchreibenAbo(daten);
            this.xmlSchreibenBlackList(daten);
            this.xmlSchreibenFilmUpdateServer(daten);
            this.xmlSchreibenEnde();
        }
        catch (Exception ex) {
            Log.fehlerMeldung(656328109, 0, "IoXml.xmlDatenSchreiben", ex);
        }
    }

    private void xmlSchreibenStart(String datei) throws Exception {
        File file = new File(datei);
        Log.systemMeldung("Start Schreiben nach: " + datei);
        this.outFactory = XMLOutputFactory.newInstance();
        if (datei.endsWith(".bz2")) {
            this.bZip2CompressorOutputStream = new BZip2CompressorOutputStream(new FileOutputStream(file), 2);
            this.out = new OutputStreamWriter((OutputStream)this.bZip2CompressorOutputStream, "UTF-8");
        } else if (datei.endsWith(".zip")) {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            ZipEntry entry = new ZipEntry("filme.xml");
            this.zipOutputStream.putNextEntry(entry);
            this.out = new OutputStreamWriter((OutputStream)this.zipOutputStream, "UTF-8");
        } else {
            this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        }
        this.writer = this.outFactory.createXMLStreamWriter(this.out);
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeCharacters("\n");
        this.writer.writeStartElement("Mediathek");
        this.writer.writeCharacters("\n");
    }

    private void xmlSchreibenProg(DDaten daten) {
        ListIterator iterator = daten.listePset.listIterator();
        while (iterator.hasNext()) {
            DatenPset datenPset = (DatenPset)iterator.next();
            this.xmlSchreibenDaten("Programmset", DatenPset.PROGRAMMSET_COLUMN_NAMES, datenPset.arr);
            ListIterator it = datenPset.getListeProg().listIterator();
            while (it.hasNext()) {
                this.xmlSchreibenDaten("Programm", DatenProg.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
            }
        }
    }

    private void xmlSchreibenPset(DatenPset[] datenPset) {
        for (int i = 0; i < datenPset.length; ++i) {
            this.xmlSchreibenDaten("Programmset", DatenPset.PROGRAMMSET_COLUMN_NAMES, datenPset[i].arr);
            ListIterator it = datenPset[i].getListeProg().listIterator();
            while (it.hasNext()) {
                this.xmlSchreibenDaten("Programm", DatenProg.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
            }
        }
    }

    private void xmlSchreibenDownloads(DDaten daten) {
        for (DatenDownload d : daten.listeDownloads) {
            if (d.istAbo()) continue;
            this.xmlSchreibenDaten("Downlad", DatenDownload.DOWNLOAD_COLUMN_NAMES, d.arr);
        }
    }

    private void xmlSchreibenAbo(DDaten daten) {
        ListIterator iterator = daten.listeAbo.listIterator();
        while (iterator.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)iterator.next();
            this.xmlSchreibenDaten("Abonnement", DatenAbo.ABO_COLUMN_NAMES, datenAbo.arr);
        }
    }

    private void xmlSchreibenBlackList(DDaten daten) {
        for (DatenBlacklist blacklist : daten.listeBlacklist) {
            this.xmlSchreibenDaten("Blacklist", DatenBlacklist.BLACKLIST_COLUMN_NAMES, blacklist.arr);
        }
    }

    private void xmlSchreibenFilmUpdateServer(DDaten daten) {
        for (DatenUrlFilmliste datenUrlFilmliste : DDaten.filmeLaden.getDownloadUrlsFilmlisten(false)) {
            this.xmlSchreibenDaten("film-update-server", FilmlistenSuchen.FILM_UPDATE_SERVER_COLUMN_NAMES, datenUrlFilmliste.arr);
        }
        for (DatenFilmlistenServer f : DDaten.filmeLaden.getListeFilmlistnServer()) {
            this.xmlSchreibenDaten("film-listen-server", DatenFilmlistenServer.FILM_LISTEN_SERVER_COLUMN_NAMES, f.arr);
        }
    }

    private void xmlSchreibenDaten(String xmlName, String[] xmlSpalten, String[] datenArray) {
        int xmlMax = datenArray.length;
        try {
            this.writer.writeStartElement(xmlName);
            for (int i = 0; i < xmlMax; ++i) {
                if (datenArray[i].equals("")) continue;
                this.writer.writeStartElement(xmlSpalten[i]);
                this.writer.writeCharacters(datenArray[i]);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            Log.fehlerMeldung(198325017, 0, "IoXmlSchreiben.xmlSchreibenDaten", ex);
        }
    }

    private void xmlSchreibenEnde() throws Exception {
        this.xmlSchreibenEnde("");
    }

    private void xmlSchreibenEnde(String datei) throws Exception {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
        if (datei.endsWith(".bz2")) {
            this.writer.close();
            this.bZip2CompressorOutputStream.close();
        } else if (datei.endsWith(".zip")) {
            this.zipOutputStream.closeEntry();
            this.writer.close();
            this.zipOutputStream.close();
        } else {
            this.writer.close();
        }
        Log.systemMeldung("geschrieben!");
    }
}

