/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.daten.Daten;
import mediathek.tool.Log;
import mediathek.tool.TModel;

public class ListePsetVorlagen
extends LinkedList<String[]> {
    public static final String BS_WIN_32 = "Windows-32Bit";
    public static final String BS_WIN_64 = "Windows-64Bit";
    public static final String BS_LINUX = "Linux";
    public static final String BS_MAC = "Mac";
    public static final String[] BS = new String[]{"", "Windows-32Bit", "Windows-64Bit", "Linux", "Mac"};
    public static final String PGR = "Vorlage";
    public static final int PGR_MAX_ELEM = 4;
    public static final String PGR_NAME = "Name";
    public static final int PGR_NAME_NR = 0;
    public static final String PGR_BESCHREIBUNG = "Beschreibung";
    public static final int PGR_BESCHREIBUNG_NR = 1;
    public static final String PGR_BS = "Bs";
    public static final int PGR_BS_NR = 2;
    public static final String PGR_URL = "URL";
    public static final int PGR_URL_NR = 3;
    public static final String[] PGR_COLUMN_NAMES = new String[]{"Name", "Beschreibung", "Bs", "URL"};
    private final int timeout = 10000;
    private final String url = "http://zdfmediathk.sourceforge.net/programmgruppen.xml";

    public TModel getTModel(String bs) {
        LinkedList tmp = new LinkedList();
        if (this.size() > 0) {
            Object[][] object;
            int i;
            if (!bs.equals("")) {
                for (i = 0; i < this.size(); ++i) {
                    if (!((String[])this.get(i))[2].contains(bs)) continue;
                    tmp.add(this.get(i));
                }
                object = new String[tmp.size()][4];
                for (i = 0; i < tmp.size(); ++i) {
                    object[i] = (String[])tmp.get(i);
                }
            } else {
                object = new String[this.size()][4];
                for (i = 0; i < this.size(); ++i) {
                    object[i] = (String[])this.get(i);
                }
            }
            TModel model = new TModel(object, PGR_COLUMN_NAMES);
            return model;
        }
        return new TModel(new Object[0][], PGR_COLUMN_NAMES);
    }

    public boolean getListe() {
        try {
            this.clear();
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            URLConnection conn = new URL("http://zdfmediathk.sourceforge.net/programmgruppen.xml").openConnection();
            conn.setRequestProperty("User-Agent", Daten.getUserAgent());
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(10000);
            InputStreamReader inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
            XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1 || !parser.getLocalName().equals(PGR)) continue;
                String[] p = new String[4];
                this.get(parser, event, PGR, PGR_COLUMN_NAMES, p);
                if (p[3].equals("")) continue;
                this.add(p);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(398001963, 0, "VorlageProgrammgruppen.getListe", ex);
            return false;
        }
        return true;
    }

    private boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        int i;
        boolean ret = true;
        int maxElem = strRet.length;
        for (i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            Log.fehlerMeldung(467256394, 0, "VorlageProgrammgruppen.get", ex);
        }
        return ret;
    }
}

