/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.gui.dialog.DialogHinweisUpdate;
import mediathek.tool.DatumZeit;
import mediathek.tool.Log;

public class ProgrammUpdateSuchen {
    private final String PROGRAM_VERSION = "Program_Version";
    private final String PROGRAM_RELEASE_INFO = "Program_Release_Info";
    private final String DOWNLOAD_PROGRAM = "Download_Programm";
    private final String INFO = "Info";
    private final String INFO_NO = "number";
    private LinkedList<String[]> listInfos = new LinkedList();

    public boolean checkVersion(DDaten ddaten, boolean anzeigen, boolean hinweis, boolean hinweiseAlleAnzeigen) {
        boolean neueVersion = false;
        try {
            String[] ret = this.suchen();
            if (hinweis) {
                this.hinweiseAnzeigen(hinweiseAlleAnzeigen);
            }
            String version = ret[0];
            String release = ret[1];
            String downloadUrlProgramm = ret[2];
            if (!version.equals("")) {
                Daten.system[28] = DatumZeit.getHeute_yyyyMMdd();
                if (this.checkObNeueVersion(version, "3.1.0")) {
                    neueVersion = true;
                    new DialogHinweisUpdate(null, true, "Eine neue Version liegt vor", "   ==================================================\n   Neue Version:\n   " + version + "\n\n" + "   ==================================================\n" + "   \u00c4nderungen:\n" + "   " + release + "\n\n" + "   ==================================================\n" + "   URL:\n" + "   " + downloadUrlProgramm + "\n\n").setVisible(true);
                } else {
                    DialogHinweisUpdate dialog = new DialogHinweisUpdate(null, true, "Update suchen", "Alles aktuell!");
                    if (anzeigen) {
                        dialog.setVisible(true);
                    }
                }
            } else {
                new DialogHinweisUpdate(null, true, "Fehler bei der Versionspr\u00fcfung!", "Es ist ein Fehler aufgetreten!\n\n").setVisible(true);
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(159002583, 0, "ProgrammUpdateSuchen.checkVersion", ex);
        }
        return neueVersion;
    }

    private void hinweiseAnzeigen(boolean alleAnzeigen) {
        if (this.listInfos.size() > 0) {
            try {
                StringBuilder text = new StringBuilder();
                int angezeigt = 0;
                if (DDaten.system[41].equals("")) {
                    DDaten.system[41] = Integer.toString(-1);
                } else {
                    angezeigt = Integer.parseInt(DDaten.system[41]);
                }
                for (int i = 0; i < this.listInfos.size(); ++i) {
                    String[] h = this.listInfos.get(i);
                    if (!alleAnzeigen && angezeigt >= Integer.parseInt(h[0])) continue;
                    text.append(h[1]);
                    text.append("\n");
                    text.append("\n");
                }
                if (text.length() > 0) {
                    new DialogHinweisUpdate(null, true, "Infos", text.toString()).setVisible(true);
                    DDaten.system[41] = Integer.toString(this.listInfos.size());
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(693298731, 0, "ProgrammUpdateSuchen.checkVersion", ex);
            }
        } else if (alleAnzeigen) {
            new DialogHinweisUpdate(null, true, "Infos", "keine vorhanden").setVisible(true);
        }
    }

    private boolean checkObNeueVersion(String infoVersion, String ichVersion) {
        try {
            int info = Integer.parseInt(infoVersion.substring(0, 1) + infoVersion.substring(2, 3) + infoVersion.substring(4, 5));
            int ich = Integer.parseInt(ichVersion.substring(0, 1) + ichVersion.substring(2, 3) + ichVersion.substring(4, 5));
            if (info > ich) {
                return true;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(683021193, 0, "ProgrammUpdateSuchen.checkObNeueVersion", ex);
        }
        return false;
    }

    private String[] suchen() throws MalformedURLException, IOException, XMLStreamException {
        String[] ret = new String[]{"", "", ""};
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        int timeout = 10000;
        URLConnection conn = new URL("http://zdfmediathk.sourceforge.net/version.xml").openConnection();
        conn.setRequestProperty("User-Agent", Daten.getUserAgent());
        conn.setReadTimeout(timeout);
        conn.setConnectTimeout(timeout);
        InputStreamReader inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
        XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 1) continue;
            if (parser.getLocalName().equals("Program_Version")) {
                ret[0] = parser.getElementText();
                continue;
            }
            if (parser.getLocalName().equals("Program_Release_Info")) {
                ret[1] = parser.getElementText();
                continue;
            }
            if (parser.getLocalName().equals("Download_Programm")) {
                ret[2] = parser.getElementText();
                continue;
            }
            if (!parser.getLocalName().equals("Info")) continue;
            int count = parser.getAttributeCount();
            String nummer = "";
            for (int i = 0; i < count; ++i) {
                if (!parser.getAttributeName(i).toString().equals("number")) continue;
                nummer = parser.getAttributeValue(i);
            }
            String info = parser.getElementText();
            if (nummer.equals("") || info.equals("")) continue;
            this.listInfos.add(new String[]{nummer, info});
        }
        return ret;
    }
}

