/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.SimpleDateFormat;
import java.util.Date;
import mediathek.tool.Datum;
import mediathek.tool.DatumZeit;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.Log;

public class DatenFilm
implements Comparable<DatenFilm> {
    public static final String FELD_INFO = "Feldinfo";
    public static final String FILME = "Filme";
    public static final String FILME_ = "X";
    public static final int FILME_MAX_ELEM = 11;
    public static final String FILM_NR = "Nr";
    public static final int FILM_NR_NR = 0;
    public static final String FILM_SENDER = "Sender";
    public static final int FILM_SENDER_NR = 1;
    public static final String FILM_THEMA = "Thema";
    public static final int FILM_THEMA_NR = 2;
    public static final String FILM_TITEL = "Titel";
    public static final int FILM_TITEL_NR = 3;
    public static final String FILM_DATUM = "Datum";
    public static final int FILM_DATUM_NR = 4;
    public static final String FILM_ZEIT = "Zeit";
    public static final int FILM_ZEIT_NR = 5;
    public static final String FILM_URL = "Url";
    public static final int FILM_URL_NR = 6;
    public static final String FILM_URL_RTMP = "UrlRTMP";
    public static final int FILM_URL_RTMP_NR = 7;
    public static final String FILM_URL_AUTH = "UrlAuth";
    public static final int FILM_URL_AUTH_NR = 8;
    public static final String FILM_URL_THEMA = "UrlThema";
    public static final int FILM_URL_THEMA_NR = 9;
    public static final String FILM_ABO_NAME = "Abo-Name";
    public static final int FILM_ABO_NAME_NR = 10;
    public static final String[] FILME_COLUMN_NAMES = new String[]{"Nr", "Sender", "Thema", "Titel", "Datum", "Zeit", "Url", "UrlRTMP", "UrlAuth", "UrlThema", "Abo-Name"};
    public static final String[] FILME_COLUMN_NAMES_ = new String[]{"a", "b", "c", "d", "e", "f", "g", "i", "j", "k", "l"};
    public String[] arr;
    public Datum datumFilm = new Datum(0L);

    public DatenFilm() {
        this.makeArr();
    }

    public DatenFilm(String ssender, String tthema, String urlThema, String ttitel, String uurl, String datum, String zeit) {
        this.makeArr();
        this.arr[1] = ssender;
        this.arr[2] = tthema;
        this.arr[3] = ttitel;
        this.arr[6] = uurl;
        this.arr[4] = DatenFilm.checkDatum(datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[5] = DatenFilm.checkZeit(this.arr[4], zeit, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[9] = urlThema;
        this.setDatum();
    }

    public DatenFilm(String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlRtmp, String datum, String zeit) {
        this.makeArr();
        this.arr[1] = ssender;
        this.arr[2] = tthema;
        this.arr[3] = ttitel;
        this.arr[6] = uurl;
        this.arr[7] = uurlRtmp;
        this.arr[9] = urlThema;
        this.arr[4] = DatenFilm.checkDatum(datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[5] = DatenFilm.checkZeit(this.arr[4], zeit, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.setDatum();
    }

    public String getIndex() {
        return this.arr[1] + this.arr[2] + this.arr[6];
    }

    public DatenFilm getClean() {
        this.arr[0] = "";
        this.arr[10] = "";
        return this;
    }

    public DatenFilm getCopy() {
        DatenFilm ret = new DatenFilm();
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        ret.datumFilm = this.datumFilm;
        return ret;
    }

    @Override
    public int compareTo(DatenFilm arg0) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        int ret = sorter.compare(this.arr[1], arg0.arr[1]);
        if (ret == 0) {
            ret = sorter.compare(this.arr[2], arg0.arr[2]);
        }
        return ret;
    }

    public String getUrlOrg() {
        return this.arr[6];
    }

    private void makeArr() {
        this.arr = new String[11];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
    }

    public final void setDatum() {
        this.datumFilm = DatumZeit.getDatumForObject(this);
    }

    private static String checkDatum(String datum, String fehlermeldung) {
        long MAX = 8640000000L;
        String ret = datum.trim();
        if (ret.equals("")) {
            return "";
        }
        if (!ret.contains(".")) {
            Log.debugMeldung("DatenFilm.CheckDatum-1 [" + datum + "] " + fehlermeldung);
            return "";
        }
        if (ret.length() != 10) {
            Log.debugMeldung("DatenFilm.CheckDatum-2 [" + datum + "] " + fehlermeldung);
            return "";
        }
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy");
            Date filmDate = sdfIn.parse(ret);
            if (filmDate.getTime() < 0L) {
                Log.debugMeldung("DatenFilm.CheckDatum-3 - Unsinniger Wert: [" + datum + "] " + fehlermeldung);
                ret = "";
            }
            if (new Date().getTime() + 8640000000L < filmDate.getTime()) {
                Log.debugMeldung("DatenFilm.CheckDatum-4 - Unsinniger Wert: [" + datum + "] " + fehlermeldung);
                ret = "";
            }
        }
        catch (Exception ex) {
            ret = "";
            Log.fehlerMeldung(794630593, 0, "DatenFilm.checkDatum-5", ex);
            Log.fehlerMeldung(946301596, 0, "DatenFilm.CheckDatum-6 [", datum + "] " + fehlermeldung);
        }
        if (ret.equals("")) {
            // empty if block
        }
        return ret;
    }

    private static String checkZeit(String datum, String zeit, String text) {
        String ret = zeit.trim();
        if (datum.equals("")) {
            ret = "";
        } else if (!ret.equals("")) {
            if (!ret.contains(":")) {
                ret = "";
            }
            if (ret.length() != 8) {
                ret = "";
            }
            if (ret.equals("")) {
                Log.debugMeldung("DatenFilm.CheckZeit [" + zeit + "] " + text);
            }
        }
        return ret;
    }
}

