/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.TModel;

public class ListePset
extends LinkedList<DatenPset> {
    public static final String MUSTER_PFAD_ZIEL = "ZIELPFAD";
    public static final String MUSTER_PFAD_MPLAYER = "PFAD_MPLAYER";
    public static final String MUSTER_PFAD_VLC = "PFAD_VLC";
    public static final String MUSTER_PFAD_FLV = "PFAD_FLVSTREAMER";
    public static final String MUSTER_PFAD_SCRIPT = "PFAD_SCRIPT";

    public boolean nameExists(String name) {
        boolean ret = false;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenPset)it.next()).arr[0].equals(name)) continue;
            ret = true;
        }
        return ret;
    }

    public DatenPset getPsetAbspielen() {
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[8])) continue;
            return datenPset;
        }
        return null;
    }

    public DatenPset getPsetAbo(String name) {
        DatenPset ret = null;
        if (this.size() == 0) {
            ret = null;
        } else if (this.size() == 1) {
            ret = (DatenPset)this.getFirst();
        } else {
            ListIterator it = this.listIterator(0);
            while (it.hasNext()) {
                DatenPset gruppe = (DatenPset)it.next();
                if (!gruppe.istAbo() || !gruppe.arr[0].equals(name)) continue;
                ret = gruppe;
            }
            if (ret == null && (ret = (DatenPset)this.getListeAbo().getFirst()) == null) {
                ret = (DatenPset)this.getFirst();
            }
        }
        return ret;
    }

    public ListePset getListeSpeichern() {
        ListePset liste = new ListePset();
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[9])) continue;
            liste.add(datenPset);
        }
        return liste;
    }

    public ListePset getListeButton() {
        ListePset liste = new ListePset();
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[10])) continue;
            liste.add(datenPset);
        }
        return liste;
    }

    public ListePset getListeAbo() {
        ListePset liste = new ListePset();
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[11])) continue;
            liste.add(datenPset);
        }
        return liste;
    }

    public String[] getObjectDataCombo() {
        int i = 0;
        ListIterator it = this.listIterator(0);
        String[] object = new String[this.size()];
        while (it.hasNext()) {
            object[i] = ((DatenPset)it.next()).arr[0];
            ++i;
        }
        return object;
    }

    public int auf(int idx, boolean auf) {
        DatenPset prog = (DatenPset)this.remove(idx);
        int neu = idx;
        if (auf) {
            if (neu > 0) {
                --neu;
            }
        } else if (neu < this.size()) {
            ++neu;
        }
        this.add(neu, prog);
        ListenerMediathekView.notify(3, ListePset.class.getSimpleName());
        return neu;
    }

    public boolean addPset(DatenPset gruppe) {
        boolean abspielen = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!Boolean.parseBoolean(((DatenPset)it.next()).arr[8])) continue;
            abspielen = true;
            break;
        }
        if (abspielen) {
            gruppe.arr[8] = Boolean.FALSE.toString();
        }
        boolean ret = this.add(gruppe);
        return ret;
    }

    public boolean addPset(ListePset liste) {
        boolean ret = true;
        Iterator it = liste.iterator();
        while (it.hasNext()) {
            if (this.addPset((DatenPset)it.next())) continue;
            ret = false;
        }
        return ret;
    }

    public boolean addVorlage(ListePset liste) {
        boolean ret = true;
        for (DatenPset pSet : liste) {
            if (this.addVorlage(pSet)) continue;
            ret = false;
        }
        return ret;
    }

    private boolean addVorlage(DatenPset pSet) {
        DatenProg prog;
        int p;
        pSet.arr[4] = pSet.arr[4].replace(MUSTER_PFAD_ZIEL, GuiFunktionen.getStandardDownloadPath());
        String mplayer = "";
        String vlc = "";
        String flvstreamer = "";
        String skript = GuiFunktionenProgramme.getPfadScript();
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.arr[2].contains(MUSTER_PFAD_MPLAYER) && !prog.arr[3].contains(MUSTER_PFAD_MPLAYER)) continue;
            mplayer = GuiFunktionenProgramme.getPfadMplayer();
            break;
        }
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.arr[2].contains(MUSTER_PFAD_VLC) && !prog.arr[3].contains(MUSTER_PFAD_VLC)) continue;
            vlc = GuiFunktionenProgramme.getPfadVlc();
            break;
        }
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.arr[2].contains(MUSTER_PFAD_FLV) && !prog.arr[3].contains(MUSTER_PFAD_FLV)) continue;
            flvstreamer = GuiFunktionenProgramme.getPfadFlv();
            break;
        }
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_MPLAYER, Matcher.quoteReplacement(mplayer));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_MPLAYER, Matcher.quoteReplacement(mplayer));
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_VLC, Matcher.quoteReplacement(vlc));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_VLC, Matcher.quoteReplacement(vlc));
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_FLV, Matcher.quoteReplacement(flvstreamer));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_FLV, Matcher.quoteReplacement(flvstreamer));
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_SCRIPT, Matcher.quoteReplacement(skript));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_SCRIPT, Matcher.quoteReplacement(skript));
        }
        return this.addPset(pSet);
    }

    public TModel getModel() {
        TModel model;
        int i = 0;
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            Object[][] object = new Object[this.size()][15];
            while (iterator.hasNext()) {
                DatenPset daten = (DatenPset)iterator.next();
                object[i][0] = daten.arr[0];
                ++i;
            }
            model = new TModel(object, DatenPset.PROGRAMMSET_COLUMN_NAMES_);
        } else {
            model = new TModel(new Object[0][15], DatenPset.PROGRAMMSET_COLUMN_NAMES_);
        }
        return model;
    }
}

