/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mediathek.controller.filmeLaden.ListenerFilmeLaden;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.controller.io.starter.Start;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogDatenFilm;
import mediathek.gui.dialog.DialogEditDownload;
import mediathek.tool.BeobMpanel;
import mediathek.tool.CellRendererDownloads;
import mediathek.tool.Datum;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiKonstanten;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.JTableMed;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.TModelDownload;

public class GuiDownloads
extends PanelVorlage {
    private DialogDatenFilm dialogDatenFilm = null;
    private ButtonGroup buttonGroup1;
    private JCheckBox jCheckBoxFilter;
    private JPanel jPanelFilter;
    private JPanel jPanelFilterInnen;
    private JRadioButton jRadioButtonAbos;
    private JRadioButton jRadioButtonAlles;
    private JRadioButton jRadioButtonDownloads;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public GuiDownloads(DDaten d) {
        super(d);
        this.initComponents();
        this.tabelle = new JTableMed(1);
        this.jScrollPane1.setViewportView(this.tabelle);
        this.dialogDatenFilm = new DialogDatenFilm(null, false, this.ddaten);
        this.init();
        this.downloadsAktualisieren();
        this.tabelle.initTabelle();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void isShown() {
        super.isShown();
        this.ddaten.mediathekGui.setToolbar(2);
        this.ddaten.infoPanel.setIdx(2);
    }

    public void aktualisieren() {
        this.downloadsAktualisieren();
    }

    public void starten(boolean alle) {
        this.filmStartenWiederholenStoppen(alle, true);
    }

    public void stoppen(boolean alle) {
        this.filmStartenWiederholenStoppen(alle, false);
    }

    public void vorziehen() {
        this.downloadVorziehen();
    }

    public void zurueckstellen() {
        this.downloadLoeschen(false);
    }

    public void loeschen() {
        this.downloadLoeschen(true);
    }

    public void aufraeumen() {
        this.downloadsAufraeumen();
    }

    public void aendern() {
        this.downloadAendern();
    }

    private void init() {
        this.jRadioButtonAbos.setForeground(GuiKonstanten.ABO_FOREGROUND);
        this.jRadioButtonDownloads.setForeground(GuiKonstanten.DOWNLOAD_FOREGROUND);
        this.tabelle.setDefaultRenderer(Object.class, new CellRendererDownloads(this.ddaten));
        this.tabelle.setDefaultRenderer(Datum.class, new CellRendererDownloads(this.ddaten));
        this.tabelle.setModel(new TModelDownload(new Object[0][], DatenDownload.DOWNLOAD_COLUMN_NAMES));
        this.tabelle.addMouseListener(new BeobMausTabelle());
        this.tabelle.getSelectionModel().addListSelectionListener(new BeobachterTableSelect1());
        ActionMap am = this.tabelle.getActionMap();
        InputMap im = this.tabelle.getInputMap();
        am.put("aendern", new BeobAbstractActionAendern());
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "aendern");
        am.put("del", new BeobAbstractActionLoeschen());
        KeyStroke del = KeyStroke.getKeyStroke(127, 0);
        im.put(del, "del");
        this.jRadioButtonAlles.addActionListener(new BeobAnzeige());
        this.jRadioButtonAbos.addActionListener(new BeobAnzeige());
        this.jRadioButtonDownloads.addActionListener(new BeobAnzeige());
        this.jCheckBoxFilter.addActionListener(new BeobMpanel(this.jCheckBoxFilter, this.jPanelFilter, "Filter"));
        ListenerMediathekView.addListener(new ListenerMediathekView(9, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                GuiDownloads.this.tabelleLaden();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(13, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                GuiDownloads.this.tabelle.fireTableDataChanged(true);
                GuiDownloads.this.setInfo();
            }
        });
        DDaten.filmeLaden.addAdListener(new ListenerFilmeLaden(){

            @Override
            public void fertig_(ListenerFilmeLadenEvent event) {
                if (Boolean.parseBoolean(Daten.system[39])) {
                    GuiDownloads.this.downloadsAktualisieren();
                }
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(10, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                if (Boolean.parseBoolean(Daten.system[39])) {
                    GuiDownloads.this.downloadsAktualisieren();
                }
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(14, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                GuiDownloads.this.tabelle.fireTableDataChanged(true);
                GuiDownloads.this.setInfo();
            }
        });
    }

    private synchronized void tabelleLaden() {
        boolean download;
        boolean abo;
        this.tabelle.getSpalten();
        if (this.jRadioButtonAlles.isSelected()) {
            abo = true;
            download = true;
        } else if (this.jRadioButtonAbos.isSelected()) {
            abo = true;
            download = false;
        } else {
            abo = false;
            download = true;
        }
        this.ddaten.listeDownloads.getModel((TModelDownload)this.tabelle.getModel(), abo, download);
        this.tabelle.setSpalten();
        this.setInfo();
    }

    private synchronized void downloadsAktualisieren() {
        this.downloadsAufraeumen();
        this.ddaten.listeDownloads.zurueckgestellteWiederAktivieren();
        this.ddaten.listeDownloads.abosLoschenWennNochNichtGestartet();
        this.ddaten.listeDownloads.abosSuchen();
        this.tabelleLaden();
    }

    private synchronized void downloadsAufraeumen() {
        this.ddaten.listeDownloads.listePutzen();
    }

    private synchronized void downloadAendern() {
        int row = this.tabelle.getSelectedRow();
        if (row != -1) {
            int delRow = this.tabelle.convertRowIndexToModel(row);
            String url = this.tabelle.getModel().getValueAt(delRow, 9).toString();
            DatenDownload download = this.ddaten.listeDownloads.getDownloadByUrl(url);
            DatenDownload d = download.getCopy();
            DialogEditDownload dialog = new DialogEditDownload(null, true, d);
            dialog.setVisible(true);
            if (dialog.ok) {
                download.aufMichKopieren(d);
                this.tabelle.getSelected();
                this.tabelleLaden();
                this.tabelle.setSelected();
            }
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void downloadVorziehen() {
        int row = this.tabelle.getSelectedRow();
        if (row != -1) {
            int delRow = this.tabelle.convertRowIndexToModel(row);
            String url = this.tabelle.getModel().getValueAt(delRow, 9).toString();
            this.ddaten.listeDownloads.downloadVorziehen(url);
            this.tabelleLaden();
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void downloadLoeschen(boolean dauerhaft) {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            int i;
            String[] urls = new String[rows.length];
            for (i = 0; i < rows.length; ++i) {
                urls[i] = this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(rows[i]), 9).toString();
            }
            for (i = 0; i < urls.length; ++i) {
                DatenDownload download = this.ddaten.listeDownloads.getDownloadByUrl(urls[i]);
                if (dauerhaft) {
                    if (download.istAbo()) {
                        this.ddaten.erledigteAbos.zeileSchreiben(download.arr[4], download.arr[5], urls[i]);
                    }
                    this.ddaten.listeDownloads.delDownloadByUrl(urls[i]);
                } else {
                    download.zurueckstellen();
                }
                this.ddaten.starterClass.filmLoeschen(urls[i]);
            }
            this.tabelleLaden();
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void filmStartenWiederholenStoppen(boolean alle, boolean starten) {
        String url;
        int i;
        String[] urls;
        if (alle) {
            urls = new String[this.tabelle.getRowCount()];
            for (i = 0; i < this.tabelle.getRowCount(); ++i) {
                urls[i] = this.tabelle.getModel().getValueAt(i, 9).toString();
            }
        } else {
            int[] rows = this.tabelle.getSelectedRows();
            urls = new String[rows.length];
            if (rows.length >= 0) {
                for (int i2 = 0; i2 < rows.length; ++i2) {
                    int row = this.tabelle.convertRowIndexToModel(rows[i2]);
                    urls[i2] = url = this.tabelle.getModel().getValueAt(row, 9).toString();
                }
            } else {
                new HinweisKeineAuswahl().zeigen();
            }
        }
        for (i = 0; i < urls.length; ++i) {
            url = urls[i];
            Start s = this.ddaten.starterClass.getStart(url);
            DatenDownload download = this.ddaten.listeDownloads.getDownloadByUrl(url);
            if (starten) {
                if (s != null && s.status > 2) {
                    int a = JOptionPane.showConfirmDialog(null, "Film nochmal starten?  ==> " + s.datenDownload.arr[5], "Fertiger Download", 0);
                    if (a != 0) continue;
                    this.ddaten.starterClass.filmLoeschen(url);
                    if (s.datenDownload.istAbo()) {
                        this.ddaten.erledigteAbos.urlAusLogfileLoeschen(url);
                    }
                }
                download.starten(this.ddaten);
                continue;
            }
            if (s == null) continue;
            if (s.status <= 2) {
                this.ddaten.starterClass.filmLoeschen(url);
                if (s.datenDownload.istAbo()) {
                    this.ddaten.erledigteAbos.urlAusLogfileLoeschen(url);
                }
            }
            download.startMelden(-1);
        }
    }

    private void stopWartende() {
        int i;
        ArrayList<String> urls = new ArrayList<String>();
        for (i = 0; i < this.tabelle.getRowCount(); ++i) {
            int delRow = this.tabelle.convertRowIndexToModel(i);
            String url = this.tabelle.getModel().getValueAt(delRow, 9).toString();
            Start s = this.ddaten.starterClass.getStart(url);
            if (s == null || s.status >= 2) continue;
            urls.add(url);
        }
        for (i = 0; i < urls.size(); ++i) {
            this.ddaten.starterClass.filmLoeschen((String)urls.get(i));
        }
    }

    private void setInfo() {
        int laufen = this.ddaten.starterClass.getDownloadsLaufen();
        int warten = this.ddaten.starterClass.getDownloadsWarten();
        int gesamt = this.tabelle.getModel().getRowCount();
        String textLinks = gesamt == 1 ? "1 Download," : gesamt + " Downloads,";
        textLinks = textLinks + " (";
        textLinks = laufen == 1 ? textLinks + "1 l\u00e4uft," : textLinks + laufen + " laufen,";
        textLinks = warten == 1 ? textLinks + " 1 wartet" : textLinks + " " + warten + " warten";
        textLinks = textLinks + ")";
        this.ddaten.infoPanel.setTextLinks(2, textLinks);
    }

    private void dialogDatenFilmSetzen() {
        DatenFilm aktFilm = new DatenFilm();
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = this.tabelle.convertRowIndexToModel(selectedTableRow);
            DatenFilm film = Daten.listeFilme.getFilmByUrl(this.tabelle.getModel().getValueAt(selectedModelRow, 9).toString());
            if (film != null) {
                aktFilm = film;
            }
        }
        this.dialogDatenFilm.setAktFilm(aktFilm);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanelFilter = new JPanel();
        this.jCheckBoxFilter = new JCheckBox();
        this.jPanelFilterInnen = new JPanel();
        this.jRadioButtonAlles = new JRadioButton();
        this.jRadioButtonDownloads = new JRadioButton();
        this.jRadioButtonAbos = new JRadioButton();
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanelFilter.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jCheckBoxFilter.setBackground(new Color(217, 217, 217));
        this.jCheckBoxFilter.setFont(new Font("Dialog", 1, 10));
        this.jCheckBoxFilter.setText("Filter");
        this.buttonGroup1.add(this.jRadioButtonAlles);
        this.jRadioButtonAlles.setSelected(true);
        this.jRadioButtonAlles.setText(" alle");
        this.jRadioButtonAlles.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jRadioButtonAlles.setBorderPainted(true);
        this.buttonGroup1.add(this.jRadioButtonDownloads);
        this.jRadioButtonDownloads.setText(" Downloads ");
        this.jRadioButtonDownloads.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jRadioButtonDownloads.setBorderPainted(true);
        this.buttonGroup1.add(this.jRadioButtonAbos);
        this.jRadioButtonAbos.setText(" Abos ");
        this.jRadioButtonAbos.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jRadioButtonAbos.setBorderPainted(true);
        GroupLayout jPanelFilterInnenLayout = new GroupLayout(this.jPanelFilterInnen);
        this.jPanelFilterInnen.setLayout(jPanelFilterInnenLayout);
        jPanelFilterInnenLayout.setHorizontalGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterInnenLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAlles).addGap(18, 18, 18).addComponent(this.jRadioButtonDownloads).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonAbos).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelFilterInnenLayout.linkSize(0, this.jRadioButtonAbos, this.jRadioButtonAlles, this.jRadioButtonDownloads);
        jPanelFilterInnenLayout.setVerticalGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterInnenLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jRadioButtonAlles).addComponent(this.jRadioButtonDownloads).addComponent(this.jRadioButtonAbos)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelFilterLayout = new GroupLayout(this.jPanelFilter);
        this.jPanelFilter.setLayout(jPanelFilterLayout);
        jPanelFilterLayout.setHorizontalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelFilterInnen, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxFilter, -1, -1, Short.MAX_VALUE));
        jPanelFilterLayout.setVerticalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterLayout.createSequentialGroup().addComponent(this.jCheckBoxFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFilterInnen, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 670, Short.MAX_VALUE).addComponent(this.jPanelFilter, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelFilter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 357, Short.MAX_VALUE).addContainerGap()));
    }

    private class BeobAnzeige
    implements ActionListener {
        private BeobAnzeige() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiDownloads.this.tabelleLaden();
        }
    }

    private class BeobAbstractActionLoeschen
    extends AbstractAction {
        private BeobAbstractActionLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiDownloads.this.downloadLoeschen(true);
        }
    }

    private class BeobAbstractActionAendern
    extends AbstractAction {
        private BeobAbstractActionAendern() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiDownloads.this.downloadAendern();
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private Point p;

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() > 1) {
                    GuiDownloads.this.downloadAendern();
                }
            } else if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiDownloads.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiDownloads.this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            int row = GuiDownloads.this.tabelle.getSelectedRow();
            boolean wartenOderLaufen = false;
            if (row >= 0) {
                int delRow = GuiDownloads.this.tabelle.convertRowIndexToModel(row);
                Start s = GuiDownloads.this.ddaten.starterClass.getStart(GuiDownloads.this.tabelle.getModel().getValueAt(delRow, 9).toString());
                if (s != null && s.status <= 2) {
                    wartenOderLaufen = true;
                }
            }
            JMenuItem itemStarten = new JMenuItem("Download starten");
            itemStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_play_16.png")));
            itemStarten.setEnabled(!wartenOderLaufen);
            jPopupMenu.add(itemStarten);
            itemStarten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(false, true);
                }
            });
            JMenuItem itemStoppen = new JMenuItem("Download stoppen");
            itemStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_stop_16.png")));
            itemStoppen.setEnabled(wartenOderLaufen);
            jPopupMenu.add(itemStoppen);
            itemStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(false, false);
                }
            });
            jPopupMenu.addSeparator();
            JMenuItem itemVorziehen = new JMenuItem("Download vorziehen");
            itemVorziehen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/up_blue_16.png")));
            jPopupMenu.add(itemVorziehen);
            itemVorziehen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadVorziehen();
                }
            });
            JMenuItem itemLoeschen = new JMenuItem("Download zur\u00fcckstellen");
            itemLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/undo_16.png")));
            jPopupMenu.add(itemLoeschen);
            itemLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadLoeschen(false);
                }
            });
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download dauerhaft l\u00f6schen");
            itemDauerhaftLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_16.png")));
            jPopupMenu.add(itemDauerhaftLoeschen);
            itemDauerhaftLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadLoeschen(true);
                }
            });
            JMenuItem itemAendern = new JMenuItem("Download \u00c4ndern");
            itemAendern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/configure_16.png")));
            jPopupMenu.add(itemAendern);
            itemAendern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadAendern();
                }
            });
            jPopupMenu.addSeparator();
            JMenuItem itemAlleStarten = new JMenuItem("alle Downloads starten");
            itemAlleStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/next_16.png")));
            jPopupMenu.add(itemAlleStarten);
            itemAlleStarten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(true, true);
                }
            });
            JMenuItem itemAlleStoppen = new JMenuItem("alle Downloads stoppen");
            itemAlleStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_stop_16.png")));
            jPopupMenu.add(itemAlleStoppen);
            itemAlleStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.filmStartenWiederholenStoppen(true, false);
                }
            });
            JMenuItem itemWartendeStoppen = new JMenuItem("wartende Downloads stoppen");
            itemWartendeStoppen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_stop_16.png")));
            jPopupMenu.add(itemWartendeStoppen);
            itemWartendeStoppen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.stopWartende();
                }
            });
            JMenuItem itemAktualisieren = new JMenuItem("Liste der Downloads aktualisieren");
            itemAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh_16.png")));
            jPopupMenu.add(itemAktualisieren);
            itemAktualisieren.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadsAktualisieren();
                }
            });
            JMenuItem itemAufraeumen = new JMenuItem("Liste Aufr\u00e4umen");
            itemAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-clear_16.png")));
            jPopupMenu.add(itemAufraeumen);
            itemAufraeumen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GuiDownloads.this.downloadsAufraeumen();
                }
            });
            jPopupMenu.addSeparator();
            JMenuItem itemUrl = new JMenuItem("URL kopieren");
            itemUrl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int nr = GuiDownloads.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        GuiFunktionen.copyToClipboard(GuiDownloads.this.tabelle.getModel().getValueAt(GuiDownloads.this.tabelle.convertRowIndexToModel(nr), 9).toString());
                    }
                }
            });
            jPopupMenu.add(itemUrl);
            JMenuItem itemPlayer = new JMenuItem("Film abspielen");
            itemPlayer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int nr = GuiDownloads.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        DatenPset gruppe = GuiDownloads.this.ddaten.listePset.getPsetAbspielen();
                        if (gruppe != null) {
                            int selectedModelRow = GuiDownloads.this.tabelle.convertRowIndexToModel(nr);
                            DatenFilm film = Daten.listeFilme.getFilmByUrl(GuiDownloads.this.tabelle.getModel().getValueAt(selectedModelRow, 9).toString());
                            if (film != null) {
                                GuiDownloads.this.ddaten.history.add(film.getUrlOrg());
                                GuiDownloads.this.ddaten.starterClass.urlStarten(gruppe, film);
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Abspielen festlegen.", "kein Videoplayer!", 1);
                        }
                    }
                }
            });
            jPopupMenu.add(itemPlayer);
            JMenuItem itemInfo = new JMenuItem("Infos anzeigen");
            itemInfo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiDownloads.this.dialogDatenFilm.setVis();
                }
            });
            jPopupMenu.add(itemInfo);
            JMenuItem item = new JMenuItem("Spalten zur\u00fccksetzen");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiDownloads.this.tabelle.resetTabelle();
                }
            });
            jPopupMenu.add(item);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private class BeobachterTableSelect1
    implements ListSelectionListener {
        public int selectedModelRow = -1;

        private BeobachterTableSelect1() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                GuiDownloads.this.dialogDatenFilmSetzen();
            }
        }
    }
}

