/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.daten.Daten;
import mediathek.tool.GuiFunktionen;

public final class InfoPanel
extends JPanel {
    public static final int IDX_NIX = 0;
    public static final int IDX_GUI_FILME = 1;
    public static final int IDX_GUI_DOWNLOAD = 2;
    public static final int IDX_GUI_ABO = 3;
    private final int IDX_MAX = 4;
    private String[] idx = new String[4];
    private int aktIdx = 0;
    private boolean stopTimer = false;
    private String textRechts;
    private int sekunden;
    private int minuten;
    private String sek;
    private String min;
    private String stu;
    private JButton jButtonStop;
    private JLabel jLabelRechts;
    private JLabel jLabelStatusLinks;
    private JProgressBar jProgressBar1;

    public InfoPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.clearProgress();
        for (int i = 0; i < 4; ++i) {
            this.idx[i] = "";
        }
        this.jLabelStatusLinks.setMinimumSize(new Dimension(25, 25));
        this.jLabelRechts.setMinimumSize(new Dimension(25, 25));
        this.jButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.filmeLaden.setStop();
            }
        });
        new Thread(new TimerClass()).start();
    }

    public void setTextLinks(int i, String text) {
        this.idx[i] = text;
        this.setIdx(this.aktIdx);
    }

    public void setIdx(int i) {
        this.aktIdx = i;
        this.jLabelStatusLinks.setText(this.idx[i]);
    }

    public void setProgressBar(ListenerFilmeLadenEvent event) {
        this.stopTimer = true;
        this.jProgressBar1.setVisible(true);
        this.jButtonStop.setVisible(true);
        if (event.max == 0) {
            this.jProgressBar1.setIndeterminate(true);
            this.jProgressBar1.setMaximum(0);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setStringPainted(false);
        } else {
            this.jProgressBar1.setIndeterminate(false);
            this.jProgressBar1.setMaximum(event.max);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(event.progress);
            this.jProgressBar1.setStringPainted(true);
        }
        this.jLabelRechts.setText(GuiFunktionen.textLaenge(60, event.text, true, true));
    }

    public void clearProgress() {
        this.stopTimer = false;
        this.jProgressBar1.setVisible(false);
        this.jButtonStop.setVisible(false);
        this.setInfoRechts();
    }

    private void setInfoRechts() {
        this.textRechts = "Filmliste erstellt: ";
        this.textRechts = this.textRechts + Daten.listeFilme.erstellt();
        this.textRechts = this.textRechts + " Uhr  ";
        this.sekunden = Daten.listeFilme.alterFilmlisteSek();
        if (this.sekunden != 0) {
            this.textRechts = this.textRechts + "||  Alter: ";
            this.minuten = this.sekunden / 60;
            this.sek = String.valueOf(this.sekunden % 60);
            this.min = String.valueOf(this.minuten % 60);
            this.stu = String.valueOf(this.minuten / 60);
            while (this.sek.length() < 2) {
                this.sek = "0" + this.sek;
            }
            while (this.min.length() < 2) {
                this.min = "0" + this.min;
            }
            while (this.stu.length() < 2) {
                this.stu = "0" + this.stu;
            }
            this.textRechts = this.textRechts + this.stu + ":" + this.min + ":" + this.sek + " ";
        }
        this.jLabelRechts.setText(this.textRechts);
    }

    private void initComponents() {
        this.jLabelStatusLinks = new JLabel();
        this.jLabelRechts = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jButtonStop = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.setMinimumSize(new Dimension(15, 15));
        this.jLabelStatusLinks.setText("jLabel2");
        this.jLabelRechts.setText("jLabel1");
        this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/stop_16.png")));
        this.jButtonStop.setToolTipText("Abbrechen");
        this.jButtonStop.setIconTextGap(1);
        this.jButtonStop.setMargin(new Insets(0, 10, 0, 10));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelStatusLinks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addComponent(this.jLabelRechts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelStatusLinks).addComponent(this.jLabelRechts).addComponent(this.jProgressBar1, -2, -1, -2).addComponent(this.jButtonStop)));
        layout.linkSize(1, this.jButtonStop, this.jProgressBar1);
    }

    private class TimerClass
    implements Runnable {
        private final int WARTEZEIT = 1000;

        private TimerClass() {
        }

        @Override
        public synchronized void run() {
            while (true) {
                this.schlafen();
                if (InfoPanel.this.stopTimer) continue;
                InfoPanel.this.setInfoRechts();
            }
        }

        private void schlafen() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

