/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mediathek.daten.DDaten;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.tool.EscBeenden;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.Log;

public class DialogAddDownload
extends JDialog {
    private DatenPset pSet = null;
    private boolean ok = false;
    private DatenDownload datenDownload = null;
    private DDaten ddaten;
    private DatenFilm datenFilm;
    private JButton jButtonAbbrechen;
    private JButton jButtonBeenden;
    private JButton jButtonZiel;
    private JCheckBox jCheckBoxStarten;
    private JComboBox jComboBoxPgr;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPfad;
    private JTextField jTextFieldSender;
    private JTextField jTextFieldTitel;

    public DialogAddDownload(Frame parent, DDaten dd, DatenFilm film) {
        super(parent, true);
        this.initComponents();
        this.ddaten = dd;
        this.datenFilm = film;
        this.setTitle("Film Speichern");
        this.init();
    }

    private void init() {
        if (this.ddaten.listePset.getListeSpeichern().size() == 0) {
            JOptionPane.showMessageDialog(null, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Aufzeichnen festlegen.", "kein Videoplayer!", 1);
            this.ok = false;
            this.beenden();
        }
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        this.jButtonBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogAddDownload.this.check()) {
                    DialogAddDownload.this.beenden();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonBeenden);
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogAddDownload.this.ok = false;
                DialogAddDownload.this.beenden();
            }
        };
        this.jButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogAddDownload.this.ok = false;
                DialogAddDownload.this.beenden();
            }
        });
        this.jComboBoxPgr.setModel(new DefaultComboBoxModel<String>(this.ddaten.listePset.getListeSpeichern().getObjectDataCombo()));
        this.setGruppe();
        if (this.ddaten.listePset.getListeSpeichern().size() == 1) {
            this.jComboBoxPgr.setEnabled(false);
        } else {
            this.jComboBoxPgr.addActionListener(new BeobComboProgramm());
        }
        this.jTextFieldSender.setText(this.datenFilm.arr[1]);
        this.jTextFieldTitel.setText(this.datenFilm.arr[3]);
    }

    private void setGruppe() {
        this.pSet = (DatenPset)this.ddaten.listePset.getListeSpeichern().get(this.jComboBoxPgr.getSelectedIndex());
        this.datenDownload = new DatenDownload(this.pSet, this.datenFilm, 2, null, "", "");
        if (this.datenDownload.arr[16].equals("")) {
            this.jTextFieldName.setEnabled(false);
            this.jTextFieldPfad.setEnabled(false);
            this.jButtonZiel.setEnabled(false);
            this.jTextFieldName.setText("");
            this.jTextFieldPfad.setText("");
        } else {
            this.jTextFieldName.setEnabled(true);
            this.jTextFieldPfad.setEnabled(true);
            this.jButtonZiel.setEnabled(true);
            this.jTextFieldName.setText(this.datenDownload.arr[16]);
            this.jTextFieldPfad.setText(this.datenDownload.arr[17]);
        }
    }

    private boolean check() {
        this.ok = false;
        String pfad = this.jTextFieldPfad.getText();
        String name = this.jTextFieldName.getText();
        if (this.datenDownload != null) {
            if (pfad.equals("") || name.equals("")) {
                JOptionPane.showMessageDialog(null, "Pfad oder Name ist leer", "Fehlerhafter Pfad/Name!", 0);
            } else {
                if (!pfad.substring(pfad.length() - 1).equals(File.separator)) {
                    pfad = pfad + File.separator;
                }
                if (GuiFunktionenProgramme.checkPfadBeschreibbar(pfad)) {
                    this.ok = true;
                } else {
                    JOptionPane.showMessageDialog(null, "Pfad ist nicht beschreibbar", "Fehlerhafter Pfad!", 0);
                }
            }
        }
        return this.ok;
    }

    private void beenden() {
        if (this.ok) {
            this.datenDownload = new DatenDownload(this.pSet, this.datenFilm, 2, null, this.jTextFieldName.getText(), this.jTextFieldPfad.getText());
            this.ddaten.listeDownloads.addMitNummer(this.datenDownload);
            ListenerMediathekView.notify(9, this.getClass().getSimpleName());
            if (this.jCheckBoxStarten.isSelected()) {
                this.datenDownload.starten(this.ddaten);
            }
        }
        this.dispose();
    }

    private void initComponents() {
        this.jButtonBeenden = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.jCheckBoxStarten = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldTitel = new JTextField();
        this.jTextFieldSender = new JTextField();
        this.jPanel5 = new JPanel();
        this.jComboBoxPgr = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jTextFieldName = new JTextField();
        this.jButtonZiel = new JButton();
        this.jTextFieldPfad = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jButtonBeenden.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jCheckBoxStarten.setSelected(true);
        this.jCheckBoxStarten.setText("Download sofort starten");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Film"));
        this.jLabel2.setText("Sender:");
        this.jLabel3.setText("Titel:");
        this.jTextFieldTitel.setEditable(false);
        this.jTextFieldTitel.setText("jTextField2");
        this.jTextFieldSender.setEditable(false);
        this.jTextFieldSender.setText("jTextField1");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldSender).addComponent(this.jTextFieldTitel)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.jTextFieldSender, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel3).addComponent(this.jTextFieldTitel, -2, 25, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(1, this.jTextFieldSender, this.jTextFieldTitel);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Programmset zum Aufzeichnen"));
        this.jComboBoxPgr.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBoxPgr, 0, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBoxPgr, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Speicherort"));
        this.jButtonZiel.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/fileopen_16.png")));
        this.jLabel1.setText("Zielpfad:");
        this.jLabel4.setText("Dateiname:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPfad).addComponent(this.jTextFieldName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jTextFieldPfad, -2, -1, -2).addComponent(this.jButtonZiel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.jTextFieldName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldName, this.jTextFieldPfad);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxStarten).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 74, Short.MAX_VALUE).addComponent(this.jButtonBeenden, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonAbbrechen))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonBeenden);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButtonBeenden).addComponent(this.jButtonAbbrechen).addComponent(this.jCheckBoxStarten)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            if (!DialogAddDownload.this.jTextFieldPfad.getText().equals("")) {
                chooser.setCurrentDirectory(new File(DialogAddDownload.this.jTextFieldPfad.getText()));
            }
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    DialogAddDownload.this.jTextFieldPfad.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    Log.fehlerMeldung(356871087, 0, "DialogAddDownload.ZielBeobachter", ex);
                }
            }
        }
    }

    private class BeobComboProgramm
    implements ActionListener {
        private BeobComboProgramm() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogAddDownload.this.setGruppe();
        }
    }
}

