/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.controller.io.starter.Start;
import mediathek.daten.DDaten;
import mediathek.tool.GuiKonstanten;
import mediathek.tool.Log;

public class CellRendererDownloads
extends DefaultTableCellRenderer {
    private DDaten ddaten;

    public CellRendererDownloads(DDaten d) {
        this.ddaten = d;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.setBackground(null);
            this.setForeground(null);
            this.setFont(null);
            this.setIcon(null);
            this.setHorizontalAlignment(10);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int r = table.convertRowIndexToModel(row);
            int c = table.convertColumnIndexToModel(column);
            String url = table.getModel().getValueAt(r, 9).toString();
            boolean abo = !table.getModel().getValueAt(r, 2).equals("");
            Start s = this.ddaten.starterClass.getStart(url);
            if (s != null) {
                this.setColor(this, s, isSelected);
                if (c == 6) {
                    int i = Integer.parseInt(s.datenDownload.arr[6]);
                    this.setHorizontalAlignment(0);
                    if (i == -1) {
                        this.setText("");
                    } else if (i == 0) {
                        this.setText("warten");
                    } else if (i == 1) {
                        this.setText("gestartet");
                    } else {
                        if (1 < i && i < 1000) {
                            JProgressBar progressBar = new JProgressBar(0, 1000);
                            JPanel panel = new JPanel(new BorderLayout());
                            this.setColor(panel, s, isSelected);
                            this.setColor(progressBar, s, isSelected);
                            progressBar.setBorder(BorderFactory.createEmptyBorder());
                            progressBar.setStringPainted(true);
                            progressBar.setUI(new BasicProgressBarUI(){

                                @Override
                                protected Color getSelectionBackground() {
                                    return UIManager.getDefaults().getColor("Table.foreground");
                                }

                                @Override
                                protected Color getSelectionForeground() {
                                    return Color.white;
                                }
                            });
                            panel.add(progressBar);
                            panel.setBorder(BorderFactory.createEmptyBorder());
                            progressBar.setValue(i);
                            double d = (double)i / 10.0;
                            progressBar.setString(Double.toString(d) + "%");
                            return panel;
                        }
                        if (i == 1000) {
                            if (s != null) {
                                if (s.status == 4) {
                                    this.setText("fehlerhaft");
                                } else {
                                    this.setText("fertig");
                                }
                            } else {
                                this.setText("fertig");
                            }
                        }
                    }
                }
            } else if (c == 6) {
                this.setText("");
            }
            if (c == 2) {
                this.setFont(new Font("Dialog", 1, 12));
                if (abo) {
                    this.setForeground(GuiKonstanten.ABO_FOREGROUND);
                } else {
                    this.setForeground(GuiKonstanten.DOWNLOAD_FOREGROUND);
                    this.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_12.png")));
                    this.setHorizontalAlignment(0);
                }
            }
            if (c == 15) {
                boolean restart = this.ddaten.listeDownloads.getDownloadByUrl(url).isRestart();
                this.setHorizontalAlignment(0);
                if (restart) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/ja_16.png")));
                } else {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_12.png")));
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(758200166, 0, this.getClass().getName(), ex);
        }
        return this;
    }

    private void setColor(Component c, Start s, boolean isSelected) {
        switch (s.status) {
            case 1: {
                if (isSelected) {
                    c.setBackground(GuiKonstanten.DOWNLOAD_FARBE_WAIT_SEL);
                    break;
                }
                c.setBackground(GuiKonstanten.DOWNLOAD_FARBE_WAIT);
                break;
            }
            case 2: {
                if (isSelected) {
                    c.setBackground(GuiKonstanten.DOWNLOAD_FARBE_RUN_SEL);
                    break;
                }
                c.setBackground(GuiKonstanten.DOWNLOAD_FARBE_RUN);
                break;
            }
            case 3: {
                if (isSelected) {
                    c.setBackground(GuiKonstanten.DOWNLOAD_FARBE_FERTIG_SEL);
                    break;
                }
                c.setBackground(GuiKonstanten.DOWNLOAD_FARBE_FERTIG);
                break;
            }
            case 4: {
                if (isSelected) {
                    c.setBackground(GuiKonstanten.DOWNLOAD_FARBE_ERR_SEL);
                    break;
                }
                c.setBackground(GuiKonstanten.DOWNLOAD_FARBE_ERR);
            }
        }
    }
}

